/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.concurrent;

import java.util.concurrent.atomic.AtomicReference;

public class LMSQueue<V> {
    private AtomicReference<Node<V>> head;
    private AtomicReference<Node<V>> tail;
    public final Node<V> dummyNode = new Node<Object>(null);

    public void enqueue(V val) {
        Node<V> tl;
        if (val == null) {
            throw new IllegalArgumentException("Cannot enqueue null value");
        }
        Node<V> nd = new Node<V>(val);
        do {
            tl = this.tail.get();
            nd.next = tl;
        } while (!this.tail.compareAndSet(tl, nd));
        this.tail.get().prev = nd;
    }

    public V dequeue() {
        while (true) {
            Node<V> hd = this.head.get();
            Node<V> tl = this.tail.get();
            Node firstNodePrev = hd.prev;
            V val = hd.getValue();
            if (hd != this.head.get()) continue;
            if (val != null) {
                if (tl != hd) {
                    if (firstNodePrev == null) {
                        this.fixList(tl, hd);
                        continue;
                    }
                } else {
                    Node<Object> ndDummy = new Node<Object>(null);
                    ndDummy.next = tl;
                    if (this.tail.compareAndSet(tl, ndDummy)) {
                        hd.prev = ndDummy;
                        continue;
                    }
                    ndDummy = null;
                    continue;
                }
                if (!this.head.compareAndSet(hd, firstNodePrev)) continue;
                hd = null;
                return val;
            }
            if (this.tail == this.head) {
                return null;
            }
            if (firstNodePrev == null) {
                this.fixList(tl, hd);
                continue;
            }
            this.head.compareAndSet(hd, firstNodePrev);
        }
    }

    private void fixList(Node<V> tl, Node<V> hd) {
        Node<V> curNode = tl;
        Node curNodeNext = null;
        Node nextNodePrev = null;
        while (hd == this.head.get() && curNode != this.head.get()) {
            curNodeNext = curNode.next;
            if (curNodeNext == null) {
                return;
            }
            nextNodePrev = curNodeNext.prev;
            if (nextNodePrev != curNode) {
                curNodeNext.prev = curNode;
            }
            curNode = curNodeNext;
        }
    }

    private static class Node<V> {
        private V value;
        Node<V> next;
        Node<V> prev;

        public Node(V value) {
            this.value = value;
        }

        public V getValue() {
            return this.value;
        }
    }
}

