/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.jdeparser.AbstractJClassDef;
import org.jboss.jdeparser.AbstractJGeneric;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.BasicJBlock;
import org.jboss.jdeparser.ClassContent;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.ImplJParamDeclaration;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JComment;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JMod;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens$;

abstract class AbstractJMethodDef
extends AbstractJGeneric
implements JMethodDef,
ClassContent {
    private final AbstractJClassDef clazz;
    private int mods;
    private ArrayList<ImplJParamDeclaration> params;
    private ArrayList<AbstractJType> _throws;
    private BasicJBlock body;

    AbstractJMethodDef(AbstractJClassDef clazz, int mods) {
        this.clazz = clazz;
        this.mods = mods;
    }

    @Override
    public JBlock _default() {
        throw new UnsupportedOperationException("Default method implementation");
    }

    @Override
    public JMethodDef _default(JExpr expr) {
        throw new UnsupportedOperationException("Default method value");
    }

    @Override
    public JBlock body() {
        if (!this.writeBody()) {
            throw new UnsupportedOperationException("Method body on abstract method");
        }
        if (this.body == null) {
            this.body = new BasicJBlock(null, JBlock.Braces.REQUIRED);
        }
        return this.body;
    }

    @Override
    public JComment returnsDoc() {
        return null;
    }

    private ImplJParamDeclaration add(ImplJParamDeclaration item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        this.params.add(item);
        return item;
    }

    @Override
    public JParamDeclaration param(int mods, JType type, String name) {
        if (JMod.anyAreSet(this.mods, Integer.MIN_VALUE)) {
            throw new IllegalStateException("Vararg parameter already added");
        }
        return this.add(new ImplJParamDeclaration(mods, type, name));
    }

    @Override
    public JParamDeclaration param(JType type, String name) {
        return this.param(0, type, name);
    }

    @Override
    public JParamDeclaration param(int mods, String type, String name) {
        return this.param(mods, JTypes.typeNamed(type), name);
    }

    @Override
    public JParamDeclaration param(String type, String name) {
        return this.param(JTypes.typeNamed(type), name);
    }

    @Override
    public JParamDeclaration param(int mods, Class<?> type, String name) {
        return this.param(mods, JTypes.typeOf(type), name);
    }

    @Override
    public JParamDeclaration param(Class<?> type, String name) {
        return this.param(JTypes.typeOf(type), name);
    }

    @Override
    public JParamDeclaration varargParam(int mods, JType type, String name) {
        if (JMod.anyAreSet(this.mods, Integer.MIN_VALUE)) {
            throw new IllegalStateException("Vararg parameter already added");
        }
        this.mods |= Integer.MIN_VALUE;
        return this.add(new ImplJParamDeclaration(mods | Integer.MIN_VALUE, type, name));
    }

    @Override
    public JParamDeclaration varargParam(JType type, String name) {
        return this.varargParam(0, type, name);
    }

    @Override
    public JParamDeclaration varargParam(int mods, String type, String name) {
        return this.varargParam(mods, JTypes.typeNamed(type), name);
    }

    @Override
    public JParamDeclaration varargParam(String type, String name) {
        return this.varargParam(JTypes.typeNamed(type), name);
    }

    @Override
    public JParamDeclaration varargParam(int mods, Class<?> type, String name) {
        return this.varargParam(mods, JTypes.typeOf(type), name);
    }

    @Override
    public JParamDeclaration varargParam(Class<?> type, String name) {
        return this.varargParam(JTypes.typeOf(type), name);
    }

    @Override
    public JParamDeclaration[] params() {
        return this.params.toArray(new JParamDeclaration[this.params.size()]);
    }

    @Override
    public JComment _throws(String type) {
        return this._throws(JTypes.typeNamed(type));
    }

    @Override
    public JComment _throws(JType type) {
        if (this._throws == null) {
            this._throws = new ArrayList();
        }
        this._throws.add(AbstractJType.of(type));
        return null;
    }

    @Override
    public JComment _throws(Class<? extends Throwable> type) {
        return this._throws(JTypes.typeOf(type));
    }

    int getModifiers() {
        return this.mods;
    }

    boolean writeBody() {
        return this.clazz.methodCanHaveBody(this.mods);
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        Iterator<Object> iterator;
        writer.write(FormatPreferences.Space.BEFORE_PAREN_METHOD_DECLARATION);
        writer.write(Tokens$.PUNCT.PAREN.OPEN);
        if (this.params != null) {
            writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_DECLARATION);
            iterator = this.params.iterator();
            if (iterator.hasNext()) {
                iterator.next().write(writer);
                while (iterator.hasNext()) {
                    writer.write(FormatPreferences.Space.BEFORE_COMMA);
                    writer.write(Tokens$.PUNCT.COMMA);
                    writer.write(FormatPreferences.Space.AFTER_COMMA);
                    ((ImplJParamDeclaration)iterator.next()).write(writer);
                }
            }
        } else {
            writer.write(FormatPreferences.Space.WITHIN_PAREN_METHOD_DECLARATION_EMPTY);
        }
        writer.write(Tokens$.PUNCT.PAREN.CLOSE);
        if (this._throws != null && (iterator = this._throws.iterator()).hasNext()) {
            writer.sp();
            writer.write(Tokens$.KW.THROWS);
            writer.write((AbstractJType)iterator.next());
            while (iterator.hasNext()) {
                writer.write(FormatPreferences.Space.BEFORE_COMMA);
                writer.write(Tokens$.PUNCT.COMMA);
                writer.write(FormatPreferences.Space.AFTER_COMMA);
                writer.write((AbstractJType)iterator.next());
            }
        }
        this.writePostfix(writer);
        if (!this.writeBody()) {
            writer.write(Tokens$.PUNCT.SEMI);
        } else {
            writer.write(FormatPreferences.Space.BEFORE_BRACE_METHOD);
            if (this.body == null) {
                writer.write(Tokens$.PUNCT.BRACE.OPEN);
                writer.write(FormatPreferences.Space.WITHIN_BRACES_EMPTY);
                writer.write(Tokens$.PUNCT.BRACE.CLOSE);
            } else {
                this.body.write(writer);
            }
        }
    }

    void writePostfix(SourceFileWriter writer) throws IOException {
    }

    AbstractJClassDef clazz() {
        return this.clazz;
    }
}

