/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.LockModeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.StoredProcedureQueryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.EntityResult;
import org.eclipse.persistence.queries.SQLResult;
import org.eclipse.persistence.queries.SQLResultSetMapping;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.Session;

public class JPAQuery
extends DatabaseQuery {
    private String lockMode;
    private String jpqlString;
    private String sqlString;
    private StoredProcedureCall call;
    private String resultClassName;
    private List<String> resultClassNames;
    private List<String> resultSetMappingNames;
    private SQLResultSetMapping localResultSetMapping;
    private Map<String, Object> hints;

    public JPAQuery() {
    }

    public JPAQuery(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public JPAQuery(String name, String jpqlString, String lockMode, Map<String, Object> hints) {
        this.name = name;
        this.jpqlString = jpqlString;
        this.flushOnExecute = null;
        this.hints = hints;
        this.lockMode = lockMode;
        if (lockMode == null) {
            this.lockMode = "NONE";
        }
    }

    public JPAQuery(String queryName, String sqlString, Map<String, Object> hints) {
        this.name = queryName;
        this.sqlString = sqlString;
        this.flushOnExecute = null;
        this.hints = hints;
        this.lockMode = null;
    }

    public JPAQuery(String queryName, StoredProcedureCall call, Map<String, Object> hints) {
        this.name = queryName;
        this.call = call;
        this.flushOnExecute = null;
        this.hints = hints;
        this.lockMode = null;
    }

    public void addResultClassNames(String className) {
        if (this.resultClassNames == null) {
            this.resultClassNames = new ArrayList<String>();
        }
        this.resultClassNames.add(className);
    }

    public void addResultSetMapping(String resultSetMapping) {
        if (this.resultSetMappingNames == null) {
            this.resultSetMappingNames = new ArrayList<String>();
        }
        this.resultSetMappingNames.add(resultSetMapping);
    }

    public Object executeDatabaseQuery() throws DatabaseException, OptimisticLockException {
        return this.getSession().executeQuery(this.getDatabaseQuery());
    }

    public DatabaseQuery getDatabaseQuery() {
        return (DatabaseQuery)this.getProperty("databasequery");
    }

    public List<ClassDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public Map<String, Object> getHints() {
        return this.hints;
    }

    public String getJPQLString() {
        return this.jpqlString;
    }

    public boolean isJPQLQuery() {
        return this.jpqlString != null;
    }

    public boolean isSQLQuery() {
        return this.sqlString != null;
    }

    public void prepare() {
        DatabaseQuery query = null;
        ClassLoader loader = this.session.getDatasourcePlatform().getConversionManager().getLoader();
        if (this.isSQLQuery()) {
            query = this.processSQLQuery((Session)this.getSession());
        } else if (this.isJPQLQuery()) {
            query = this.processJPQLQuery((Session)this.getSession());
        } else if (this.call != null) {
            query = this.processStoredProcedureQuery((Session)this.getSession());
            if (this.call.hasParameters()) {
                for (Object value : this.call.getParameters()) {
                    if (value instanceof Object[]) {
                        ((DatabaseField)((Object[])value)[1]).convertClassNamesToClasses(loader);
                        value = ((Object[])value)[0];
                    }
                    if (!(value instanceof DatabaseField)) continue;
                    ((DatabaseField)value).convertClassNamesToClasses(loader);
                }
            }
        }
        query.convertClassNamesToClasses(loader);
        this.setDatabaseQuery(query);
    }

    public DatabaseQuery processJPQLQuery(Session session) {
        ClassLoader classloader = session.getDatasourcePlatform().getConversionManager().getLoader();
        LockModeType lockModeEnum = null;
        try {
            lockModeEnum = LockModeType.valueOf((String)this.lockMode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        DatabaseQuery ejbquery = EJBQueryImpl.buildEJBQLDatabaseQuery(this.getName(), this.jpqlString, (AbstractSession)session, (Enum)lockModeEnum, this.hints, classloader);
        ejbquery.setName(this.getName());
        return ejbquery;
    }

    public DatabaseQuery processSQLQuery(Session session) {
        DatabaseQuery query = null;
        ClassLoader loader = session.getDatasourcePlatform().getConversionManager().getLoader();
        if (this.resultClassName != null) {
            Class clazz = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.resultClassName);
            query = EJBQueryImpl.buildSQLDatabaseQuery(clazz, this.sqlString, this.hints, loader, (AbstractSession)session);
        } else {
            query = this.localResultSetMapping != null ? EJBQueryImpl.buildSQLDatabaseQuery(this.localResultSetMapping, this.sqlString, this.hints, loader, (AbstractSession)session) : (this.resultSetMappingNames != null ? EJBQueryImpl.buildSQLDatabaseQuery(this.resultSetMappingNames.get(0), this.sqlString, this.hints, loader, (AbstractSession)session) : EJBQueryImpl.buildSQLDatabaseQuery(this.sqlString, this.hints, loader, (AbstractSession)session));
        }
        query.setName(this.getName());
        return query;
    }

    public DatabaseQuery processStoredProcedureQuery(Session session) {
        DatabaseQuery query = null;
        ClassLoader loader = session.getDatasourcePlatform().getConversionManager().getLoader();
        if (this.resultClassNames != null) {
            ArrayList<SQLResultSetMapping> resultSetMappings = new ArrayList<SQLResultSetMapping>();
            for (String resultClass : this.resultClassNames) {
                SQLResultSetMapping mapping = new SQLResultSetMapping(resultClass);
                EntityResult entityResult = new EntityResult(resultClass);
                mapping.addResult((SQLResult)entityResult);
                resultSetMappings.add(mapping);
            }
            query = StoredProcedureQueryImpl.buildResultSetMappingQuery(resultSetMappings, this.call, this.hints, loader, (AbstractSession)session);
        } else if (this.resultSetMappingNames != null) {
            query = StoredProcedureQueryImpl.buildResultSetMappingNameQuery(this.resultSetMappingNames, this.call, this.hints, loader, (AbstractSession)session);
        } else if (this.resultClassName != null) {
            Class clazz = session.getDatasourcePlatform().getConversionManager().convertClassNameToClass(this.resultClassName);
            query = StoredProcedureQueryImpl.buildStoredProcedureQuery(clazz, this.call, this.hints, loader, (AbstractSession)session);
        } else {
            query = this.call.isStoredFunctionCall() || this.call.isStoredPLSQLProcedureCall() ? StoredProcedureQueryImpl.buildStoredProcedureQuery(this.call, this.hints, loader, (AbstractSession)session) : StoredProcedureQueryImpl.buildResultSetMappingQuery(new ArrayList<SQLResultSetMapping>(), this.call, this.hints, loader, (AbstractSession)session);
        }
        query.setName(this.getName());
        return query;
    }

    public void setDatabaseQuery(DatabaseQuery databaseQuery) {
        this.setProperty("databasequery", databaseQuery);
    }

    public void setDescriptors(List<ClassDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    public void setHints(Map<String, Object> hints) {
        this.hints = hints;
    }

    public void setJPQLString(String jpqlString) {
        this.jpqlString = jpqlString;
    }

    public void setResultClassName(String className) {
        this.resultClassName = className;
    }

    public void setResultSetMappings(List<String> resultSetMappings) {
        this.resultSetMappingNames = resultSetMappings;
    }

    public void setLocalResultSetMapping(SQLResultSetMapping localResultSetMapping) {
        this.localResultSetMapping = localResultSetMapping;
    }
}

