/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws;

import com.sun.istack.tools.MaskingClassLoader;
import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.resources.WscompileMessages;
import com.sun.tools.ws.wscompile.Options;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.namespace.QName;
import org.glassfish.jaxb.core.util.Which;

public final class Invoker {
    static final String[] maskedPackages = new String[]{"com.sun.istack.tools.", "com.sun.tools.jxc.", "com.sun.tools.xjc.", "com.sun.tools.ws.", "com.sun.codemodel.", "com.sun.relaxng.", "com.sun.xml.xsom.", "com.sun.xml.bind.", "org.glassfish.jaxb.", "com.ctc.wstx.", "org.codehaus.stax2.", "com.sun.xml.messaging.saaj.", "com.sun.xml.ws.", "com.oracle.webservices.api."};
    public static final boolean noSystemProxies;

    private Invoker() {
    }

    static int invoke(String mainClass, String[] args) throws Throwable {
        if (!noSystemProxies) {
            try {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        ClassLoader oldcc = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = Invoker.class.getClassLoader();
            int targetArgIndex = Arrays.asList(args).indexOf("-target");
            Options.Target targetVersion = targetArgIndex != -1 ? Options.Target.parse(args[targetArgIndex + 1]) : Options.Target.getDefault();
            Options.Target loadedVersion = Options.Target.getLoadedAPIVersion();
            if (!loadedVersion.isLaterThan(targetVersion)) {
                if (Service.class.getClassLoader() == null) {
                    System.err.println(WscompileMessages.INVOKER_NEED_ENDORSED(loadedVersion.getVersion(), targetVersion.getVersion()));
                } else {
                    System.err.println(WscompileMessages.WRAPPER_TASK_LOADING_INCORRECT_API(loadedVersion.getVersion(), Which.which(Service.class), targetVersion.getVersion()));
                }
                int n = -1;
                return n;
            }
            if (cl == null) {
                cl = oldcc;
            }
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> compileTool = cl.loadClass(mainClass);
            Constructor<?> ctor = compileTool.getConstructor(OutputStream.class);
            Object tool = ctor.newInstance(System.out);
            Method runMethod = compileTool.getMethod("run", String[].class);
            boolean r = (Boolean)runMethod.invoke(tool, new Object[]{args});
            int n = r ? 0 : 1;
            return n;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldcc);
        }
    }

    public static boolean checkIfLoading21API() {
        try {
            Service.class.getMethod("getPort", Class.class, WebServiceFeature[].class);
            return true;
        }
        catch (LinkageError | NoSuchMethodException throwable) {
            return false;
        }
    }

    public static boolean checkIfLoading22API() {
        try {
            Service.class.getMethod("create", URL.class, QName.class, WebServiceFeature[].class);
            return true;
        }
        catch (LinkageError | NoSuchMethodException throwable) {
            return false;
        }
    }

    public static ClassLoader createClassLoader(ClassLoader cl) throws ClassNotFoundException, IOException {
        URL[] urls = Invoker.findIstack22APIs(cl);
        if (urls.length == 0) {
            return cl;
        }
        ArrayList<String> mask = new ArrayList<String>(Arrays.asList(maskedPackages));
        if (urls.length > 1) {
            mask.add("jakarta.xml.bind.");
            mask.add("jakarta.xml.ws.");
        }
        cl = new MaskingClassLoader(cl, mask);
        cl = new URLClassLoader(urls, cl);
        cl = new ParallelWorldClassLoader(cl, "");
        return cl;
    }

    private static URL[] findIstack22APIs(ClassLoader cl) throws ClassNotFoundException, IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (Service.class.getClassLoader() == null) {
            URL res = cl.getResource("jakarta/xml/ws/EndpointContext.class");
            if (res == null) {
                throw new ClassNotFoundException("There's no JAX-WS 2.2 API in the classpath");
            }
            urls.add(ParallelWorldClassLoader.toJarUrl((URL)res));
            res = cl.getResource("jakarta/xml/bind/JAXBPermission.class");
            if (res == null) {
                throw new ClassNotFoundException("There's no JAXB 2.2 API in the classpath");
            }
            urls.add(ParallelWorldClassLoader.toJarUrl((URL)res));
        }
        return urls.toArray(new URL[0]);
    }

    static {
        boolean noSysProxiesProperty = false;
        try {
            noSysProxiesProperty = Boolean.getBoolean(Invoker.class.getName() + ".noSystemProxies");
        }
        catch (SecurityException securityException) {
        }
        finally {
            noSystemProxies = noSysProxiesProperty;
        }
    }
}

