/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.misc;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class CorbaResourceUtil {
    private static boolean resourcesInitialized = false;
    private static ResourceBundle resources;

    public static String getString(String key) {
        if (!resourcesInitialized) {
            CorbaResourceUtil.initResources();
        }
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getText(String key) {
        Object message = CorbaResourceUtil.getString(key);
        if (message == null) {
            message = "no text found: \"" + key + "\"";
        }
        return message;
    }

    public static String getText(String key, Object ... args) {
        String format = CorbaResourceUtil.getString(key);
        if (format == null) {
            StringBuilder sb = new StringBuilder("no text found: key = \"");
            sb.append(key);
            sb.append("\", arguments = ");
            for (int ctr = 0; ctr < args.length; ++ctr) {
                if (ctr != 0) {
                    sb.append(", ");
                }
                sb.append("\"{");
                sb.append(ctr);
                sb.append("}\"");
            }
            format = sb.toString();
        }
        return MessageFormat.format(format, args);
    }

    private static void initResources() {
        try {
            resources = ResourceBundle.getBundle("com.sun.corba.ee.impl.resources.sunorb");
            resourcesInitialized = true;
        }
        catch (MissingResourceException e) {
            throw new Error("fatal: missing resource bundle: " + e.getClassName());
        }
    }
}

