/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.engine;

import jakarta.mvc.engine.ViewEngine;
import jakarta.mvc.engine.ViewEngineContext;
import jakarta.ws.rs.core.MediaType;
import java.nio.charset.Charset;
import org.eclipse.krazo.util.PathUtils;
import org.eclipse.krazo.util.PropertyUtils;

public abstract class ViewEngineBase
implements ViewEngine {
    protected String resolveView(ViewEngineContext context) {
        String view = context.getView();
        if (!PathUtils.hasStartingSlash(view)) {
            return PathUtils.ensureEndingSlash(this.getViewFolder(context)) + view;
        }
        return view;
    }

    protected String getViewFolder(ViewEngineContext context) {
        return PropertyUtils.getProperty(context.getConfiguration(), "jakarta.mvc.engine.ViewEngine.viewFolder", "/WEB-INF/views/");
    }

    protected Charset resolveCharsetAndSetContentType(ViewEngineContext context) {
        String charset = (String)context.getMediaType().getParameters().get("charset");
        if (charset == null) {
            charset = "UTF-8";
        }
        MediaType mediaType = context.getMediaType().withCharset(charset);
        context.getResponseHeaders().putSingle((Object)"Content-Type", (Object)mediaType.toString());
        return Charset.forName(charset);
    }
}

