/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.management.server;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MQObjectName {
    private static final String MBEAN_DOMAIN_NAME = "com.sun.messaging.jms.server";
    private static final String BROKER = "Broker";
    private static final String SERVICE_MANAGER = "ServiceManager";
    private static final String CONNECTION_MANAGER = "ConnectionManager";
    private static final String DESTINATION_MANAGER = "DestinationManager";
    private static final String CONSUMER_MANAGER = "ConsumerManager";
    private static final String PRODUCER_MANAGER = "ProducerManager";
    private static final String TRANSACTION_MANAGER = "TransactionManager";
    private static final String SERVICE = "Service";
    private static final String DESTINATION = "Destination";
    private static final String CONNECTION = "Connection";
    private static final String CLUSTER = "Cluster";
    private static final String LOG = "Log";
    private static final String JVM = "JVM";
    private static final String SUBTYPE_SUFFIX_CONFIG = ",subtype=Config";
    private static final String SUBTYPE_SUFFIX_MONITOR = ",subtype=Monitor";
    private static final String SERVICE_CONFIG_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Service,subtype=Config";
    private static final String DESTINATION_CONFIG_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Destination,subtype=Config";
    private static final String CONNECTION_CONFIG_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Connection,subtype=Config";
    private static final String SERVICE_MONITOR_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Service,subtype=Monitor";
    private static final String DESTINATION_MONITOR_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Destination,subtype=Monitor";
    private static final String CONNECTION_MONITOR_DOMAIN_TYPE = "com.sun.messaging.jms.server:type=Connection,subtype=Monitor";
    public static final String BROKER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=Broker,subtype=Config";
    public static final String CONNECTION_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=ConnectionManager,subtype=Config";
    public static final String CONSUMER_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=ConsumerManager,subtype=Config";
    public static final String SERVICE_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=ServiceManager,subtype=Config";
    public static final String DESTINATION_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=DestinationManager,subtype=Config";
    public static final String CLUSTER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=Cluster,subtype=Config";
    public static final String LOG_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=Log,subtype=Config";
    public static final String PRODUCER_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=ProducerManager,subtype=Config";
    public static final String TRANSACTION_MANAGER_CONFIG_MBEAN_NAME = "com.sun.messaging.jms.server:type=TransactionManager,subtype=Config";
    public static final String BROKER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=Broker,subtype=Monitor";
    public static final String SERVICE_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=ServiceManager,subtype=Monitor";
    public static final String DESTINATION_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=DestinationManager,subtype=Monitor";
    public static final String TRANSACTION_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=TransactionManager,subtype=Monitor";
    public static final String CONNECTION_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=ConnectionManager,subtype=Monitor";
    public static final String CONSUMER_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=ConsumerManager,subtype=Monitor";
    public static final String PRODUCER_MANAGER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=ProducerManager,subtype=Monitor";
    public static final String JVM_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=JVM,subtype=Monitor";
    public static final String CLUSTER_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=Cluster,subtype=Monitor";
    public static final String LOG_MONITOR_MBEAN_NAME = "com.sun.messaging.jms.server:type=Log,subtype=Monitor";

    private MQObjectName() {
    }

    public static ObjectName createServiceConfig(String serviceName) throws MalformedObjectNameException {
        String s = "com.sun.messaging.jms.server:type=Service,subtype=Config,name=" + serviceName;
        ObjectName o = new ObjectName(s);
        return o;
    }

    public static ObjectName createServiceMonitor(String serviceName) throws MalformedObjectNameException {
        String s = "com.sun.messaging.jms.server:type=Service,subtype=Monitor,name=" + serviceName;
        ObjectName o = new ObjectName(s);
        return o;
    }

    public static ObjectName createDestinationConfig(String destinationType, String destinationName) throws MalformedObjectNameException {
        String s = "com.sun.messaging.jms.server:type=Destination,subtype=Config,desttype=" + destinationType + ",name=" + ObjectName.quote(destinationName);
        ObjectName o = new ObjectName(s);
        return o;
    }

    public static ObjectName createDestinationMonitor(String destinationType, String destinationName) throws MalformedObjectNameException {
        String s = "com.sun.messaging.jms.server:type=Destination,subtype=Monitor,desttype=" + destinationType + ",name=" + ObjectName.quote(destinationName);
        ObjectName o = new ObjectName(s);
        return o;
    }

    public static ObjectName createConnectionConfig(String id) {
        String s = "com.sun.messaging.jms.server:type=Connection,subtype=Config,id=" + id;
        ObjectName o = null;
        try {
            o = new ObjectName(s);
        }
        catch (MalformedObjectNameException mfe) {
            throw new RuntimeException("Failed to create Message Queue object name", mfe);
        }
        return o;
    }

    public static ObjectName createConnectionMonitor(String id) {
        String s = "com.sun.messaging.jms.server:type=Connection,subtype=Monitor,id=" + id;
        ObjectName o = null;
        try {
            o = new ObjectName(s);
        }
        catch (MalformedObjectNameException mfe) {
            throw new RuntimeException("Failed to create Message Queue object name", mfe);
        }
        return o;
    }
}

