/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.internal;

import jakarta.enterprise.concurrent.CronTrigger;
import jakarta.enterprise.concurrent.LastExecution;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.Trigger;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CompoundTrigger
implements Trigger {
    private static final System.Logger LOG = System.getLogger(CompoundTrigger.class.getName());
    private final ManagedScheduledExecutorService mses;
    private final List<LateAwareTrigger> triggers = new ArrayList<LateAwareTrigger>();
    private long secondsLate;
    private ZonedDateTime nextField = null;

    public CompoundTrigger(ManagedScheduledExecutorService mses) {
        this.mses = mses;
    }

    public Date getNextRunTime(LastExecution lastExecutionInfo, Date taskScheduledTime) {
        ZonedDateTime now = ZonedDateTime.now();
        ChronoZonedDateTime next = null;
        for (LateAwareTrigger trigger : this.triggers) {
            ZonedDateTime nextTime = trigger.trigger().getNextRunTime(lastExecutionInfo, now);
            if (next != null && !next.isAfter(nextTime)) continue;
            next = nextTime;
            this.secondsLate = trigger.skipIfLateBySeconds();
            this.nextField = next;
        }
        return next == null ? null : Date.from(next.toInstant());
    }

    public boolean skipRun(LastExecution lastExecutionInfo, Date scheduledRunTime) {
        ZonedDateTime scheduledRunTimeJT = ZonedDateTime.ofInstant(scheduledRunTime.toInstant(), ZoneId.systemDefault());
        ZonedDateTime now = ZonedDateTime.now();
        LOG.log(System.Logger.Level.TRACE, () -> "Current trigger: " + String.valueOf(this.nextField) + ", scheduledRunTime: " + String.valueOf(scheduledRunTimeJT));
        return scheduledRunTimeJT.plus(this.secondsLate, ChronoUnit.SECONDS).isBefore(now);
    }

    public void addTrigger(CronTrigger trigger, long skipIfLateBySeconds) {
        this.triggers.add(new LateAwareTrigger(trigger, skipIfLateBySeconds));
    }

    private record LateAwareTrigger(CronTrigger trigger, long skipIfLateBySeconds) {
    }
}

