/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.server.AccessControlContext;
import com.sun.messaging.jmq.auth.api.server.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.JMQAccessControlContext;
import com.sun.messaging.jmq.jmsserver.auth.JMQAdminKeyAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.auth.JMQBasicAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.auth.JMQDigestAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.security.AccessControlException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Refreshable;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;

public class AccessController {
    public static final String PROP_SERVICE_NAME = "imq.servicename";
    public static final String PROP_SERVICE_TYPE = "imq.servicetype";
    public static final String PROP_AUTHENTICATION_AREA = "authentication";
    public static final String PROP_ACCESSCONTROL_AREA = "accesscontrol";
    public static final String PROP_USER_REPOSITORY_AREA = "user_repository";
    public static final String PROP_AUTHENTICATION_PREFIX = "imq.authentication.";
    public static final String PROP_ACCESSCONTROL_PREFIX = "imq.accesscontrol.";
    public static final String PROP_USER_REPOSITORY_PREFIX = "imq.user_repository.";
    public static final String PROP_USER_REPOSITORY_SUFFIX = ".user_repository";
    public static final String PROP_USER_PRINCIPAL_CLASS_SUFFIX = ".userPrincipalClass";
    public static final String PROP_GROUP_PRINCIPAL_CLASS_SUFFIX = ".groupPrincipalClass";
    public static final String PROP_CLIENTIP = "imq.authentication.clientip";
    public static final String PROP_AUTHENTICATION_TYPE = "imq.authentication.type";
    public static final String PROP_AUTHENTICATION_TYPE_SUFFIX = ".authentication.type";
    public static final String PROP_ACCESSCONTROL_TYPE = "imq.accesscontrol.type";
    public static final String PROP_ACCESSCONTROL_TYPE_SUFFIX = ".accesscontrol.type";
    public static final String PROP_ACCESSCONTROL_ENABLED = "imq.accesscontrol.enabled";
    public static final String PROP_ACCESSCONTROL_ENABLED_SUFFIX = ".accesscontrol.enabled";
    public static final String PROP_SERVICE_PREFIX = "imq.";
    public static final String PROPERTIES_DIRPATH = "dirpath";
    public static final String PROP_ADMINKEY = "imq.adminkey";
    public static final String AUTHTYPE_BASIC = "basic";
    public static final String AUTHTYPE_DIGEST = "digest";
    public static final String AUTHTYPE_JMQADMINKEY = "jmqadminkey";
    public static final String BAD_AUTHTYPE = "client";
    private String authType = "basic";
    private String userRepository = "";
    private boolean accessControlEnabled = true;
    private Properties authprops = new Properties();
    private Logger logger = Globals.getLogger();
    private AuthenticationProtocolHandler aph = null;
    private AccessControlContext acc = null;
    private String serviceName = null;
    private int serviceType = 0;
    private String clientIP = null;

    private AccessController() {
    }

    private void init() throws BrokerException {
        this.acc = null;
        if (this.authType.equals(AUTHTYPE_BASIC)) {
            this.aph = new JMQBasicAuthenticationHandler();
            return;
        }
        if (this.authType.equals(AUTHTYPE_DIGEST)) {
            this.aph = new JMQDigestAuthenticationHandler();
            return;
        }
        if (this.authType.equals(AUTHTYPE_JMQADMINKEY)) {
            this.aph = new JMQAdminKeyAuthenticationHandler();
            return;
        }
        String c = this.authprops.getProperty(PROP_AUTHENTICATION_PREFIX + this.authType + ".class");
        if (c == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4077", this.authType));
        }
        try {
            this.aph = (AuthenticationProtocolHandler)Class.forName(c).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (!this.aph.getType().equals(this.authType)) {
                Object[] args = new String[]{this.authType, this.aph.getType(), c};
                throw new BrokerException(Globals.getBrokerResources().getKString("B4078", args));
            }
        }
        catch (BrokerException e) {
            throw e;
        }
        catch (Throwable w) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4040", this.authType) + " - " + w.getMessage());
        }
    }

    public boolean isAuthenticated() {
        return this.acc != null;
    }

    public String getAuthType() {
        return this.authType;
    }

    private void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getUserRepository() {
        return this.userRepository;
    }

    private void setUserRepository(String v) {
        this.userRepository = v;
    }

    public boolean isAccessControlEnabled() {
        return this.accessControlEnabled;
    }

    private void setAccessControlEnabled(boolean enabled) {
        this.accessControlEnabled = enabled;
    }

    public Properties getAuthProperties() {
        return this.authprops;
    }

    public AccessControlContext getAccessControlContext() {
        return this.acc;
    }

    private void setServiceName(String sn) {
        this.serviceName = sn;
    }

    private String getServiceName() {
        return this.serviceName;
    }

    private void setServiceType(int st) {
        this.serviceType = st;
    }

    private int getServiceType() {
        return this.serviceType;
    }

    public void setClientIP(String clientip) {
        this.clientIP = clientip;
    }

    private String getClientIP() {
        return this.clientIP;
    }

    public boolean isRestrictedAdmin() {
        return this.authType.equals(AUTHTYPE_JMQADMINKEY);
    }

    public static AccessController getInstance(String serviceName, int serviceType) throws BrokerException {
        return AccessController.getInstance(serviceName, serviceType, false);
    }

    public static AccessController getInstance(String serviceName, int serviceType, boolean forceBasic) throws BrokerException {
        AccessController ac = new AccessController();
        ac.setServiceName(serviceName);
        ac.setServiceType(serviceType);
        BrokerConfig config = Globals.getConfig();
        String value = config.getProperty(PROP_ACCESSCONTROL_ENABLED);
        if (value != null && value.equals("false")) {
            ac.setAccessControlEnabled(false);
        }
        if ((value = config.getProperty(PROP_SERVICE_PREFIX + serviceName + PROP_ACCESSCONTROL_ENABLED_SUFFIX)) != null && !value.trim().equals("")) {
            if (value.equals("false")) {
                ac.setAccessControlEnabled(false);
            } else {
                ac.setAccessControlEnabled(true);
            }
        }
        ac.getAuthProperties().setProperty(PROP_ACCESSCONTROL_ENABLED, ac.isAccessControlEnabled() ? "true" : "false");
        value = config.getProperty(PROP_SERVICE_PREFIX + serviceName + PROP_AUTHENTICATION_TYPE_SUFFIX);
        if (value == null || value.trim().equals("")) {
            value = config.getProperty(PROP_AUTHENTICATION_TYPE);
        }
        if (value != null && !value.trim().equals("")) {
            ac.setAuthType(value);
        }
        if (forceBasic) {
            ac.setAuthType(AUTHTYPE_BASIC);
        }
        if (ac.getAuthType().equals(AUTHTYPE_JMQADMINKEY) || ac.getAuthType().equals(BAD_AUTHTYPE)) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4040", ac.getAuthType()));
        }
        ac.getAuthProperties().setProperty(PROP_AUTHENTICATION_TYPE, ac.getAuthType());
        AccessController.loadProps(ac);
        return ac;
    }

    private static void loadProps(AccessController ac) throws BrokerException {
        BrokerConfig config = Globals.getConfig();
        String serviceName = ac.getServiceName();
        ac.getAuthProperties().setProperty(PROP_SERVICE_NAME, ac.getServiceName());
        ac.getAuthProperties().setProperty(PROP_SERVICE_TYPE, ServiceType.getServiceTypeString((int)ac.getServiceType()));
        AccessController.getProps(ac.getAuthProperties(), PROP_AUTHENTICATION_PREFIX, ac.getAuthType(), null, null);
        AccessController.getProps(ac.getAuthProperties(), PROP_AUTHENTICATION_PREFIX, ac.getAuthType(), PROP_AUTHENTICATION_AREA, serviceName);
        String value = config.getProperty(PROP_SERVICE_PREFIX + serviceName + PROP_ACCESSCONTROL_TYPE_SUFFIX);
        if (value == null || value.trim().equals("")) {
            value = config.getProperty(PROP_ACCESSCONTROL_TYPE);
        }
        if (value == null || value.trim().equals("")) {
            if (ac.isAccessControlEnabled()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4044"));
            }
        } else {
            ac.getAuthProperties().setProperty(PROP_ACCESSCONTROL_TYPE, value);
            AccessController.getProps(ac.getAuthProperties(), PROP_ACCESSCONTROL_PREFIX, value, null, null);
            AccessController.getProps(ac.getAuthProperties(), PROP_ACCESSCONTROL_PREFIX, value, PROP_ACCESSCONTROL_AREA, serviceName);
        }
        if ((value = ac.getAuthProperties().getProperty(PROP_AUTHENTICATION_PREFIX + ac.getAuthType() + PROP_USER_REPOSITORY_SUFFIX)) != null && !value.trim().equals("")) {
            ac.setUserRepository(value);
            AccessController.getProps(ac.getAuthProperties(), PROP_USER_REPOSITORY_PREFIX, value, null, null);
            AccessController.getProps(ac.getAuthProperties(), PROP_USER_REPOSITORY_PREFIX, value, PROP_USER_REPOSITORY_AREA, serviceName);
        }
        ac.init();
    }

    private static List getPropNames(String prefix, String type) {
        return Globals.getConfig().getList(prefix + type + ".properties");
    }

    private static void getProps(Properties props, String prefix, String type, String area, String servicename) {
        List propnames;
        Object realprefix = prefix;
        if (servicename != null) {
            realprefix = PROP_SERVICE_PREFIX + servicename + "." + area + ".";
        }
        if ((propnames = AccessController.getPropNames(prefix, type)) == null) {
            return;
        }
        int size = propnames.size();
        for (int i = 0; i < size; ++i) {
            String pname = (String)propnames.get(i);
            String pvalue = Globals.getConfig().getProperty((String)realprefix + type + "." + pname);
            if (pvalue == null) continue;
            if (pname.equals(PROPERTIES_DIRPATH)) {
                pvalue = StringUtil.expandVariables((String)pvalue, (Properties)Globals.getConfig());
            }
            props.setProperty(prefix + type + "." + pname, pvalue);
            props.setProperty((String)realprefix + type + "." + pname, pvalue);
        }
    }

    public synchronized byte[] getChallenge(int seq, Properties props, Refreshable cacheData, String overrideType) throws BrokerException, LoginException {
        if (this.aph == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
        }
        this.acc = null;
        if (overrideType != null) {
            if (!overrideType.equals(AUTHTYPE_JMQADMINKEY) || this.serviceType != 1) {
                Object[] args = new String[]{overrideType, this.serviceName, ServiceType.getServiceTypeString((int)this.serviceType)};
                throw new LoginException(Globals.getBrokerResources().getKString("B4101", args));
            }
            String adminkey = Globals.getConfig().getProperty(PROP_ADMINKEY);
            if (adminkey == null) {
                throw new LoginException(Globals.getBrokerResources().getKString("B4099"));
            }
            this.authprops = new Properties();
            this.setAuthType(AUTHTYPE_JMQADMINKEY);
            this.authprops.setProperty(PROP_AUTHENTICATION_TYPE, AUTHTYPE_JMQADMINKEY);
            this.setAccessControlEnabled(false);
            this.authprops.setProperty(PROP_ACCESSCONTROL_ENABLED, "false");
            this.authprops.setProperty(PROP_ADMINKEY, adminkey);
            AccessController.loadProps(this);
        }
        Properties p = (Properties)this.getAuthProperties().clone();
        p.putAll((Map<?, ?>)props);
        if (this.getClientIP() != null) {
            p.setProperty(PROP_CLIENTIP, this.getClientIP());
        }
        return this.aph.init(seq, p, cacheData);
    }

    public byte[] handleResponse(byte[] authResponse, int sequence) throws LoginException {
        if (this.aph == null) {
            throw new LoginException(Globals.getBrokerResources().getKString("B4108"));
        }
        byte[] request = this.aph.handleResponse(authResponse, sequence);
        if (request == null) {
            this.acc = this.aph.getAccessControlContext();
        }
        return request;
    }

    public synchronized Refreshable getCacheData() {
        if (this.isAuthenticated() && this.aph != null) {
            return this.aph.getCacheData();
        }
        return null;
    }

    public synchronized void logout() {
        try {
            this.acc = null;
            if (this.aph != null) {
                this.aph.logout();
            }
        }
        catch (LoginException e) {
            this.logger.log(16, "Logout exception : " + e.getMessage(), (Throwable)e);
        }
    }

    public synchronized Subject getAuthenticatedSubject() throws BrokerException {
        if (this.isAuthenticated()) {
            return ((JMQAccessControlContext)this.acc).getSubject();
        }
        throw new BrokerException(Globals.getBrokerResources().getKString("B4043"));
    }

    public synchronized Principal getAuthenticatedName() throws BrokerException {
        if (this.isAuthenticated()) {
            return this.acc.getClientUser();
        }
        throw new BrokerException(Globals.getBrokerResources().getKString("B4043"));
    }

    public synchronized void checkConnectionPermission(String serviceName, String serviceType) {
        if (!this.isAuthenticated()) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4043"));
        }
        if (!this.isAccessControlEnabled() && !serviceType.equals("ADMIN")) {
            return;
        }
        this.acc.checkConnectionPermission(serviceName, serviceType);
    }

    public synchronized void checkDestinationPermission(String serviceName, String serviceType, String operation, String destination, String destinationType) {
        if (!this.isAuthenticated()) {
            throw new AccessControlException(Globals.getBrokerResources().getKString("B4043"));
        }
        if (!this.isAccessControlEnabled()) {
            return;
        }
        this.acc.checkDestinationPermission(serviceName, serviceType, operation, destination, destinationType);
    }
}

