/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm.RadixTree;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm.RadixTreeNode;

class RadixTreeSubstitution {
    private RadixTree _tree;
    private StringBuffer _processedChars;
    private RadixTreeNode _currentNode;
    private int _nodeMatchedChars;
    private String _lastMatchedValue;
    private StringBuffer _reProcessChars;

    RadixTreeSubstitution(RadixTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Invalid tree.");
        }
        this._tree = tree;
        this._processedChars = new StringBuffer();
        this._currentNode = this._tree.getRootNode();
    }

    String substitute(Character c) {
        boolean finalCall;
        StringBuffer outputBuffer = null;
        boolean bl = finalCall = c == null;
        do {
            if (c != null) {
                String nodeKey;
                if (this._reProcessChars != null && this._reProcessChars.length() > 0) {
                    c = Character.valueOf(this._reProcessChars.charAt(0));
                    this._reProcessChars.delete(0, 1);
                }
                if (this._nodeMatchedChars < (nodeKey = this._currentNode.getKey()).length()) {
                    if (c.charValue() == nodeKey.charAt(this._nodeMatchedChars)) {
                        this._processedChars.append(c);
                        ++this._nodeMatchedChars;
                        continue;
                    }
                } else {
                    RadixTreeNode childNode;
                    if (this._currentNode.getValue() != null) {
                        this._lastMatchedValue = this._currentNode.getValue();
                        this._processedChars.delete(0, this._processedChars.length());
                    }
                    if ((childNode = this._currentNode.getChildNode(c.charValue())) != null) {
                        this._processedChars.append(c);
                        this._currentNode = childNode;
                        this._nodeMatchedChars = 1;
                        continue;
                    }
                }
            } else if (this._currentNode.getValue() != null && this._nodeMatchedChars == this._currentNode.getKey().length()) {
                this._lastMatchedValue = this._currentNode.getValue();
                this._processedChars.delete(0, this._processedChars.length());
            }
            if (outputBuffer == null) {
                outputBuffer = new StringBuffer();
            }
            if (this._lastMatchedValue != null) {
                outputBuffer.append(this._lastMatchedValue);
                if (c != null) {
                    this._processedChars.append(c);
                }
                this._lastMatchedValue = null;
            } else if (this._processedChars.length() > 0) {
                outputBuffer.append(this._processedChars.charAt(0));
                this._processedChars.delete(0, 1);
                if (c != null) {
                    this._processedChars.append(c);
                }
            } else {
                if (c != null) {
                    outputBuffer.append(c);
                }
                this._processedChars.delete(0, this._processedChars.length());
            }
            if (this._processedChars.length() > 0) {
                if (this._reProcessChars == null) {
                    this._reProcessChars = new StringBuffer(this._processedChars);
                } else {
                    this._processedChars.append(this._reProcessChars);
                    this._reProcessChars.delete(0, this._reProcessChars.length());
                    this._reProcessChars.append(this._processedChars);
                }
                c = Character.valueOf(this._reProcessChars.charAt(0));
                this._processedChars.delete(0, this._processedChars.length());
            }
            this._currentNode = this._tree.getRootNode();
            this._nodeMatchedChars = 0;
        } while (this._reProcessChars != null && this._reProcessChars.length() > 0);
        if (finalCall) {
            if (this._nodeMatchedChars == this._currentNode.getKey().length() && this._currentNode.getValue() != null) {
                outputBuffer.append(this._currentNode.getValue());
            } else {
                outputBuffer.append(this._currentNode.getKey().substring(0, this._nodeMatchedChars));
            }
            this._processedChars.delete(0, this._processedChars.length());
            this._currentNode = this._tree.getRootNode();
            this._nodeMatchedChars = 0;
            this._lastMatchedValue = null;
        }
        return outputBuffer == null || outputBuffer.toString().isEmpty() ? null : outputBuffer.toString();
    }
}

