/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core.reference;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.ReferenceElement;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.Base64;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyIdentifier
extends ReferenceElement {
    protected static final Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    public KeyIdentifier(Document doc) throws XWSSecurityException {
        try {
            this.setSOAPElement((SOAPElement)doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier"));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WSS0750.soap.exception", new Object[]{"wsse:KeyIdentifier", e.getMessage()});
            throw new XWSSecurityException(e);
        }
    }

    public KeyIdentifier(SOAPElement element) throws XWSSecurityException {
        this.setSOAPElement(element);
        if (!element.getLocalName().equals("KeyIdentifier") || !XMLUtil.inWsseNS(element)) {
            log.log(Level.SEVERE, "WSS0756.invalid.key.identifier", element.getLocalName());
            throw new XWSSecurityException("Invalid keyIdentifier passed");
        }
    }

    public String getValueType() {
        String valueType = this.getAttribute("ValueType");
        if (valueType.equals("")) {
            return null;
        }
        return valueType;
    }

    public void setValueType(String valueType) {
        this.setAttribute("ValueType", valueType);
    }

    public String getEncodingType() {
        String encodingType = this.getAttribute("EncodingType");
        if (encodingType.equals("")) {
            return null;
        }
        return encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.setAttribute("EncodingType", encodingType);
    }

    public String getReferenceValue() {
        return XMLUtil.getFullTextFromChildren((Element)((Object)this));
    }

    public void setReferenceValue(String encodedValue) throws XWSSecurityException {
        this.removeContents();
        try {
            this.addTextNode(encodedValue);
        }
        catch (SOAPException e) {
            log.log(Level.SEVERE, "WSS0757.error.setting.reference", e.getMessage());
            throw new XWSSecurityException(e);
        }
    }

    public String getWsuId() {
        String wsuId = this.getAttribute("wsu:Id");
        if (wsuId.equals("")) {
            return null;
        }
        return wsuId;
    }

    public void setWsuId(String wsuId) {
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        this.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", wsuId);
    }

    public String getDecodedReferenceValue() throws XWSSecurityException {
        String encType = this.getEncodingType();
        if (encType == null) {
            return this.getReferenceValue();
        }
        String encodedText = XMLUtil.getFullTextFromChildren((Element)((Object)this));
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary".equals(encType)) {
            return new String(KeyIdentifier.getDecodedBase64EncodedData(encodedText));
        }
        log.log(Level.SEVERE, "WSS0762.unsupported.encodingType", new Object[]{encType});
        throw new XWSSecurityException("Unsupported EncodingType: " + encType + " On KeyIdentifier");
    }

    private static byte[] getDecodedBase64EncodedData(String encodedData) throws XWSSecurityException {
        try {
            return Base64.decode(encodedData);
        }
        catch (Base64DecodingException e) {
            log.log(Level.SEVERE, "WSS0144.unableto.decode.base64.data", new Object[]{e.getMessage()});
            throw new XWSSecurityException("Unable to decode Base64 encoded data", e);
        }
    }
}

