/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class PageSessionResolver
extends ELResolver {
    public static final String PAGE_SESSION = "pageSession";
    private static final String PAGE_SESSION_KEY = "_ps";

    public Object getValue(ELContext elContext, Object base, Object property) {
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        elContext.setPropertyResolved(true);
        FacesContext facesContext = (FacesContext)elContext.getContext(FacesContext.class);
        ExternalContext externalContext = facesContext.getExternalContext();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        Map<String, Serializable> pageSession = PageSessionResolver.getPageSession(facesContext, viewRoot);
        String attribute = (String)property;
        if (property.equals(PAGE_SESSION)) {
            if (pageSession == null) {
                pageSession = PageSessionResolver.createPageSession(facesContext, viewRoot);
            }
            return pageSession;
        }
        if (pageSession == null || !pageSession.containsKey(attribute)) {
            elContext.setPropertyResolved(false);
            return null;
        }
        Object value = externalContext.getRequestMap().get(attribute);
        if (value != null) {
            return value;
        }
        Map viewMap = viewRoot.getViewMap(false);
        if (viewMap != null && (value = viewMap.get(attribute)) != null) {
            return value;
        }
        value = externalContext.getSessionMap().get(attribute);
        if (value != null) {
            return value;
        }
        value = externalContext.getApplicationMap().get(attribute);
        if (value != null) {
            return value;
        }
        return pageSession.get(attribute);
    }

    public Class<?> getType(ELContext elContext, Object base, Object property) {
        PageSessionResolver.checkPropertyFound(base, property);
        return null;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        PageSessionResolver.checkPropertyFound(base, property);
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        PageSessionResolver.checkPropertyFound(base, property);
        return false;
    }

    public Class<?> getCommonPropertyType(ELContext elContext, Object base) {
        return base == null ? String.class : null;
    }

    public static Map<String, Serializable> getPageSession(FacesContext facesContext, UIViewRoot viewRoot) {
        if (viewRoot == null) {
            viewRoot = facesContext.getViewRoot();
        }
        return (Map)viewRoot.getAttributes().get(PAGE_SESSION_KEY);
    }

    public static Map<String, Serializable> createPageSession(FacesContext facesContext, UIViewRoot viewRoot) {
        if (viewRoot == null) {
            viewRoot = facesContext.getViewRoot();
        }
        HashMap<String, Serializable> pageSession = new HashMap<String, Serializable>(4);
        viewRoot.getAttributes().put(PAGE_SESSION_KEY, pageSession);
        return pageSession;
    }

    private static void checkPropertyFound(Object base, Object property) {
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
    }
}

