/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.SecurityEnvironment;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.MessageConstants;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WssSoapFaultException;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.filter.AuthenticationTokenFilter;
import com.sun.xml.wss.impl.filter.EncryptionFilter;
import com.sun.xml.wss.impl.filter.SignatureConfirmationFilter;
import com.sun.xml.wss.impl.filter.SignatureFilter;
import com.sun.xml.wss.impl.filter.TimestampFilter;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import com.sun.xml.wss.logging.LogStringsMessages;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class HarnessUtil {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");

    private HarnessUtil() {
    }

    static void processWSSPolicy(FilterProcessingContext fpContext) throws XWSSecurityException {
        WSSPolicy policy = (WSSPolicy)fpContext.getSecurityPolicy();
        if (PolicyTypeUtil.signaturePolicy(policy)) {
            SignatureFilter.process(fpContext);
        } else if (PolicyTypeUtil.encryptionPolicy(policy)) {
            EncryptionFilter.process(fpContext);
        } else if (PolicyTypeUtil.timestampPolicy(policy)) {
            TimestampFilter.process(fpContext);
        } else if (PolicyTypeUtil.signatureConfirmationPolicy(policy)) {
            SignatureConfirmationFilter.process(fpContext);
        } else if (PolicyTypeUtil.authenticationTokenPolicy(policy)) {
            fpContext.getExtraneousProperties().put("token.policy", policy);
            WSSPolicy authPolicy = (WSSPolicy)policy.getFeatureBinding();
            if (PolicyTypeUtil.usernameTokenPolicy(authPolicy)) {
                AuthenticationTokenPolicy.UsernameTokenBinding utb = (AuthenticationTokenPolicy.UsernameTokenBinding)authPolicy;
                if (!utb.isEndorsing()) {
                    AuthenticationTokenFilter.processUserNameToken(fpContext);
                }
            } else if (PolicyTypeUtil.samlTokenPolicy(authPolicy)) {
                AuthenticationTokenPolicy.SAMLAssertionBinding samlPolicy = (AuthenticationTokenPolicy.SAMLAssertionBinding)authPolicy;
                try {
                    if (samlPolicy.getAssertionType() == "SV") {
                        AuthenticationTokenFilter.processSamlToken(fpContext);
                    }
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, ex.getMessage());
                }
            } else if (PolicyTypeUtil.x509CertificateBinding(authPolicy)) {
                AuthenticationTokenFilter.processX509Token(fpContext);
            } else if (PolicyTypeUtil.issuedTokenKeyBinding(authPolicy)) {
                AuthenticationTokenFilter.processIssuedToken(fpContext);
            } else if (PolicyTypeUtil.keyValueTokenBinding(authPolicy)) {
                AuthenticationTokenFilter.processRSAToken(fpContext);
            }
        } else if (!PolicyTypeUtil.isMandatoryTargetPolicy(policy)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0801_ILLEGAL_SECURITYPOLICY());
            throw new XWSSecurityException("Invalid WSSPolicy Type");
        }
    }

    static void processDeep(FilterProcessingContext fpContext) throws XWSSecurityException {
        if (!(fpContext.getSecurityPolicy() instanceof WSSPolicy)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0801_ILLEGAL_SECURITYPOLICY());
            throw new XWSSecurityException("Invalid SecurityPolicy Type");
        }
        HarnessUtil.processWSSPolicy(fpContext);
    }

    static void validateContext(ProcessingContext context) throws XWSSecurityException {
        SOAPMessage message = null;
        Message jaxWsMessage = null;
        if (context instanceof JAXBFilterProcessingContext) {
            jaxWsMessage = ((JAXBFilterProcessingContext)context).getJAXWSMessage();
        } else {
            message = context.getSOAPMessage();
        }
        SecurityEnvironment handler = context.getSecurityEnvironment();
        SecurityPolicy policy = context.getSecurityPolicy();
        boolean isInboundMessage = context.isInboundMessage();
        StaticPolicyContext staticContext = context.getPolicyContext();
        if (message == null && jaxWsMessage == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0803_SOAPMESSAGE_NOTSET());
            throw new XWSSecurityException("jakarta.xml.soap.SOAPMessage parameter not set in the ProcessingContext");
        }
        if (handler == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0804_CALLBACK_HANDLER_NOTSET());
            throw new XWSSecurityException("SecurityEnvironment/javax.security.auth.callback.CallbackHandler implementation not set in the ProcessingContext");
        }
        if (policy == null && !isInboundMessage && log.isLoggable(Level.WARNING)) {
            log.log(Level.WARNING, LogStringsMessages.WSS_0805_POLICY_NULL());
        }
        if (staticContext == null) {
            // empty if block
        }
    }

    static String resolvePolicyIdentifier(SOAPMessage message) throws XWSSecurityException {
        Node firstChild = null;
        SOAPBody body = null;
        try {
            body = message.getSOAPBody();
        }
        catch (SOAPException se) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0807_NO_BODY_ELEMENT(), se);
            throw new XWSSecurityException(se);
        }
        if (body == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0808_NO_BODY_ELEMENT_OPERATION());
            throw new XWSSecurityException("No body element identifying an operation is found");
        }
        firstChild = body.getFirstChild();
        return firstChild != null ? "{" + firstChild.getNamespaceURI() + "}" + firstChild.getLocalName() : null;
    }

    static boolean isSecondaryHeaderElement(SOAPElement element) {
        NodeList nl;
        if (element.getLocalName().equals("EncryptedKey") && (nl = element.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "ReferenceList")).getLength() == 0) {
            return true;
        }
        return element.getLocalName().equals("BinarySecurityToken") || element.getLocalName().equals("UsernameToken") || element.getLocalName().equals("Assertion") || element.getLocalName().equals("Timestamp") || element.getLocalName().equals("SignatureConfirmation") || element.getLocalName().equals("SecurityTokenReference") || element.getLocalName().equals("DerivedKeyToken") || element.getLocalName().equals("SecurityContextToken");
    }

    static SOAPElement getNextElement(SOAPElement current) {
        Node node;
        if (current == null) {
            return null;
        }
        for (node = current.getNextSibling(); null != node && node.getNodeType() != 1; node = node.getNextSibling()) {
        }
        return (SOAPElement)node;
    }

    static SOAPElement getPreviousElement(SOAPElement current) {
        Node node;
        for (node = current.getPreviousSibling(); node != null && node.getNodeType() != 1; node = node.getPreviousSibling()) {
        }
        return (SOAPElement)node;
    }

    static void throwWssSoapFault(String message) throws WssSoapFaultException {
        XWSSecurityException xwsse = new XWSSecurityException(message);
        log.log(Level.SEVERE, LogStringsMessages.WSS_0809_FAULT_WSSSOAP(), xwsse);
        throw SecurableSoapMessage.newSOAPFaultException(MessageConstants.WSSE_INVALID_SECURITY, message, xwsse);
    }

    public static void makeDynamicPolicyCallback(DynamicPolicyCallback callback, CallbackHandler callbackHandler) throws XWSSecurityException {
        if (callbackHandler == null) {
            return;
        }
        try {
            Callback[] callbacks = new Callback[]{callback};
            callbackHandler.handle(callbacks);
        }
        catch (UnsupportedCallbackException callbacks) {
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0237_FAILED_DYNAMIC_POLICY_CALLBACK(), e);
            throw new XWSSecurityException(e);
        }
    }
}

