/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim;

import jakarta.enterprise.inject.spi.AnnotatedType;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.Identified;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.logging.MetadataLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;

public interface SlimAnnotatedType<T>
extends AnnotatedType<T>,
Identified<AnnotatedTypeIdentifier> {
    public void clear();

    public static class SerializationProxy<X>
    implements Serializable {
        private static final long serialVersionUID = 6800705438537396237L;
        private final AnnotatedTypeIdentifier identifier;

        public SerializationProxy(AnnotatedTypeIdentifier identifier) {
            this.identifier = identifier;
        }

        private Object readResolve() throws ObjectStreamException {
            SlimAnnotatedType<Object> type = Container.instance(this.identifier).services().get(ClassTransformer.class).getSlimAnnotatedTypeById(this.identifier);
            if (type == null) {
                type = this.tryToLoadUnknownBackedAnnotatedType();
            }
            if (type == null) {
                throw MetadataLogger.LOG.annotatedTypeDeserializationFailure(this.identifier);
            }
            return type;
        }

        private SlimAnnotatedType<?> tryToLoadUnknownBackedAnnotatedType() {
            if (this.identifier.getSuffix() != null || this.identifier.isModified()) {
                return null;
            }
            BeanManagerImpl manager = Container.instance(this.identifier).getBeanManager(this.identifier.getBdaId());
            if (manager == null) {
                return null;
            }
            ResourceLoader resourceLoader = manager.getServices().get(ResourceLoader.class);
            Class<?> clazz = null;
            try {
                clazz = resourceLoader.classForName(this.identifier.getClassName());
            }
            catch (ResourceLoadingException e) {
                MetadataLogger.LOG.catchingDebug(e);
                return null;
            }
            try {
                return manager.getServices().get(ClassTransformer.class).getBackedAnnotatedType(clazz, this.identifier.getBdaId());
            }
            catch (ResourceLoadingException e) {
                MetadataLogger.LOG.catchingDebug(e);
                return null;
            }
        }
    }
}

