/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJComment;
import org.jboss.jdeparser.CommentContent;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.Indent;
import org.jboss.jdeparser.SourceFileWriter;

class InlineDocTagCommentContent
extends AbstractJComment
implements CommentContent {
    static final Indent INDENT = new Indent(){

        @Override
        public void addIndent(Indent next, FormatPreferences preferences, StringBuilder lineBuffer) {
            next.addIndent(next, preferences, lineBuffer);
        }

        @Override
        public void escape(Indent next, StringBuilder b, int idx) {
            int i = idx;
            block4: while (i < b.length()) {
                char ch = b.charAt(i);
                switch (ch) {
                    case '}': {
                        b.replace(i, i + 1, "&#125;");
                        i += 6;
                        continue block4;
                    }
                    case '{': {
                        b.replace(i, i + 1, "&#123;");
                        i += 6;
                        continue block4;
                    }
                }
                ++i;
            }
        }

        @Override
        public void unescaped(Indent next, StringBuilder b, int idx) {
            next.escape(next, b, idx);
        }
    };
    private final String tagName;

    InlineDocTagCommentContent(String tagName) {
        this.tagName = tagName;
    }

    String getTagName() {
        return this.tagName;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.writeUnescaped("{@");
        writer.pushIndent(INDENT);
        try {
            writer.writeEscaped(this.tagName);
            writer.sp();
            super.write(writer);
        }
        finally {
            writer.popIndent(INDENT);
        }
        writer.writeUnescaped("}");
    }
}

