/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsft.facelets;

import com.sun.jsft.event.Command;
import com.sun.jsft.event.CommandEventListener;
import com.sun.jsft.facelets.CommandReader;
import com.sun.jsft.util.Util;
import jakarta.el.ELContext;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.ComponentSystemEventListener;
import jakarta.faces.event.PostAddToViewEvent;
import jakarta.faces.event.PostConstructViewMapEvent;
import jakarta.faces.event.PostRestoreStateEvent;
import jakarta.faces.event.PostValidateEvent;
import jakarta.faces.event.PreDestroyViewMapEvent;
import jakarta.faces.event.PreRemoveFromViewEvent;
import jakarta.faces.event.PreRenderComponentEvent;
import jakarta.faces.event.PreRenderViewEvent;
import jakarta.faces.event.PreValidateEvent;
import jakarta.faces.event.SystemEvent;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EventHandler
extends TagHandler {
    private static Map<String, Class<? extends SystemEvent>> eventAliases = new HashMap<String, Class<? extends SystemEvent>>(20);
    protected final TagAttribute type;
    protected List<Command> commands = new ArrayList<Command>(5);

    public EventHandler(TagConfig config) {
        super(config);
        this.type = this.getRequiredAttribute("type");
        if (!config.getNextHandler().getClass().getName().equals("com.sun.faces.facelets.compiler.UIInstructionHandler")) {
            return;
        }
        CommandReader reader = new CommandReader(config.getNextHandler().toString());
        try {
            this.commands = reader.read();
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse Commands for event type '" + this.type + "'.", ex);
        }
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        if (ComponentHandler.isNew((UIComponent)parent)) {
            Class<? extends SystemEvent> eventClass = this.getEventClass(ctx);
            if (PreRenderViewEvent.class == eventClass || PostConstructViewMapEvent.class == eventClass || PreDestroyViewMapEvent.class == eventClass) {
                parent = ctx.getFacesContext().getViewRoot();
            }
            if (eventClass != null && parent != null) {
                parent.subscribeToEvent(eventClass, (ComponentSystemEventListener)new CommandEventListener(this.commands));
            }
        }
    }

    protected Class<? extends SystemEvent> getEventClass(FaceletContext ctx) {
        String eventType = (String)this.type.getValueExpression(ctx, String.class).getValue((ELContext)ctx);
        if (eventType == null) {
            throw new FacesException("Attribute 'type' can not be null!");
        }
        Class cls = eventAliases.get(eventType);
        if (cls == null) {
            try {
                cls = Util.loadClass(eventType, eventType);
            }
            catch (ClassNotFoundException ex) {
                throw new FacesException("Invalid event type: " + eventType, (Throwable)ex);
            }
        }
        return cls;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("");
        Iterator<Command> it = this.commands.iterator();
        while (it.hasNext()) {
            buf.append(it.next().toString());
        }
        return buf.toString();
    }

    static {
        eventAliases.put("beforeEncode", PreRenderComponentEvent.class);
        eventAliases.put("preRenderComponent", PreRenderComponentEvent.class);
        eventAliases.put("jakarta.faces.event.PreRenderComponent", PreRenderComponentEvent.class);
        eventAliases.put("beforeEncodeView", PreRenderViewEvent.class);
        eventAliases.put("preRenderView", PreRenderViewEvent.class);
        eventAliases.put("jakarta.faces.event.PreRenderView", PreRenderViewEvent.class);
        eventAliases.put("afterCreate", PostAddToViewEvent.class);
        eventAliases.put("postAddToView", PostAddToViewEvent.class);
        eventAliases.put("jakarta.faces.event.PostAddToView", PostAddToViewEvent.class);
        eventAliases.put("afterCreateView", PostRestoreStateEvent.class);
        eventAliases.put("postRestoreState", PostRestoreStateEvent.class);
        eventAliases.put("jakarta.faces.event.PostRestoreStateEvent", PostRestoreStateEvent.class);
        eventAliases.put("beforeValidate", PreValidateEvent.class);
        eventAliases.put("preValidate", PreValidateEvent.class);
        eventAliases.put("jakarta.faces.event.PreValidate", PreValidateEvent.class);
        eventAliases.put("afterValidate", PostValidateEvent.class);
        eventAliases.put("postValidate", PostValidateEvent.class);
        eventAliases.put("jakarta.faces.event.PostValidate", PostValidateEvent.class);
        eventAliases.put("preRemoveFromView", PreRemoveFromViewEvent.class);
        eventAliases.put("jakarta.faces.event.PreRemoveFromViewEvent", PreRemoveFromViewEvent.class);
        eventAliases.put("postConstructViewMap", PostConstructViewMapEvent.class);
        eventAliases.put("jakarta.faces.event.PostConstructViewMapEvent", PostConstructViewMapEvent.class);
        eventAliases.put("preDestroyViewMap", PreDestroyViewMapEvent.class);
        eventAliases.put("jakarta.faces.event.PreDestroyViewMapEvent", PreDestroyViewMapEvent.class);
    }
}

