/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.jmx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.Attribute;
import javax.management.AttributeList;

public class AttributeListUtils {
    private AttributeListUtils() {
    }

    public static boolean containsNamedAttribute(AttributeList al, String name) {
        if (al == null || name == null) {
            throw new IllegalArgumentException("null arg");
        }
        boolean contains = false;
        for (Attribute at : al) {
            if (!name.equals(at.getName())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static boolean containsNamedAttribute(AttributeList al, Attribute a) {
        if (al == null || a == null) {
            throw new IllegalArgumentException("null arg");
        }
        return AttributeListUtils.containsNamedAttribute(al, a.getName());
    }

    public static Map asNameMap(AttributeList al) {
        if (al == null) {
            throw new IllegalArgumentException("null arg");
        }
        HashMap<String, Attribute> m = new HashMap<String, Attribute>();
        for (Attribute a : al) {
            m.put(a.getName(), a);
        }
        return m;
    }

    public static String toJmx12Attribute(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("invalid arg");
        }
        int rc = 95;
        assert (Character.isJavaIdentifierStart('_') && Character.isJavaIdentifierPart('_'));
        char[] chars = new char[name.length()];
        name.getChars(0, name.length(), chars, 0);
        if (!Character.isJavaIdentifierStart(chars[0])) {
            chars[0] = 95;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (Character.isJavaIdentifierPart(chars[i])) continue;
            chars[i] = 95;
        }
        return new String(chars);
    }

    public static String toString(AttributeList al) {
        StringBuffer sb = new StringBuffer();
        int SEP = 44;
        int NL = 10;
        if (al != null) {
            for (Attribute a : al) {
                sb.append(a.getName()).append(',').append(a.getValue().toString()).append('\n');
            }
        }
        return sb.toString();
    }

    public static String dash2CamelCase(String dashed) {
        if (dashed == null) {
            throw new IllegalArgumentException("Null Arg");
        }
        dashed = dashed.toLowerCase(Locale.ENGLISH);
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tz = new StringTokenizer(dashed, "-");
        while (tz.hasMoreTokens()) {
            list.add(tz.nextToken());
        }
        String[] tmp = new String[list.size()];
        String[] strings = AttributeListUtils.getCamelCaseArray(list.toArray(tmp));
        return AttributeListUtils.strings2String(strings);
    }

    private static String[] getCamelCaseArray(String[] from) {
        String[] humps = new String[from.length];
        for (int i = 0; i < from.length; ++i) {
            StringBuffer sb = new StringBuffer(from[i]);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            humps[i] = sb.toString();
        }
        return humps;
    }

    private static String strings2String(String[] a) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]);
        }
        return sb.toString();
    }
}

