/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.domain.CustomTokenClient;
import com.sun.enterprise.admin.servermgmt.domain.DomainInfoManager;
import com.sun.enterprise.admin.servermgmt.domain.DomainPortValidator;
import com.sun.enterprise.admin.servermgmt.domain.DomainSecurity;
import com.sun.enterprise.admin.servermgmt.domain.DomainTemplate;
import com.sun.enterprise.admin.servermgmt.domain.SubstitutableTokens;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainConfigValidator;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionFactory;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutor;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.AttributePreprocessorImpl;
import com.sun.enterprise.admin.servermgmt.template.TemplateInfoHolder;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Property;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.PropertyType;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishVariable;

public class DomainBuilder {
    private static final Logger _logger = SLogger.getLogger();
    private static final String STRINGSUBS_FILE = "stringsubs.xml";
    private static final String TEMPLATE_INFO_XML = "template-info.xml";
    private static final String META_DIR_NAME = "META-INF";
    private static final String DEFUALT_TEMPLATE_RELATIVE_PATH = "common" + File.separator + "templates" + File.separator + "gf";
    private final DomainConfig _domainConfig;
    private JarFile _templateJar;
    private DomainTemplate _domainTempalte;
    private final Properties _defaultPortValues = new Properties();
    private byte[] _keystoreBytes;
    private final Set<String> _extractedEntries = new HashSet<String>();

    public DomainBuilder(DomainConfig domainConfig) throws DomainException {
        this._domainConfig = domainConfig;
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DomainException {
        File template;
        Object templateJarPath = (String)this._domainConfig.get("template.name");
        if (templateJarPath == null || ((String)templateJarPath).isEmpty()) {
            String defaultTemplateName = Version.getDomainTemplateDefaultJarFileName();
            if (defaultTemplateName == null || defaultTemplateName.isEmpty()) {
                throw new DomainException("Missing default template information in branding file.");
            }
            Map envProperties = new ASenvPropertyReader().getProps();
            templateJarPath = (String)envProperties.get(GlassFishVariable.INSTALL_ROOT.getPropertyName()) + File.separator + DEFUALT_TEMPLATE_RELATIVE_PATH + File.separator + defaultTemplateName;
        }
        if (!(template = new File((String)templateJarPath)).exists() || !template.getName().endsWith(".jar")) {
            throw new DomainException(MessageFormat.format("Could not locate template jar {0}", template));
        }
        try {
            TemplateInfoHolder templateInfoHolder;
            this._templateJar = new JarFile(new File((String)templateJarPath));
            JarEntry je = this._templateJar.getJarEntry("config/domain.xml");
            if (je == null) {
                throw new DomainException(MessageFormat.format("Missing mandatory file {0}.", "domain.xml"));
            }
            je = this._templateJar.getJarEntry(TEMPLATE_INFO_XML);
            if (je == null) {
                throw new DomainException(MessageFormat.format("Missing mandatory file {0}.", TEMPLATE_INFO_XML));
            }
            try (InputStream is = this._templateJar.getInputStream(je);){
                templateInfoHolder = new TemplateInfoHolder(is, (String)templateJarPath);
            }
            this._extractedEntries.add(TEMPLATE_INFO_XML);
            je = this._templateJar.getJarEntry(STRINGSUBS_FILE);
            StringSubstitutor stringSubstitutor = null;
            if (je != null) {
                stringSubstitutor = StringSubstitutionFactory.createStringSubstitutor(this._templateJar.getInputStream(je));
                List<Property> defaultStringSubsProps = stringSubstitutor.getDefaultProperties(PropertyType.PORT);
                for (Property prop : defaultStringSubsProps) {
                    this._defaultPortValues.setProperty(prop.getKey(), prop.getValue());
                }
                this._extractedEntries.add(je.getName());
            } else {
                _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00013", STRINGSUBS_FILE);
            }
            this._domainTempalte = new DomainTemplate(templateInfoHolder, stringSubstitutor, (String)templateJarPath);
            je = this._templateJar.getJarEntry("config/keystore.p12");
            if (je != null) {
                this._keystoreBytes = new byte[(int)je.getSize()];
                int count = 0;
                try (InputStream in = null;){
                    in = this._templateJar.getInputStream(je);
                    count = in.read(this._keystoreBytes);
                    if (count < this._keystoreBytes.length) {
                        throw new DomainException(MessageFormat.format("Failure occurred while loading the {0}.", je.getName()));
                    }
                }
                this._extractedEntries.add(je.getName());
            }
            File parentDomainDir = FileUtils.safeGetCanonicalFile((File)new File(this._domainConfig.getRepositoryRoot()));
            this.createDirectory(parentDomainDir);
        }
        catch (Exception e) {
            throw new DomainException(e);
        }
    }

    public void validateTemplate() throws DomainException {
        try {
            RepositoryManager repoManager = new RepositoryManager();
            repoManager.checkRepository(this._domainConfig, false);
            DomainPortValidator portValidator = new DomainPortValidator(this._domainConfig, this._defaultPortValues);
            portValidator.validateAndSetPorts();
            new PEDomainConfigValidator().validate(this._domainConfig);
        }
        catch (Exception ex) {
            throw new DomainException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws RepositoryException, DomainException {
        File domainDir = FileUtils.safeGetCanonicalFile((File)new File(this._domainConfig.getRepositoryRoot(), this._domainConfig.getDomainName()));
        this.createDirectory(domainDir);
        try {
            byte[] buffer = new byte[10000];
            Enumeration<JarEntry> entry = this._templateJar.entries();
            while (entry.hasMoreElements()) {
                JarEntry jarEntry = entry.nextElement();
                String entryName = jarEntry.getName();
                if (entryName.startsWith(META_DIR_NAME) || this._extractedEntries.contains(entryName)) continue;
                if (jarEntry.isDirectory()) {
                    File dir = new File(domainDir, jarEntry.getName());
                    if (dir.exists() || dir.mkdir()) continue;
                    _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00011", dir.getName());
                    continue;
                }
                InputStream in = null;
                FilterOutputStream outputStream = null;
                try {
                    in = this._templateJar.getInputStream(jarEntry);
                    outputStream = new BufferedOutputStream(new FileOutputStream(new File(domainDir.getAbsolutePath(), jarEntry.getName())));
                    int i = 0;
                    while ((i = in.read(buffer)) != -1) {
                        ((BufferedOutputStream)outputStream).write(buffer, 0, i);
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception i) {}
                    }
                    if (outputStream == null) continue;
                    try {
                        outputStream.close();
                    }
                    catch (Exception i) {}
                }
            }
            File configDir = new File(domainDir, "config");
            String user = (String)this._domainConfig.get("domain.user");
            String password = (String)this._domainConfig.get("domain.password");
            String[] adminUserGroups = ((String)this._domainConfig.get("domain.admin.groups")).split(",");
            String masterPassword = (String)this._domainConfig.get("domain.masterPassword");
            Boolean saveMasterPassword = (Boolean)this._domainConfig.get("domain.saveMasterPassword");
            File adminKeyFile = new File(configDir, "admin-keyfile");
            DomainSecurity domainSecurity = new DomainSecurity();
            domainSecurity.processAdminKeyFile(adminKeyFile, user, password, adminUserGroups);
            try {
                domainSecurity.createSSLCertificateDatabase(configDir, this._domainConfig, masterPassword);
            }
            catch (RepositoryException e) {
                System.err.println("Domain creation process involves a step that creates primary key and\n self-signed server certificate. This step failed for the reason shown below.\n This could be because JDK provided keytool program could not be found (e.g.\n you are running with JRE) or for some other reason. No need to panic, as you\n can always use JDK-keytool program to do the needful.");
                throw e;
            }
            domainSecurity.changeMasterPasswordInMasterPasswordFile(new File(domainDir, "master-password.p12"), masterPassword, (boolean)saveMasterPassword);
            domainSecurity.createPasswordAliasKeystore(new File(configDir, "domain-passwords.p12"), masterPassword);
            CustomTokenClient tokenClient = new CustomTokenClient(this._domainConfig);
            Map<String, String> generatedTokens = tokenClient.getSubstitutableTokens();
            if (this._domainTempalte.hasStringsubs()) {
                StringSubstitutor substitutor = this._domainTempalte.getStringSubs();
                Map<String, String> lookUpMap = SubstitutableTokens.getSubstitutableTokens(this._domainConfig);
                lookUpMap.putAll(generatedTokens);
                substitutor.setAttributePreprocessor(new AttributePreprocessorImpl(lookUpMap));
                substitutor.substituteAll();
            }
            try {
                File binDir = new File(domainDir, "bin");
                if (binDir.exists() && binDir.isDirectory()) {
                    domainSecurity.changeMode("-R u+x ", binDir);
                }
                domainSecurity.changeMode("-R g-rwx,o-rwx ", configDir);
            }
            catch (Exception e) {
                throw new DomainException("Error setting permissions.", e);
            }
            DomainInfoManager domainInfoManager = new DomainInfoManager();
            domainInfoManager.process(this._domainTempalte, domainDir);
        }
        catch (DomainException de) {
            FileUtils.liquidate((File)domainDir);
            throw de;
        }
        catch (Exception ex) {
            FileUtils.liquidate((File)domainDir);
            throw new DomainException(ex);
        }
    }

    private void createDirectory(File dir) throws RepositoryException {
        if (!dir.exists()) {
            try {
                if (!dir.mkdirs()) {
                    throw new RepositoryException(MessageFormat.format("Could not create directory {0}", dir));
                }
            }
            catch (Exception e) {
                throw new RepositoryException(MessageFormat.format("Could not create directory {0}", dir), e);
            }
        }
    }
}

