/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.jsf.util.ClientSniffer;
import com.sun.webui.jsf.util.ClientType;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.theme.Theme;
import com.sun.webui.theme.ThemeContext;
import com.sun.webui.theme.ThemeImage;
import jakarta.faces.context.FacesContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public final class JarTheme
implements Theme {
    private static final String HEIGHT_SUFFIX = "_HEIGHT";
    private static final String WIDTH_SUFFIX = "_WIDTH";
    private static final String ALT_SUFFIX = "_ALT";
    private static final String GLOBAL_JSFILES = "global";
    private static final String GLOBAL_STYLESHEETS = "global";
    private static final String MASTER_STYLESHEET = "master";
    private static final ThreadLocal<ThemeContext> THEME_CONTEXT = new ThreadLocal();
    private static final boolean DEBUG = false;
    private ResourceBundle bundle = null;
    private ResourceBundle fallbackBundle = null;
    private ResourceBundle classMapper = null;
    private ResourceBundle imageResources = null;
    private ResourceBundle jsFiles = null;
    private ResourceBundle stylesheets = null;
    private ResourceBundle templates = null;
    private String[] globalJSFiles = null;
    private String[] globalStylesheets = null;
    private String prefix;
    private Locale locale = null;

    void setThemeContext(ThemeContext themeContext) {
        THEME_CONTEXT.set(themeContext);
    }

    ThemeContext getThemeContext() {
        return THEME_CONTEXT.get();
    }

    public JarTheme(Locale zLocale) {
        this.locale = zLocale;
    }

    @Override
    public String[] getGlobalJSFiles() {
        if (this.globalJSFiles == null) {
            try {
                String files = this.jsFiles.getString("global");
                StringTokenizer tokenizer = new StringTokenizer(files, " ");
                ArrayList<String> fileNames = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    String pathKey = tokenizer.nextToken();
                    String path = this.jsFiles.getString(pathKey);
                    fileNames.add(this.translateURI(path));
                }
                int numFiles = fileNames.size();
                this.globalJSFiles = new String[numFiles];
                for (int i = 0; i < numFiles; ++i) {
                    Object fileName = fileNames.get(i);
                    if (fileName == null) continue;
                    this.globalJSFiles[i] = fileName.toString();
                }
            }
            catch (MissingResourceException npe) {
                return null;
            }
        }
        return this.globalJSFiles;
    }

    @Override
    public String[] getGlobalStylesheets() {
        if (this.globalStylesheets == null) {
            try {
                String files = this.stylesheets.getString("global");
                StringTokenizer tokenizer = new StringTokenizer(files, " ");
                ArrayList<String> fileNames = new ArrayList<String>();
                while (tokenizer.hasMoreTokens()) {
                    String pathKey = tokenizer.nextToken();
                    String path = this.stylesheets.getString(pathKey);
                    fileNames.add(this.translateURI(path));
                }
                int numFiles = fileNames.size();
                this.globalStylesheets = new String[numFiles];
                for (int i = 0; i < numFiles; ++i) {
                    this.globalStylesheets[i] = (String)fileNames.get(i);
                }
            }
            catch (MissingResourceException npe) {
                return null;
            }
        }
        return this.globalStylesheets;
    }

    @Override
    public String getPathToJSFile(String key) {
        String path = this.jsFiles.getString(key);
        return this.translateURI(path);
    }

    @Override
    public String getJSString(String key) {
        return this.jsFiles.getString(key);
    }

    private String getPathToStylesheet(FacesContext context) {
        ClientType clientType = ClientSniffer.getClientType(context);
        try {
            String path = this.stylesheets.getString(clientType.toString());
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuilder msgBuffer = new StringBuilder("Could not find property ");
            msgBuffer.append(clientType.toString());
            msgBuffer.append(" in ResourceBundle ");
            msgBuffer.append(this.stylesheets.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    private String getPathToMasterStylesheet() {
        try {
            String path = this.stylesheets.getString(MASTER_STYLESHEET);
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuilder msgBuffer = new StringBuilder("Could not find master ");
            msgBuffer.append("stylesheet in ResourceBundle ");
            msgBuffer.append(this.stylesheets.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    @Override
    public String[] getMasterStylesheets() {
        String css = this.getPathToMasterStylesheet();
        if (css == null) {
            return null;
        }
        return new String[]{css};
    }

    private String getPathToStylesheet(String clientName) {
        try {
            String path = this.stylesheets.getString(clientName);
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuilder msgBuffer = new StringBuilder("Could not find propery ");
            msgBuffer.append(clientName);
            msgBuffer.append(" in ResourceBundle ");
            msgBuffer.append(this.stylesheets.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    @Override
    public String[] getStylesheets(String key) {
        String css = this.getPathToStylesheet(key);
        if (css == null) {
            return null;
        }
        return new String[]{css};
    }

    @Override
    public String getPathToTemplate(String clientName) {
        try {
            String path = this.templates.getString(clientName);
            if (path == null || path.length() == 0) {
                return null;
            }
            return this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            StringBuilder msgBuffer = new StringBuilder("Could not find propery ");
            msgBuffer.append(clientName);
            msgBuffer.append(" in ResourceBundle ");
            msgBuffer.append(this.templates.toString());
            throw new RuntimeException(msgBuffer.toString());
        }
    }

    @Override
    public String getStyleClass(String name) {
        if (this.classMapper == null) {
            return name;
        }
        String styleClass = this.classMapper.getString(name);
        if (styleClass == null) {
            return name;
        }
        return styleClass;
    }

    @Override
    public String getMessage(String key) {
        String message = null;
        try {
            message = this.bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            try {
                message = this.fallbackBundle.getString(key);
            }
            catch (NullPointerException npe) {
                throw mre;
            }
        }
        return message;
    }

    @Override
    public String getMessage(String key, Object[] params) {
        String message = this.getMessage(key);
        MessageFormat mf = new MessageFormat(message, this.locale);
        return mf.format(params);
    }

    protected void setPrefix(String p) {
        this.prefix = p;
    }

    protected void configureClassMapper(ResourceBundle newClassMapper) {
        this.classMapper = newClassMapper;
    }

    protected void configureMessages(ResourceBundle base, ResourceBundle override) {
        if (override == null) {
            this.bundle = base;
        } else {
            this.bundle = override;
            this.fallbackBundle = base;
        }
    }

    protected void configureImages(ResourceBundle newImageResources) {
        this.imageResources = newImageResources;
    }

    protected void configureJSFiles(ResourceBundle newJsFiles) {
        this.jsFiles = newJsFiles;
    }

    protected void configureStylesheets(ResourceBundle newStyleSheets) {
        this.stylesheets = newStyleSheets;
    }

    protected void configureTemplates(ResourceBundle newTemplates) {
        this.templates = newTemplates;
    }

    private String translateURI(String uri) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        ThemeContext tc = this.getThemeContext();
        return tc.getResourcePath(uri);
    }

    private void log(String msg) {
        LogUtil.finest(this.getClass().getName() + "::" + msg);
    }

    @Override
    public String getImagePath(String key) {
        String path = null;
        try {
            path = this.imageResources.getString(key);
            if (path == null || path.trim().length() == 0) {
                return null;
            }
            path = this.translateURI(path);
        }
        catch (MissingResourceException mre) {
            Object[] params = new Object[]{key};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Theme.noIcon", params);
            throw new RuntimeException(message, mre);
        }
        return path;
    }

    @Override
    public ThemeImage getImage(String key) {
        String path = null;
        try {
            path = this.translateURI(this.imageResources.getString(key));
        }
        catch (MissingResourceException mre) {
            Object[] params = new Object[]{key};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Theme.noIcon", params);
            throw new RuntimeException(message, mre);
        }
        String alt = null;
        try {
            alt = this.getMessage(this.imageResources.getString(key.concat(ALT_SUFFIX)));
        }
        catch (MissingResourceException params) {
            // empty catch block
        }
        String title = null;
        int ht = Integer.MIN_VALUE;
        try {
            String height = this.imageResources.getString(key.concat(HEIGHT_SUFFIX));
            ht = Integer.parseInt(height);
        }
        catch (MissingResourceException height) {
        }
        catch (NumberFormatException height) {
            // empty catch block
        }
        int wt = Integer.MIN_VALUE;
        try {
            String width = this.imageResources.getString(key.concat(WIDTH_SUFFIX));
            wt = Integer.parseInt(width);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ThemeImage(wt, ht, null, alt, title, path);
    }

    @Override
    public String getImageString(String key) {
        return this.imageResources.getString(key);
    }
}

