/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.MastFooter;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public final class MastFooterRenderer
extends AbstractRenderer {
    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        MastFooter footer = (MastFooter)component;
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("div", (UIComponent)footer);
        String styleClass = footer.getStyleClass();
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", (Object)styleClass, null);
        } else {
            writer.writeAttribute("class", (Object)theme.getStyleClass("MASTHEAD_FOOTER"), null);
        }
        String style = footer.getStyle();
        if (style != null && style.length() > 0) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.writeAttribute("id", (Object)footer.getClientId(context), null);
        writer.writeAttribute("align", (Object)"right", null);
        this.renderCorporateImage(context, footer, writer, theme);
        writer.endElement("div");
    }

    protected void renderCorporateImage(FacesContext context, MastFooter footer, ResponseWriter writer, Theme theme) throws IOException {
        UIComponent corporateFacet = footer.getFacet("corporateImage");
        if (corporateFacet != null) {
            RenderingUtilities.renderComponent(corporateFacet, context);
            return;
        }
        String imageAttr = footer.getCorporateImageURL();
        if (imageAttr != null && imageAttr.trim().length() != 0) {
            int dim;
            ImageComponent image = new ImageComponent();
            image.setUrl(imageAttr);
            imageAttr = footer.getCorporateImageDescription();
            if (imageAttr != null) {
                image.setAlt(imageAttr);
            }
            if ((dim = footer.getCorporateImageHeight()) != 0) {
                image.setHeight(dim);
            }
            if ((dim = footer.getCorporateImageWidth()) != 0) {
                image.setWidth(dim);
            }
            RenderingUtilities.renderComponent((UIComponent)image, context);
            return;
        }
        try {
            String imagePath = theme.getImagePath("MASTHEAD_CORPNAME");
            if (imagePath == null) {
                return;
            }
            Icon icon = ThemeUtilities.getIcon(theme, "MASTHEAD_CORPNAME");
            icon.setId(footer.getId() + "_corporateImage");
            RenderingUtilities.renderComponent((UIComponent)icon, context);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

