/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.encoding.BufferManagerFactory;
import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.BufferManagerReadStream;
import com.sun.corba.ee.impl.encoding.CDRInputStreamBase;
import com.sun.corba.ee.impl.encoding.CDRInputStream_1_0;
import com.sun.corba.ee.impl.encoding.CDRInputStream_1_1;
import com.sun.corba.ee.impl.encoding.CDRInputStream_1_2;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.MarshalInputStream;
import com.sun.corba.ee.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.ee.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.MessageMediator;
import com.sun.corba.ee.spi.trace.MonitorRead;
import com.sun.corba.ee.spi.trace.Transport;
import com.sun.corba.ee.spi.transport.Connection;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.Context;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.ValueInputStream;
import org.omg.CORBA_2_3.portable.InputStream;

@Transport
@MonitorRead
public class CDRInputObject
extends InputStream
implements MarshalInputStream,
DataInputStream,
ValueInputStream {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final OMGSystemException omgWrapper = OMGSystemException.self;
    private static final long serialVersionUID = 3654171034620991056L;
    private transient ORB orb;
    private transient CDRInputStreamBase impl;
    private transient Connection corbaConnection;
    private transient Message header;
    protected transient MessageMediator messageMediator;
    private boolean unmarshaledHeader;

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        this.orb = null;
        this.impl = null;
        this.corbaConnection = null;
        this.header = null;
        this.messageMediator = null;
    }

    public void addFragment(FragmentMessage header, ByteBuffer byteBuffer) {
        this.getBufferManager().processFragment(byteBuffer, header);
    }

    public void cancelProcessing(int requestId) {
        BufferManagerReadStream bufferManager = (BufferManagerReadStream)this.getBufferManager();
        bufferManager.cancelProcessing(requestId);
    }

    public CDRInputObject() {
    }

    public CDRInputObject(CDRInputObject is) {
        this.impl = is.impl.dup();
        this.impl.setParent(this);
    }

    protected CDRInputObject(org.omg.CORBA.ORB orb, ByteBuffer byteBuffer, int size, ByteOrder byteOrder, GIOPVersion version, BufferManagerRead bufMgr) {
        this.orb = (ORB)orb;
        this.createCDRInputStream(version, byteBuffer, size, byteOrder, bufMgr);
        this.corbaConnection = null;
        this.header = null;
        this.unmarshaledHeader = false;
        this.messageMediator = null;
    }

    private void createCDRInputStream(GIOPVersion version, ByteBuffer byteBuffer, int size, ByteOrder byteOrder, BufferManagerRead bufMgr) {
        this.impl = InputStreamFactory.newInputStream(version);
        this.impl.init((org.omg.CORBA.ORB)this.orb, byteBuffer, size, byteOrder, bufMgr);
        this.impl.setParent(this);
    }

    protected static ByteOrder toByteOrder(boolean littleEndian) {
        return littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public CDRInputObject(ORB orb, Connection corbaConnection, ByteBuffer byteBuffer, Message header) {
        this((org.omg.CORBA.ORB)orb, byteBuffer, header.getSize(), CDRInputObject.toByteOrder(header.isLittleEndian()), header.getGIOPVersion(), CDRInputObject.createBufferManagerRead(orb, header));
        this.corbaConnection = corbaConnection;
        this.header = header;
        this.getBufferManager().init(header);
        this.setIndex(12);
        this.setBufferLength(header.getSize());
    }

    private static BufferManagerRead createBufferManagerRead(ORB orb, Message header) {
        return BufferManagerFactory.newBufferManagerRead(header.getGIOPVersion(), header.getEncodingVersion(), orb);
    }

    public final Connection getConnection() {
        return this.corbaConnection;
    }

    public Message getMessageHeader() {
        return this.header;
    }

    private void unmarshalledHeader(Message msg) {
    }

    @Transport
    public void unmarshalHeader() {
        if (!this.unmarshaledHeader) {
            this.getMessageHeader().read((org.omg.CORBA.portable.InputStream)this);
            this.unmarshalledHeader(this.getMessageHeader());
            this.unmarshaledHeader = true;
        }
    }

    protected CodeSetConversion.BTCConverter createCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codesets = this.getCodeSets();
        if (codesets == null) {
            return CodeSetConversion.impl().getBTCConverter(OSFCodeSetRegistry.ISO_8859_1, this.impl.getByteOrder());
        }
        OSFCodeSetRegistry.Entry charSet = OSFCodeSetRegistry.lookupEntry(codesets.getCharCodeSet());
        if (charSet == null) {
            throw wrapper.unknownCodeset(codesets.getCharCodeSet());
        }
        return CodeSetConversion.impl().getBTCConverter(charSet, this.getByteOrder());
    }

    protected CodeSetConversion.BTCConverter createWCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codesets = this.getCodeSets();
        if (codesets == null) {
            if (this.getConnection().isServer()) {
                throw omgWrapper.noClientWcharCodesetCtx();
            }
            throw omgWrapper.noServerWcharCodesetCmp();
        }
        OSFCodeSetRegistry.Entry wcharSet = OSFCodeSetRegistry.lookupEntry(codesets.getWCharCodeSet());
        if (wcharSet == null) {
            throw wrapper.unknownCodeset(codesets.getWCharCodeSet());
        }
        if (wcharSet == OSFCodeSetRegistry.UTF_16 && this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            return CodeSetConversion.impl().getBTCConverter(wcharSet, ByteOrder.BIG_ENDIAN);
        }
        return CodeSetConversion.impl().getBTCConverter(wcharSet, this.getByteOrder());
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.getConnection() == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.getConnection().getCodeSetContext();
    }

    public CodeBase getCodeBase() {
        if (this.getConnection() == null) {
            return null;
        }
        return this.getConnection().getCodeBase();
    }

    public CDRInputObject dup() {
        return null;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CDRInputObject", msg);
    }

    @Override
    @MonitorRead
    public final boolean read_boolean() {
        return this.impl.read_boolean();
    }

    @Override
    @MonitorRead
    public final char read_char() {
        return this.impl.read_char();
    }

    @Override
    @MonitorRead
    public final char read_wchar() {
        return this.impl.read_wchar();
    }

    @Override
    @MonitorRead
    public final byte read_octet() {
        return this.impl.read_octet();
    }

    @Override
    @MonitorRead
    public final short read_short() {
        return this.impl.read_short();
    }

    @Override
    @MonitorRead
    public final short read_ushort() {
        return this.impl.read_ushort();
    }

    @Override
    @MonitorRead
    public final int read_long() {
        return this.impl.read_long();
    }

    @Override
    @MonitorRead
    public final int read_ulong() {
        return this.impl.read_ulong();
    }

    @Override
    @MonitorRead
    public final long read_longlong() {
        return this.impl.read_longlong();
    }

    @Override
    @MonitorRead
    public final long read_ulonglong() {
        return this.impl.read_ulonglong();
    }

    @Override
    @MonitorRead
    public final float read_float() {
        return this.impl.read_float();
    }

    @Override
    @MonitorRead
    public final double read_double() {
        return this.impl.read_double();
    }

    @Override
    @MonitorRead
    public final String read_string() {
        return this.impl.read_string();
    }

    @Override
    @MonitorRead
    public final String read_wstring() {
        return this.impl.read_wstring();
    }

    @Override
    @MonitorRead
    public final void read_boolean_array(boolean[] value, int offset, int length) {
        this.impl.read_boolean_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_char_array(char[] value, int offset, int length) {
        this.impl.read_char_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_wchar_array(char[] value, int offset, int length) {
        this.impl.read_wchar_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_octet_array(byte[] value, int offset, int length) {
        this.impl.read_octet_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_short_array(short[] value, int offset, int length) {
        this.impl.read_short_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_ushort_array(short[] value, int offset, int length) {
        this.impl.read_ushort_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_long_array(int[] value, int offset, int length) {
        this.impl.read_long_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_ulong_array(int[] value, int offset, int length) {
        this.impl.read_ulong_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_longlong_array(long[] value, int offset, int length) {
        this.impl.read_longlong_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_ulonglong_array(long[] value, int offset, int length) {
        this.impl.read_ulonglong_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_float_array(float[] value, int offset, int length) {
        this.impl.read_float_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final void read_double_array(double[] value, int offset, int length) {
        this.impl.read_double_array(value, offset, length);
    }

    @Override
    @MonitorRead
    public final Object read_Object() {
        return this.impl.read_Object();
    }

    @Override
    @MonitorRead
    public final TypeCode read_TypeCode() {
        return this.impl.read_TypeCode();
    }

    @Override
    @MonitorRead
    public final Any read_any() {
        return this.impl.read_any();
    }

    @Override
    @MonitorRead
    public final Principal read_Principal() {
        return this.impl.read_Principal();
    }

    @MonitorRead
    public final int read() throws IOException {
        return this.impl.read();
    }

    @MonitorRead
    public final BigDecimal read_fixed() {
        return this.impl.read_fixed();
    }

    @MonitorRead
    public final Context read_Context() {
        return this.impl.read_Context();
    }

    @Override
    @MonitorRead
    public final Object read_Object(Class clz) {
        return this.impl.read_Object(clz);
    }

    public final org.omg.CORBA.ORB orb() {
        return this.impl.orb();
    }

    @Override
    @MonitorRead
    public final Serializable read_value() {
        return this.impl.read_value();
    }

    @MonitorRead
    public final Serializable read_value(Class clz) {
        return this.impl.read_value(clz);
    }

    @MonitorRead
    public final Serializable read_value(BoxedValueHelper factory) {
        return this.impl.read_value(factory);
    }

    @MonitorRead
    public final Serializable read_value(String rep_id) {
        return this.impl.read_value(rep_id);
    }

    @MonitorRead
    public final Serializable read_value(Serializable value) {
        return this.impl.read_value(value);
    }

    @MonitorRead
    public final java.lang.Object read_abstract_interface() {
        return this.impl.read_abstract_interface();
    }

    @MonitorRead
    public final java.lang.Object read_abstract_interface(Class clz) {
        return this.impl.read_abstract_interface(clz);
    }

    @Override
    @MonitorRead
    public final void consumeEndian() {
        this.impl.consumeEndian();
    }

    @Override
    public final int getPosition() {
        return this.impl.getPosition();
    }

    @MonitorRead
    public final java.lang.Object read_Abstract() {
        return this.impl.read_Abstract();
    }

    @MonitorRead
    public final Serializable read_Value() {
        return this.impl.read_Value();
    }

    @MonitorRead
    public final void read_any_array(AnySeqHolder seq, int offset, int length) {
        this.impl.read_any_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_boolean_array(BooleanSeqHolder seq, int offset, int length) {
        this.impl.read_boolean_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_char_array(CharSeqHolder seq, int offset, int length) {
        this.impl.read_char_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_wchar_array(WCharSeqHolder seq, int offset, int length) {
        this.impl.read_wchar_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_octet_array(OctetSeqHolder seq, int offset, int length) {
        this.impl.read_octet_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_short_array(ShortSeqHolder seq, int offset, int length) {
        this.impl.read_short_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_ushort_array(UShortSeqHolder seq, int offset, int length) {
        this.impl.read_ushort_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_long_array(LongSeqHolder seq, int offset, int length) {
        this.impl.read_long_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_ulong_array(ULongSeqHolder seq, int offset, int length) {
        this.impl.read_ulong_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_ulonglong_array(ULongLongSeqHolder seq, int offset, int length) {
        this.impl.read_ulonglong_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_longlong_array(LongLongSeqHolder seq, int offset, int length) {
        this.impl.read_longlong_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_float_array(FloatSeqHolder seq, int offset, int length) {
        this.impl.read_float_array(seq, offset, length);
    }

    @MonitorRead
    public final void read_double_array(DoubleSeqHolder seq, int offset, int length) {
        this.impl.read_double_array(seq, offset, length);
    }

    public final String[] _truncatable_ids() {
        return this.impl._truncatable_ids();
    }

    @MonitorRead
    public final int read(byte[] b) throws IOException {
        return this.impl.read(b);
    }

    @MonitorRead
    public final int read(byte[] b, int off, int len) throws IOException {
        return this.impl.read(b, off, len);
    }

    @MonitorRead
    public final long skip(long n) throws IOException {
        return this.impl.skip(n);
    }

    public final int available() throws IOException {
        return this.impl.available();
    }

    @MonitorRead
    public void close() throws IOException {
        this.impl.close();
    }

    @Override
    @MonitorRead
    public final void mark(int readlimit) {
        this.impl.mark(readlimit);
    }

    @Override
    @MonitorRead
    public final void reset() {
        this.impl.reset();
    }

    public final boolean markSupported() {
        return this.impl.markSupported();
    }

    @MonitorRead
    public final BigDecimal read_fixed(short digits, short scale) {
        return this.impl.read_fixed(digits, scale);
    }

    public final ByteOrder getByteOrder() {
        return this.impl.getByteOrder();
    }

    public final int getBufferLength() {
        return this.impl.getBufferLength();
    }

    protected final void setBufferLength(int value) {
        this.impl.setBufferLength(value);
    }

    protected final void setIndex(int value) {
        this.impl.setIndex(value);
    }

    public final void orb(org.omg.CORBA.ORB orb) {
        this.impl.orb(orb);
    }

    public final GIOPVersion getGIOPVersion() {
        return this.impl.getGIOPVersion();
    }

    public final BufferManagerRead getBufferManager() {
        return this.impl.getBufferManager();
    }

    @MonitorRead
    public void alignOnBoundary(int octetBoundary) {
        this.impl.alignOnBoundary(octetBoundary);
    }

    @MonitorRead
    public void setHeaderPadding(boolean headerPadding) {
        this.impl.setHeaderPadding(headerPadding);
    }

    @Override
    public void performORBVersionSpecificInit() {
        if (this.impl != null) {
            this.impl.performORBVersionSpecificInit();
        }
    }

    @Override
    public void resetCodeSetConverters() {
        this.impl.resetCodeSetConverters();
    }

    public void setMessageMediator(MessageMediator messageMediator) {
        this.messageMediator = messageMediator;
    }

    public MessageMediator getMessageMediator() {
        return this.messageMediator;
    }

    @MonitorRead
    public void start_value() {
        this.impl.start_value();
    }

    @MonitorRead
    public void end_value() {
        this.impl.end_value();
    }

    private static class InputStreamFactory {
        private InputStreamFactory() {
        }

        public static CDRInputStreamBase newInputStream(GIOPVersion version) {
            switch (version.intValue()) {
                case 256: {
                    return new CDRInputStream_1_0();
                }
                case 257: {
                    return new CDRInputStream_1_1();
                }
                case 258: {
                    return new CDRInputStream_1_2();
                }
            }
            throw wrapper.unsupportedGiopVersion(version);
        }
    }
}

