/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import com.sun.enterprise.module.common_impl.CompositeEnumeration;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class DelegatingClassLoader
extends ClassLoader {
    private final CopyOnWriteArrayList<ClassFinder> delegates = new CopyOnWriteArrayList();
    private volatile String name;

    public DelegatingClassLoader(ClassLoader parent, List<ClassFinder> delegates) {
        super(parent);
        for (ClassFinder classFinder : delegates) {
            this.checkDelegate(classFinder);
        }
        this.delegates.addAll(delegates);
    }

    public DelegatingClassLoader(ClassLoader parent) {
        super(parent);
    }

    public boolean addDelegate(ClassFinder classFinder) {
        this.checkDelegate(classFinder);
        return this.delegates.addIfAbsent(classFinder);
    }

    private void checkDelegate(ClassFinder classFinder) {
        ClassLoader parent;
        ClassLoader delegateParent = classFinder.getParent();
        if (!Objects.equals(delegateParent, parent = this.getParent())) {
            throw new IllegalArgumentException("Delegation hierarchy mismatch");
        }
    }

    public boolean removeDelegate(ClassFinder classFinder) {
        return this.delegates.remove(classFinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        for (ClassFinder classFinder : this.delegates) {
            try {
                Class<?> c;
                ClassFinder classFinder2 = classFinder;
                synchronized (classFinder2) {
                    c = classFinder.findExistingClass(name);
                    if (c == null) {
                        c = classFinder.findClass(name);
                    }
                }
                return c;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassFinder classFinder : this.delegates) {
            URL resourceURL = classFinder.findResource(name);
            if (resourceURL == null) continue;
            return resourceURL;
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<Enumeration<URL>> enumerators = new ArrayList<Enumeration<URL>>();
        for (ClassFinder classFinder : this.delegates) {
            Enumeration<URL> enumerator = classFinder.findResources(name);
            enumerators.add(enumerator);
        }
        return new CompositeEnumeration(enumerators);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<ClassFinder> getDelegates() {
        return Collections.unmodifiableList(this.delegates);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    static {
        DelegatingClassLoader.registerAsParallelCapable();
    }

    public static interface ClassFinder {
        public ClassLoader getParent();

        public Class<?> findClass(String var1) throws ClassNotFoundException;

        public Class<?> findExistingClass(String var1);

        public URL findResource(String var1);

        public Enumeration<URL> findResources(String var1) throws IOException;
    }
}

