/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.corba;

import java.applet.Applet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaUtils {
    private static Method toStubMethod = null;
    private static Method connectMethod = null;
    private static Class corbaStubClass = null;
    static /* synthetic */ Class class$org$omg$CORBA$ORB;
    static /* synthetic */ Class class$java$rmi$Remote;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static ORB getOrb(String string, int n, Hashtable hashtable) {
        java.lang.Object object;
        Properties properties;
        if (hashtable != null) {
            if (hashtable instanceof Properties) {
                properties = (Properties)hashtable.clone();
            } else {
                properties = new Properties();
                object = hashtable.keys();
                while (object.hasMoreElements()) {
                    String string2 = (String)object.nextElement();
                    java.lang.Object v = hashtable.get(string2);
                    if (!(v instanceof String)) continue;
                    ((Hashtable)properties).put(string2, v);
                }
            }
        } else {
            properties = new Properties();
        }
        if (string != null) {
            ((Hashtable)properties).put("org.omg.CORBA.ORBInitialHost", string);
        }
        if (n >= 0) {
            ((Hashtable)properties).put("org.omg.CORBA.ORBInitialPort", String.valueOf(n));
        }
        object = null;
        if (hashtable != null) {
            object = (Applet)hashtable.get("java.naming.applet");
        }
        if (object != null) {
            return ORB.init(object, (Properties)properties);
        }
        return ORB.init((String[])new String[0], (Properties)properties);
    }

    private static void initMethodHandles() throws ClassNotFoundException {
        corbaStubClass = Class.forName("javax.rmi.CORBA.Stub");
        try {
            connectMethod = corbaStubClass.getMethod("connect", class$org$omg$CORBA$ORB != null ? class$org$omg$CORBA$ORB : (class$org$omg$CORBA$ORB = CorbaUtils.class$("org.omg.CORBA.ORB")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)");
        }
        Class<?> clazz = Class.forName("javax.rmi.PortableRemoteObject");
        try {
            toStubMethod = clazz.getMethod("toStub", class$java$rmi$Remote != null ? class$java$rmi$Remote : (class$java$rmi$Remote = CorbaUtils.class$("java.rmi.Remote")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException("No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
        }
    }

    public static Object remoteToCorba(Remote remote, ORB oRB) throws ClassNotFoundException, ConfigurationException {
        java.lang.Object object;
        if (toStubMethod == null) {
            CorbaUtils.initMethodHandles();
        }
        try {
            object = toStubMethod.invoke(null, remote);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ConfigurationException configurationException = new ConfigurationException("Problem with PortableRemoteObject.toStub(); object not exported or stub not found");
            configurationException.setRootCause(throwable);
            throw configurationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)");
            configurationException.setRootCause(illegalAccessException);
            throw configurationException;
        }
        if (!corbaStubClass.isInstance(object)) {
            return null;
        }
        try {
            connectMethod.invoke(object, oRB);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (!(throwable instanceof RemoteException)) {
                ConfigurationException configurationException = new ConfigurationException("Problem invoking javax.rmi.CORBA.Stub.connect()");
                configurationException.setRootCause(throwable);
                throw configurationException;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            ConfigurationException configurationException = new ConfigurationException("Cannot invoke javax.rmi.CORBA.Stub.connect()");
            configurationException.setRootCause(illegalAccessException);
            throw configurationException;
        }
        return (Object)object;
    }
}

