/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.cdi;

import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.util.DependencyInjectionUtility;
import com.ibm.jbatch.jsl.model.Property;
import jakarta.batch.api.BatchProperty;
import jakarta.batch.runtime.context.JobContext;
import jakarta.batch.runtime.context.StepContext;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;

public class BatchProducerBean {
    @Produces
    @Dependent
    @BatchProperty
    public Boolean produceBooleanProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return Boolean.valueOf(propValStr);
    }

    @Produces
    @Dependent
    @BatchProperty
    public Double produceDoubleProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return Double.valueOf(propValStr);
    }

    @Produces
    @Dependent
    @BatchProperty
    public Float produceFloatProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return Float.valueOf(propValStr);
    }

    @Produces
    @Dependent
    @BatchProperty
    public Integer produceIntProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return Integer.valueOf(propValStr);
    }

    @Produces
    @Dependent
    @BatchProperty
    public Long produceLongProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return Long.valueOf(propValStr);
    }

    @Produces
    @Dependent
    @BatchProperty
    public Short produceShortProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return Short.valueOf(propValStr);
    }

    @Produces
    @Dependent
    @BatchProperty
    public String produceStringProperty(InjectionPoint injectionPoint) {
        String propValStr = this.getStringProperty(injectionPoint);
        return propValStr;
    }

    private String getStringProperty(InjectionPoint injectionPoint) {
        if (injectionPoint != null) {
            if (ProxyFactory.getInjectionReferences() == null) {
                return null;
            }
            BatchProperty batchPropAnnotation = null;
            String batchPropName = null;
            Annotated annotated = injectionPoint.getAnnotated();
            if (annotated != null) {
                batchPropAnnotation = (BatchProperty)annotated.getAnnotation(BatchProperty.class);
                batchPropName = batchPropAnnotation.name().equals("") ? injectionPoint.getMember().getName() : batchPropAnnotation.name();
            } else {
                Set qualifiers = injectionPoint.getQualifiers();
                for (Annotation a : qualifiers.toArray(new Annotation[0])) {
                    if (!(a instanceof BatchProperty)) continue;
                    BatchProperty batchPropertyAnno = (BatchProperty)a;
                    batchPropName = ((BatchProperty)a).name();
                    break;
                }
            }
            if (batchPropName != null) {
                List<Property> propList = ProxyFactory.getInjectionReferences().getProps();
                return DependencyInjectionUtility.getPropertyValue(propList, batchPropName);
            }
        }
        return null;
    }

    @Produces
    @Dependent
    public JobContext getJobContext() {
        if (ProxyFactory.getInjectionReferences() != null) {
            return ProxyFactory.getInjectionReferences().getJobContext();
        }
        return null;
    }

    @Produces
    @Dependent
    public StepContext getStepContext() {
        if (ProxyFactory.getInjectionReferences() != null) {
            return ProxyFactory.getInjectionReferences().getStepContext();
        }
        return null;
    }
}

