/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import jakarta.xml.ws.WebServiceException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.xml.sax.InputSource;

public final class XMLStreamReaderFactory {
    static final XMLInputFactory xmlInputFactory;
    static final ThreadLocal fiStreamReader;
    static final ThreadLocal<XMLStreamReader> xmlStreamReader;

    private XMLStreamReaderFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFreshXMLStreamReader(InputSource source, boolean rejectDTDs) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                if (source.getCharacterStream() != null) {
                    return xmlInputFactory.createXMLStreamReader(source.getSystemId(), source.getCharacterStream());
                }
                if (source.getByteStream() != null) {
                    return xmlInputFactory.createXMLStreamReader(source.getSystemId(), source.getByteStream());
                }
                return xmlInputFactory.createXMLStreamReader(source.getSystemId(), new URL(source.getSystemId()).openStream());
            }
        }
        catch (Exception e) {
            throw new WebServiceException("stax.cantCreate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFreshXMLStreamReader(String systemId, InputStream stream) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                return xmlInputFactory.createXMLStreamReader(systemId, stream);
            }
        }
        catch (Exception e) {
            throw new WebServiceException("stax.cantCreate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFreshXMLStreamReader(String systemId, Reader reader) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                return xmlInputFactory.createXMLStreamReader(systemId, reader);
            }
        }
        catch (Exception e) {
            throw new WebServiceException("stax.cantCreate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createFilteredXMLStreamReader(XMLStreamReader reader, StreamFilter filter) {
        try {
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                return xmlInputFactory.createFilteredReader(reader, filter);
            }
        }
        catch (Exception e) {
            throw new WebServiceException("stax.cantCreate", (Throwable)e);
        }
    }

    static {
        fiStreamReader = new ThreadLocal();
        xmlStreamReader = new ThreadLocal();
        xmlInputFactory = XMLInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        try {
            xmlInputFactory.setProperty("reuse-instance", Boolean.FALSE);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

