/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.documentpreservation;

import java.util.Map;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderCacheEntry;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.w3c.dom.Node;

abstract class AbstractDocumentPreservationPolicy
extends DocumentPreservationPolicy {
    protected Map nodesToObjects;
    protected Map objectsToNodes;

    protected AbstractDocumentPreservationPolicy() {
    }

    @Override
    public void addObjectToCache(Object obj, Node node) {
        this.addObjectToCache(obj, node, null);
    }

    @Override
    public void addObjectToCache(Object obj, Node node, Mapping selfRecordMapping) {
        this.objectsToNodes.put(obj, node);
        if (selfRecordMapping != null) {
            XMLBinderCacheEntry entry = (XMLBinderCacheEntry)this.nodesToObjects.get(node);
            if (entry != null) {
                entry.addSelfMappingObject(selfRecordMapping, obj);
            }
        } else {
            XMLBinderCacheEntry entry = new XMLBinderCacheEntry(obj);
            this.nodesToObjects.put(node, entry);
        }
    }

    @Override
    public Node getNodeForObject(Object obj) {
        return (Node)this.objectsToNodes.get(obj);
    }

    @Override
    public Object getObjectForNode(Node node) {
        return this.getObjectForNode(node, null);
    }

    @Override
    public Object getObjectForNode(Node node, Mapping selfRecordMapping) {
        XMLBinderCacheEntry entry = (XMLBinderCacheEntry)this.nodesToObjects.get(node);
        if (entry != null) {
            if (selfRecordMapping != null) {
                return entry.getSelfMappingObject(selfRecordMapping);
            }
            return entry.getRootObject();
        }
        return null;
    }

    @Override
    public boolean shouldPreserveDocument() {
        return true;
    }
}

