/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompDestination;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompMessage;
import com.sun.messaging.bridge.api.StompProtocolException;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.bridge.api.StompSession;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompConnectionImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompDestinationImpl;
import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class StompSessionImpl
implements StompSession {
    protected static final String QUEUE_CLASS_NAME = "com.sun.messaging.BasicQueue";
    protected static final String TOPIC_CLASS_NAME = "com.sun.messaging.BasicTopic";
    protected static final String TEMP_QUEUE_CLASS_NAME = "com.sun.messaging.jmq.jmsclient.TemporaryQueueImpl";
    protected static final String TEMP_TOPIC_CLASS_NAME = "com.sun.messaging.jmq.jmsclient.TemporaryTopicImpl";
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();
    protected JMSService jmsservice = null;
    protected long connectionId = 0L;
    protected boolean isTransacted = false;
    protected JMSService.SessionAckMode ackMode = JMSService.SessionAckMode.AUTO_ACKNOWLEDGE;
    protected boolean clientackThisMessage = false;
    protected long sessionId = 0L;
    protected StompConnectionImpl stompconn = null;
    protected Object closeLock = new Object();
    protected boolean closing = false;
    protected boolean closed = false;

    public StompSessionImpl(StompConnectionImpl stompc, StompProtocolHandler.StompAckMode ackmode, boolean transacted) throws Exception {
        this.stompconn = stompc;
        this.jmsservice = stompc.getJMSService();
        Long cid = stompc.getConnectionID();
        if (cid == null) {
            throw new StompProtocolException("Not connected");
        }
        this.connectionId = cid;
        this.isTransacted = transacted;
        if (transacted) {
            this.ackMode = JMSService.SessionAckMode.TRANSACTED;
        } else if (ackmode == StompProtocolHandler.StompAckMode.AUTO_ACK) {
            this.ackMode = JMSService.SessionAckMode.AUTO_ACKNOWLEDGE;
        } else if (ackmode == StompProtocolHandler.StompAckMode.CLIENT_ACK) {
            this.ackMode = JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE;
        } else if (ackmode == StompProtocolHandler.StompAckMode.CLIENT_INDIVIDUAL_ACK) {
            this.ackMode = JMSService.SessionAckMode.CLIENT_ACKNOWLEDGE;
            this.clientackThisMessage = true;
        } else {
            throw new IllegalArgumentException("Unsupported ack mode:" + String.valueOf((Object)ackmode));
        }
        JMSServiceReply reply = this.jmsservice.createSession(this.connectionId, this.ackMode);
        this.sessionId = reply.getJMQSessionID();
    }

    protected final boolean getDEBUG() {
        return logger.isFineLoggable() || this.stompconn.getProtocolHandler().getDEBUG();
    }

    protected final boolean isTransacted() {
        return this.isTransacted;
    }

    protected long getTransactionId() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closing) {
                return;
            }
            this.closing = true;
        }
        try {
            this.closeProducers();
            this.jmsservice.stopSession(this.connectionId, this.sessionId, true);
            this.closeSubscribers();
        }
        catch (Exception e) {
            logger.logStack(16, e.getMessage(), (Throwable)e);
        }
        finally {
            this.jmsservice.destroySession(this.connectionId, this.sessionId);
        }
        object = this.closeLock;
        synchronized (object) {
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClosing() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.closed || this.closing;
        }
    }

    protected void closeProducers() {
    }

    protected void closeSubscribers() {
    }

    protected void unsubscribeDurable(String duraname) throws Exception {
        if (duraname == null) {
            return;
        }
        this.jmsservice.deleteConsumer(this.connectionId, this.sessionId, 0L, null, false, duraname, this.stompconn.getClientID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSession() throws Exception {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closing || this.closed) {
                throw new StompProtocolException("Session " + String.valueOf(this) + " is closed");
            }
        }
    }

    @Override
    public StompDestination createStompDestination(String name, boolean isQueue) throws Exception {
        if (isQueue) {
            return new StompDestinationImpl(new Destination(name, Destination.Type.QUEUE, Destination.Life.STANDARD));
        }
        return new StompDestinationImpl(new Destination(name, Destination.Type.TOPIC, Destination.Life.STANDARD));
    }

    @Override
    public StompDestination createTempStompDestination(boolean isQueue) throws Exception {
        String name = null;
        if (isQueue) {
            name = "temporary_destination://queue/" + this.stompconn.getIdForTemporaryDestination();
            return new StompDestinationImpl(new Destination(name, Destination.Type.QUEUE, Destination.Life.TEMPORARY));
        }
        name = "temporary_destination://topic/" + this.stompconn.getIdForTemporaryDestination();
        return new StompDestinationImpl(new Destination(name, Destination.Type.TOPIC, Destination.Life.TEMPORARY));
    }

    protected StompDestination constructStompDestination(String destName, Packet pkt) throws Exception {
        if (destName.startsWith("temporary_destination://queue/") || destName.startsWith("temporary_destination://" + String.valueOf((Object)Destination.Type.QUEUE))) {
            return new StompDestinationImpl(new Destination(destName, Destination.Type.QUEUE, Destination.Life.TEMPORARY));
        }
        if (destName.startsWith("temporary_destination://topic/") || destName.startsWith("temporary_destination://" + String.valueOf((Object)Destination.Type.TOPIC))) {
            return new StompDestinationImpl(new Destination(destName, Destination.Type.TOPIC, Destination.Life.TEMPORARY));
        }
        if (pkt.getIsQueue()) {
            return new StompDestinationImpl(new Destination(destName, Destination.Type.QUEUE, Destination.Life.STANDARD));
        }
        return new StompDestinationImpl(new Destination(destName, Destination.Type.QUEUE, Destination.Life.STANDARD));
    }

    protected StompFrameMessage toStompFrameMessage(final String subid, final String stompdest, final Packet pkt, boolean needAck) throws Exception {
        final StompProtocolHandler mysph = this.stompconn.getProtocolHandler();
        return mysph.toStompFrameMessage(new StompMessage(){

            @Override
            public String getSubscriptionID() {
                return subid;
            }

            @Override
            public String getDestination() {
                return stompdest;
            }

            @Override
            public String getReplyTo() throws Exception {
                String replyto = pkt.getReplyTo();
                if (replyto == null) {
                    return null;
                }
                StompDestination d = StompSessionImpl.this.constructStompDestination(replyto, pkt);
                return mysph.toStompFrameDestination(d, true);
            }

            @Override
            public String getJMSMessageID() {
                return "ID:" + pkt.getSysMessageID().toString();
            }

            @Override
            public String getJMSCorrelationID() {
                return pkt.getCorrelationID();
            }

            @Override
            public String getJMSExpiration() {
                return String.valueOf(pkt.getExpiration());
            }

            @Override
            public String getJMSRedelivered() {
                return String.valueOf(pkt.getRedelivered());
            }

            @Override
            public String getJMSPriority() {
                return String.valueOf(pkt.getPriority());
            }

            @Override
            public String getJMSTimestamp() {
                return String.valueOf(pkt.getTimestamp());
            }

            @Override
            public String getJMSType() {
                return pkt.getMessageType();
            }

            @Override
            public Enumeration getPropertyNames() throws Exception {
                Hashtable props = pkt.getProperties();
                if (props == null) {
                    props = new Hashtable();
                }
                return props.keys();
            }

            @Override
            public String getProperty(String name) throws Exception {
                Hashtable props = pkt.getProperties();
                if (props == null) {
                    return null;
                }
                Object v = props.get(name);
                if (v == null) {
                    return null;
                }
                return v.toString();
            }

            @Override
            public boolean isTextMessage() {
                return pkt.getPacketType() == 1;
            }

            @Override
            public boolean isBytesMessage() {
                return pkt.getPacketType() == 2;
            }

            @Override
            public String getText() throws UnsupportedEncodingException {
                byte[] body = pkt.getMessageBodyByteArray();
                if (body == null) {
                    return null;
                }
                return new String(body, "UTF-8");
            }

            @Override
            public byte[] getBytes() {
                return pkt.getMessageBodyByteArray();
            }

            @Override
            public void setText(StompFrameMessage message) throws Exception {
                throw new RuntimeException("Unexpected call: setText()");
            }

            @Override
            public void setBytes(StompFrameMessage message) throws Exception {
                throw new RuntimeException("Unexpected call: setBytes()");
            }

            @Override
            public void setDestination(String stompdest2) throws Exception {
                throw new RuntimeException("Unexpected call: setDestination()");
            }

            @Override
            public void setPersistent(String stompdest2) throws Exception {
                throw new RuntimeException("Unexpected call: setPersistent()");
            }

            @Override
            public void setReplyTo(String replyto) throws Exception {
                throw new RuntimeException("Unexpected call: setReplyTo()");
            }

            @Override
            public void setJMSCorrelationID(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSCorrelationID()");
            }

            @Override
            public void setJMSExpiration(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSExpiration()");
            }

            @Override
            public void setJMSPriority(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSPriority()");
            }

            @Override
            public void setJMSType(String value) throws Exception {
                throw new RuntimeException("Unexpected call: setJMSType()");
            }

            @Override
            public void setProperty(String name, String value) throws Exception {
                throw new RuntimeException("Unexpected call: setProperty()");
            }
        }, needAck);
    }

    protected StompDestinationImpl fromStompFrameMessage(StompFrameMessage message, Packet pkt) throws Exception {
        StompMessageImpl msg = new StompMessageImpl(pkt);
        this.stompconn.getProtocolHandler().fromStompFrameMessage(message, msg);
        msg.setProperties();
        return msg.d;
    }

    class StompMessageImpl
    implements StompMessage {
        private Packet pkt = null;
        StompDestinationImpl d = null;
        private Hashtable properties = null;

        StompMessageImpl(Packet pkt) {
            this.pkt = pkt;
        }

        @Override
        public void setText(StompFrameMessage message) throws Exception {
            this.pkt.setPacketType(1);
            this.pkt.setMessageBody(message.getBody());
        }

        @Override
        public void setBytes(StompFrameMessage message) throws Exception {
            this.pkt.setPacketType(2);
            this.pkt.setMessageBody(message.getBody());
        }

        @Override
        public void setDestination(String stompdest) throws Exception {
            this.d = (StompDestinationImpl)StompSessionImpl.this.stompconn.getProtocolHandler().toStompDestination(stompdest, StompSessionImpl.this, false);
            this.d.setStompDestinationString(stompdest);
            this.pkt.setDestination(this.d.getName());
            if (this.d.isQueue()) {
                this.pkt.setIsQueue(true);
                if (this.d.isTemporary()) {
                    this.pkt.setDestinationClass(StompSessionImpl.TEMP_QUEUE_CLASS_NAME);
                } else {
                    this.pkt.setDestinationClass(StompSessionImpl.QUEUE_CLASS_NAME);
                }
            } else {
                this.pkt.setIsQueue(false);
                if (this.d.isTemporary()) {
                    this.pkt.setDestinationClass(StompSessionImpl.TEMP_TOPIC_CLASS_NAME);
                } else {
                    this.pkt.setDestinationClass(StompSessionImpl.TOPIC_CLASS_NAME);
                }
            }
        }

        @Override
        public void setReplyTo(String replyto) throws Exception {
            if (replyto == null) {
                return;
            }
            StompDestination d = StompSessionImpl.this.stompconn.getProtocolHandler().toStompDestination(replyto, StompSessionImpl.this, false);
            this.pkt.setReplyTo(d.getName());
            if (d.isQueue()) {
                if (d.isTemporary()) {
                    this.pkt.setDestinationClass(StompSessionImpl.TEMP_QUEUE_CLASS_NAME);
                } else {
                    this.pkt.setDestinationClass(StompSessionImpl.QUEUE_CLASS_NAME);
                }
            } else if (d.isTemporary()) {
                this.pkt.setDestinationClass(StompSessionImpl.TEMP_TOPIC_CLASS_NAME);
            } else {
                this.pkt.setDestinationClass(StompSessionImpl.TOPIC_CLASS_NAME);
            }
        }

        @Override
        public void setPersistent(String v) throws Exception {
            if (v != null && Boolean.valueOf(v).booleanValue()) {
                this.pkt.setPersistent(true);
            }
        }

        @Override
        public void setJMSExpiration(String v) throws Exception {
            if (v == null) {
                return;
            }
            long timeToLive = Long.parseLong(v);
            if (timeToLive != 0L) {
                long expiration = timeToLive + System.currentTimeMillis();
                this.pkt.setExpiration(expiration);
            }
        }

        @Override
        public void setJMSPriority(String v) throws Exception {
            if (v == null) {
                return;
            }
            int pri = Integer.parseInt(v);
            boolean valid = false;
            for (JMSService.MessagePriority p : JMSService.MessagePriority.values()) {
                if (p.priority() != pri) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new StompProtocolException("Invalid priority header value: " + pri);
            }
            this.pkt.setPriority(pri);
        }

        @Override
        public void setJMSCorrelationID(String v) throws Exception {
            if (v != null) {
                this.pkt.setCorrelationID(v);
            }
        }

        @Override
        public void setJMSType(String v) throws Exception {
            if (v != null) {
                this.pkt.setMessageType(v);
            }
        }

        @Override
        public void setProperty(String name, String value) throws Exception {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put(name, value);
        }

        public void setProperties() throws Exception {
            this.pkt.setProperties(this.properties);
        }

        @Override
        public String getSubscriptionID() throws Exception {
            throw new RuntimeException("Unexpected call: getSubscriptionID()");
        }

        @Override
        public String getDestination() throws Exception {
            throw new RuntimeException("Unexpected call: getDestination()");
        }

        @Override
        public String getReplyTo() throws Exception {
            throw new RuntimeException("Unexpected call: getReplyTo()");
        }

        @Override
        public String getJMSMessageID() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSMessageID()");
        }

        @Override
        public String getJMSCorrelationID() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSCorrelationID()");
        }

        @Override
        public String getJMSExpiration() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSExpiration()");
        }

        @Override
        public String getJMSRedelivered() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSRedelivered()");
        }

        @Override
        public String getJMSPriority() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSPriority()");
        }

        @Override
        public String getJMSTimestamp() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSTimestamp()");
        }

        @Override
        public String getJMSType() throws Exception {
            throw new RuntimeException("Unexpected call: getJMSType()");
        }

        @Override
        public Enumeration getPropertyNames() throws Exception {
            throw new RuntimeException("Unexpected call: getPropertyNames()");
        }

        @Override
        public String getProperty(String name) throws Exception {
            throw new RuntimeException("Unexpected call: getProperty()");
        }

        @Override
        public boolean isTextMessage() throws Exception {
            throw new RuntimeException("Unexpected call: isTextMessage()");
        }

        @Override
        public boolean isBytesMessage() throws Exception {
            throw new RuntimeException("Unexpected call: isBytesMessage()");
        }

        @Override
        public String getText() throws Exception {
            throw new RuntimeException("Unexpected call: getText()");
        }

        @Override
        public byte[] getBytes() throws Exception {
            throw new RuntimeException("Unexpected call: getBytes()");
        }
    }
}

