/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.memory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public abstract class MemoryLevelHandler {
    protected Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    protected String MEMORY_NAME_KEY = null;
    protected String localLevelName = null;
    protected int threshold = 0;
    protected int timeBetweenChecks = 0;
    protected boolean inLevel = false;
    protected long enteredLevelTime = 0L;
    protected long totalTimeInLevel = 0L;
    protected long totalCleanupCount = 0L;
    protected long totalTimesEnteredLevel = 0L;
    protected String levelName = "none";
    protected long MAX_MEMORY_DELTA = 10240L;
    protected long LEVEL_DELTA = 1024L;
    protected static final int NEVER_GC = 0;
    protected static final int PAUSED = 0;

    public MemoryLevelHandler(String levelName) {
        this.levelName = levelName;
        this.threshold = Globals.getConfig().getIntProperty("imq." + levelName + ".threshold", 0);
        this.timeBetweenChecks = Globals.getConfig().getIntProperty("imq." + levelName + ".seconds", 5) * 1000;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("levelName", this.levelName);
        ht.put("threshold", this.threshold);
        ht.put("timeBetweenChecks", this.timeBetweenChecks);
        ht.put("threshold", this.threshold);
        ht.put("enteredLevelTime", this.enteredLevelTime);
        ht.put("totalTimeInLevel", this.totalTimeInLevel);
        ht.put("totalCleanupCount", this.totalCleanupCount);
        ht.put("totalTimesEnteredLevel", this.totalTimesEnteredLevel);
        ht.put("MAX_MEMORY_DELTA", this.MAX_MEMORY_DELTA);
        ht.put("LEVEL_DELTA", this.LEVEL_DELTA);
        ht.put("NEVER_GC", 0);
        ht.put("PAUSED", 0);
        ht.put("gcCount", this.gcCount());
        ht.put("gcIteration", this.gcIteration());
        ht.put("inLevel", this.inLevel);
        return ht;
    }

    public int getThresholdPercent() {
        return this.threshold;
    }

    public int getTimeBetweenChecks() {
        return this.timeBetweenChecks;
    }

    public abstract int getMessageCount(long var1, int var3);

    public abstract long getMemory(long var1, int var3);

    public boolean cleanup(int iteration) {
        if (DEBUG) {
            this.logger.log(4, "MM: cleanup() " + this.toDebugString());
        }
        ++this.totalCleanupCount;
        return true;
    }

    public boolean enter(boolean fromHigherLevel) {
        if (DEBUG) {
            this.logger.log(4, "MM: enter(" + fromHigherLevel + ") " + this.toDebugString());
        }
        this.enteredLevelTime = System.currentTimeMillis();
        ++this.totalTimesEnteredLevel;
        this.inLevel = true;
        return true;
    }

    public boolean leave(boolean toHigherLevel) {
        if (DEBUG) {
            this.logger.log(4, "MM: leave(" + toHigherLevel + ") " + this.toDebugString());
        }
        this.inLevel = false;
        this.totalTimeInLevel += System.currentTimeMillis() - this.enteredLevelTime;
        this.enteredLevelTime = 0L;
        return false;
    }

    public abstract int gcCount();

    public abstract int gcIteration();

    public String toString() {
        return "MemoryLevelHandler[" + this.levelName() + "]";
    }

    public String levelName() {
        return this.levelName;
    }

    public String localizedLevelName() {
        if (this.localLevelName == null) {
            this.localLevelName = this.MEMORY_NAME_KEY != null ? Globals.getBrokerResources().getString(this.MEMORY_NAME_KEY, this.levelName) : this.levelName;
        }
        return this.localLevelName;
    }

    public long getTotalTimeInLevel() {
        return this.totalTimeInLevel + this.getCurrentTimeInLevel();
    }

    public boolean getIsInLevel() {
        return this.inLevel;
    }

    public long getTotalCleanupCount() {
        return this.totalCleanupCount;
    }

    public long getTotalTimesEnteredLevel() {
        return this.totalTimesEnteredLevel;
    }

    public long getCurrentTimeInLevel() {
        if (this.enteredLevelTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.enteredLevelTime;
    }

    public String toDebugString() {
        return this.toString() + "\n\t inLevel=" + this.inLevel + "\n\t, ThresholdPercent " + this.getThresholdPercent() + "\n\t, totalTimeInLevel " + this.getTotalTimeInLevel() + "\n\t, TotalCleanupCount " + this.getTotalCleanupCount() + "\n\t, totalTimesEnteredLevel " + this.getTotalTimesEnteredLevel() + "\n\t, CurrentTimeInLevel " + this.getCurrentTimeInLevel() + "\n\t, TotalCleanupCount " + this.getTotalCleanupCount() + "\n\t, gcCount " + this.gcCount() + "\n\t, timeBetweenChecks " + this.timeBetweenChecks / 1000 + " sec\n\t, gcIteration " + this.gcIteration();
    }
}

