/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.IMQBlockingQueue;
import com.sun.messaging.jmq.jmsservice.DirectBrokerConnection;
import com.sun.messaging.jmq.jmsservice.HandOffQueue;
import java.io.IOException;
import java.security.Principal;
import java.util.Hashtable;

public class IMQEmbeddedConnection
extends IMQIPConnection
implements DirectBrokerConnection {
    IMQBlockingQueue inputQueue = new IMQBlockingQueue();
    IMQBlockingQueue outputQueue = new IMQBlockingQueue();
    String localsvcstring = null;

    public IMQEmbeddedConnection(Service svc, PacketRouter router) throws IOException, BrokerException {
        super(svc, null, router);
    }

    @Override
    public HandOffQueue getClientToBrokerQueue() {
        return this.inputQueue;
    }

    @Override
    public HandOffQueue getBrokerToClientQueue() {
        return this.outputQueue;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public synchronized Hashtable getDebugState() {
        Hashtable ht = super.getDebugState();
        ht.put("transport", "Embedded");
        ht.put("inputQueue", this.inputQueue.toString());
        ht.put("outputQueue", this.outputQueue.toString());
        return ht;
    }

    @Override
    public String getRemoteConnectionString() {
        String userString;
        boolean userset;
        block6: {
            if (this.remoteConString != null) {
                return this.remoteConString;
            }
            userset = false;
            userString = "???";
            if (this.state >= 4) {
                try {
                    Principal principal = this.getAuthenticatedName();
                    if (principal != null) {
                        userString = principal.getName();
                        userset = true;
                    }
                }
                catch (BrokerException e) {
                    if (!IMQBasicConnection.DEBUG) break block6;
                    this.logger.log(4, "Exception getting authentication name " + String.valueOf(this.conId), e);
                }
            }
        }
        String retstr = userString + "@Direct:" + String.valueOf(this.getConnectionUID());
        if (userset) {
            this.remoteConString = retstr;
        }
        return retstr;
    }

    @Override
    protected String localServiceString() {
        if (this.localsvcstring != null) {
            return this.localsvcstring;
        }
        this.localsvcstring = this.service.getName();
        return this.localsvcstring;
    }

    @Override
    public synchronized void closeConnection(boolean force, int reason, String reasonStr) {
        super.closeConnection(force, reason, reasonStr);
        EOF eof = new EOF(reasonStr);
        try {
            this.inputQueue.put(eof);
        }
        catch (InterruptedException ex) {
            Globals.getLogger().logStack(4, "nothing we can do", ex);
        }
    }

    @Override
    protected boolean readInPacket(Packet p) throws IOException {
        try {
            Object o = this.inputQueue.take();
            if (o instanceof EOF) {
                EOF eof = (EOF)o;
                throw new IOException("Connection has been closed:" + eof.getReason());
            }
            Packet newp = (Packet)o;
            p.fill(newp, false);
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            Globals.getLogger().logStack(4, "Error retrieving message", ex);
            throw new IOException("Issue processing :" + String.valueOf(ex));
        }
        return true;
    }

    @Override
    protected Packet clearReadPacket(Packet p) {
        return null;
    }

    @Override
    protected boolean writeOutPacket(Packet p) throws IOException {
        ReadWritePacket rp = new ReadWritePacket();
        rp.fill(p, true);
        this.outputQueue.add(rp);
        return true;
    }

    @Override
    protected Packet clearWritePacket(Packet p) {
        return null;
    }

    static class EOF {
        String reason = null;

        EOF(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

