/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import org.glassfish.wasp.Options;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.Compiler;
import org.glassfish.wasp.compiler.Node;
import org.glassfish.wasp.compiler.PageInfo;

public class TextOptimizer {
    public static void concatenate(Compiler compiler, Node.Nodes page) throws WaspException {
        TextCatVisitor v;
        boolean trim;
        Options options = compiler.getCompilationContext().getOptions();
        PageInfo pageInfo = compiler.getPageInfo();
        boolean bl = trim = options.getTrimSpaces() || pageInfo.isTrimDirectiveWhitespaces();
        if (trim) {
            v = new TextCatVisitor(true, trim);
            page.visit(v);
            v.collectText();
        }
        v = new TextCatVisitor(false, trim);
        page.visit(v);
        v.collectText();
    }

    static class TextCatVisitor
    extends Node.Visitor {
        private int textNodeCount = 0;
        private Node.TemplateText firstTextNode = null;
        private StringBuilder textBuffer;
        private final String emptyText = new String("");
        private boolean prePass;
        private boolean trim;

        public TextCatVisitor(boolean prePass, boolean trim) {
            this.prePass = prePass;
            this.trim = trim;
        }

        @Override
        public void doVisit(Node n) throws WaspException {
            this.collectText();
        }

        @Override
        public void visit(Node.PageDirective n) throws WaspException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.TagDirective n) throws WaspException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.TaglibDirective n) throws WaspException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.AttributeDirective n) throws WaspException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visit(Node.VariableDirective n) throws WaspException {
            if (this.prePass) {
                this.collectText();
            }
        }

        @Override
        public void visitBody(Node n) throws WaspException {
            super.visitBody(n);
            this.collectText();
        }

        @Override
        public void visit(Node.TemplateText n) throws WaspException {
            if (this.trim && !this.prePass && n.isAllSpace()) {
                n.setText(this.emptyText);
                return;
            }
            if (this.textNodeCount++ == 0) {
                this.firstTextNode = n;
                this.textBuffer = new StringBuilder(n.getText());
            } else {
                this.textBuffer.append(n.getText());
                n.setText(this.emptyText);
            }
        }

        private void collectText() {
            if (this.textNodeCount > 1) {
                this.firstTextNode.setText(this.textBuffer.toString());
            }
            this.textNodeCount = 0;
        }
    }
}

