/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.UpdateResultSet;
import org.apache.derby.shared.common.error.StandardException;

class DeleteCascadeResultSet
extends DeleteResultSet {
    ResultSet[] dependentResultSets;
    private int noDependents = 0;
    private final String resultSetId;
    private boolean mainNodeForTable = true;
    private boolean affectedRows = false;
    private int tempRowHolderId;

    public DeleteCascadeResultSet(NoPutResultSet noPutResultSet, Activation activation, int n, ResultSet[] resultSetArray, String string) throws StandardException {
        super(noPutResultSet, n == -1 ? activation.getConstantAction() : (ConstantAction)activation.getPreparedStatement().getSavedObject(n), activation);
        if (n == -1) {
            ConstantAction constantAction = activation.getConstantAction();
        } else {
            ConstantAction constantAction = (ConstantAction)activation.getPreparedStatement().getSavedObject(n);
            this.resultDescription = this.constants.resultDescription;
        }
        this.cascadeDelete = true;
        this.resultSetId = string;
        if (resultSetArray != null) {
            this.noDependents = resultSetArray.length;
            this.dependentResultSets = resultSetArray;
        }
    }

    @Override
    public void open() throws StandardException {
        try {
            this.setup();
            if (this.isMultipleDeletePathsExist()) {
                this.setRowHoldersTypeToUniqueStream();
                while (this.collectAffectedRows(false)) {
                }
            } else {
                this.collectAffectedRows(false);
            }
            if (!this.affectedRows) {
                this.activation.addWarning(StandardException.newWarning("02000", new Object[0]));
            }
            this.runFkChecker(true);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            this.mergeRowHolders(hashMap);
            this.fireBeforeTriggers(hashMap);
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rowChangerFinish();
            this.fireAfterTriggers();
        }
        finally {
            this.cleanUp();
            this.activation.clearParentResultSets();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    void setup() throws StandardException {
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        super.setup();
        this.activation.setParentResultSet(this.rowHolder, this.resultSetId);
        Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(this.resultSetId);
        this.tempRowHolderId = vector.size() - 1;
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).setup();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).setup();
        }
    }

    boolean collectAffectedRows(boolean bl) throws StandardException {
        if (super.collectAffectedRows()) {
            this.affectedRows = true;
            bl = true;
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                if (!((UpdateResultSet)this.dependentResultSets[i]).collectAffectedRows()) continue;
                bl = true;
                continue;
            }
            if (!((DeleteCascadeResultSet)this.dependentResultSets[i]).collectAffectedRows(bl)) continue;
            bl = true;
        }
        return bl;
    }

    void fireBeforeTriggers(HashMap<String, String> hashMap) throws StandardException {
        if (!this.mainNodeForTable && !hashMap.containsKey(this.resultSetId)) {
            this.mainNodeForTable = true;
            hashMap.put(this.resultSetId, this.resultSetId);
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).fireBeforeTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).fireBeforeTriggers(hashMap);
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireBeforeTriggers();
        }
    }

    @Override
    void fireAfterTriggers() throws StandardException {
        for (int i = 0; i < this.noDependents && this.affectedRows; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).fireAfterTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).fireAfterTriggers();
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireAfterTriggers();
        }
    }

    @Override
    void deleteDeferredRows() throws StandardException {
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).updateDeferredRows();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).deleteDeferredRows();
        }
        if (this.mainNodeForTable) {
            super.deleteDeferredRows();
        }
    }

    @Override
    void runFkChecker(boolean bl) throws StandardException {
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).runChecker(bl);
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).runFkChecker(bl);
        }
        if (this.mainNodeForTable) {
            super.runFkChecker(bl);
        }
    }

    @Override
    public void cleanUp() throws StandardException {
        super.cleanUp();
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).cleanUp();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).cleanUp();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    private void rowChangerFinish() throws StandardException {
        this.rc.finish();
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).rowChangerFinish();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).rowChangerFinish();
        }
    }

    private void mergeRowHolders(HashMap<String, String> hashMap) throws StandardException {
        if (hashMap.containsKey(this.resultSetId) || this.rowCount == 0L) {
            this.mainNodeForTable = false;
        } else {
            this.mergeResultSets();
            this.mainNodeForTable = true;
            hashMap.put(this.resultSetId, this.resultSetId);
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                return;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).mergeRowHolders(hashMap);
        }
    }

    private void mergeResultSets() throws StandardException {
        Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(this.resultSetId);
        int n = vector.size();
        if (n > 1) {
            int n2 = 0;
            while (n2 < n) {
                ExecRow execRow;
                if (n2 == this.tempRowHolderId) {
                    ++n2;
                    continue;
                }
                TemporaryRowHolder temporaryRowHolder = vector.elementAt(n2);
                CursorResultSet cursorResultSet = temporaryRowHolder.getResultSet();
                cursorResultSet.open();
                while ((execRow = cursorResultSet.getNextRow()) != null) {
                    this.rowHolder.insert(execRow);
                }
                cursorResultSet.close();
                ++n2;
            }
        }
    }

    @Override
    public void finish() throws StandardException {
        super.finish();
        this.activation.clearParentResultSets();
    }

    private boolean isMultipleDeletePathsExist() {
        Enumeration<String> enumeration = this.activation.getParentResultSetKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(string);
            if (vector.size() <= 1) continue;
            return true;
        }
        return false;
    }

    private void setRowHoldersTypeToUniqueStream() {
        Enumeration<String> enumeration = this.activation.getParentResultSetKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Vector<TemporaryRowHolder> vector = this.activation.getParentResultSet(string);
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                TemporaryRowHolder temporaryRowHolder = vector.elementAt(i);
                temporaryRowHolder.setRowHolderTypeToUniqueStream();
            }
        }
    }
}

