/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.JSQLType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

abstract class JavaValueNode
extends QueryTreeNode {
    private boolean mustCastToPrimitive;
    protected boolean forCallStatement;
    private boolean valueReturnedToSQLDomain;
    private boolean returnValueDiscarded;
    protected JSQLType jsqlType;
    private LocalField receiverField;
    private int collationType;

    JavaValueNode(ContextManager contextManager) {
        super(contextManager);
    }

    DataTypeDescriptor getDataType() throws StandardException {
        return DataTypeDescriptor.getSQLDataTypeDescriptor(this.getJavaTypeName());
    }

    final boolean isPrimitiveType() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return false;
        }
        return jSQLType.getCategory() == 2;
    }

    String getJavaTypeName() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        switch (jSQLType.getCategory()) {
            case 1: {
                return jSQLType.getJavaClassName();
            }
            case 2: {
                return JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
            }
        }
        return "";
    }

    final void setJavaTypeName(String string) {
        this.jsqlType = new JSQLType(string);
    }

    String getPrimitiveTypeName() throws StandardException {
        JSQLType jSQLType = this.getJSQLType();
        if (jSQLType == null) {
            return "";
        }
        switch (jSQLType.getCategory()) {
            case 2: {
                return JSQLType.getPrimitiveName(jSQLType.getPrimitiveKind());
            }
        }
        return "";
    }

    final void castToPrimitive(boolean bl) {
        this.mustCastToPrimitive = bl;
    }

    final boolean mustCastToPrimitive() {
        return this.mustCastToPrimitive;
    }

    JSQLType getJSQLType() throws StandardException {
        return this.jsqlType;
    }

    static TypeId mapToTypeID(JSQLType jSQLType) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = jSQLType.getSQLType();
        if (dataTypeDescriptor == null) {
            return null;
        }
        return dataTypeDescriptor.getTypeId();
    }

    final void markForCallStatement() {
        this.forCallStatement = true;
    }

    abstract JavaValueNode remapColumnReferencesToExpressions() throws StandardException;

    abstract boolean categorize(JBitSet var1, boolean var2) throws StandardException;

    abstract JavaValueNode bindExpression(FromList var1, SubqueryList var2, List<AggregateNode> var3) throws StandardException;

    abstract void preprocess(int var1, FromList var2, SubqueryList var3, PredicateList var4) throws StandardException;

    Object getConstantValueAsObject() throws StandardException {
        return null;
    }

    @Override
    final void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.generateExpression(activationClassBuilder, methodBuilder);
    }

    boolean generateReceiver(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        return false;
    }

    int getOrderableVariantType() throws StandardException {
        return 0;
    }

    abstract void generateExpression(ExpressionClassBuilder var1, MethodBuilder var2) throws StandardException;

    final boolean generateReceiver(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, JavaValueNode javaValueNode) throws StandardException {
        if (!this.valueReturnedToSQLDomain() && ClassInspector.primitiveType(this.getJavaTypeName())) {
            return false;
        }
        String string = javaValueNode.getJavaTypeName();
        this.receiverField = expressionClassBuilder.newFieldDeclaration(2, string);
        javaValueNode.generateExpression(expressionClassBuilder, methodBuilder);
        methodBuilder.putField(this.receiverField);
        return true;
    }

    final void getReceiverExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, JavaValueNode javaValueNode) throws StandardException {
        if (this.receiverField != null) {
            methodBuilder.getField(this.receiverField);
        } else {
            javaValueNode.generateExpression(expressionClassBuilder, methodBuilder);
        }
    }

    void returnValueToSQLDomain() {
        this.valueReturnedToSQLDomain = true;
    }

    boolean valueReturnedToSQLDomain() {
        return this.valueReturnedToSQLDomain;
    }

    void markReturnValueDiscarded() {
        this.returnValueDiscarded = true;
    }

    boolean returnValueDiscarded() {
        return this.returnValueDiscarded;
    }

    void checkReliability(ValueNode valueNode) throws StandardException {
        valueNode.checkReliability(4, "42Z00.U");
    }

    int getCollationType() {
        return this.collationType;
    }

    void setCollationType(int n) {
        this.collationType = n;
    }
}

