/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.glassfish.admin.amx.util.AMXDebug;
import org.glassfish.admin.amx.util.ObjectUtil;
import org.glassfish.admin.amx.util.Output;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public class MBeanProxyHandler
extends MBeanServerInvocationHandler {
    protected static final String GET = "get";
    protected static final String SET = "set";
    protected static final String IS = "is";
    protected static final int GET_PREFIX_LENGTH = "get".length();
    protected static final int IS_PREFIX_LENGTH = "is".length();
    protected final MBeanInfo mInitialMBeanInfo;
    private volatile boolean mTargetValid = true;
    private final Integer mHashCode;
    protected final Output mDebug = AMXDebug.getInstance().getOutput(this.getClass().getName());

    public int hashCode() {
        return ObjectUtil.hashCode(this.mInitialMBeanInfo, this.mDebug) ^ ObjectUtil.hashCode(this.mTargetValid);
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (!(rhs instanceof MBeanProxyHandler)) {
            return false;
        }
        MBeanProxyHandler other = (MBeanProxyHandler)rhs;
        boolean equals = this.getObjectName().equals(other.getObjectName());
        if (equals) {
            try {
                equals = this.getMBeanServerConnection() == other.getMBeanServerConnection();
            }
            catch (Exception e) {
                equals = false;
            }
        }
        return equals;
    }

    public MBeanProxyHandler(MBeanServerConnection conn, ObjectName objectName, MBeanInfo mbeanInfo) throws IOException {
        super(conn, objectName);
        if (mbeanInfo != null) {
            this.mInitialMBeanInfo = mbeanInfo;
        } else {
            try {
                this.mInitialMBeanInfo = conn.getMBeanInfo(objectName);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get MBeanInfo for: " + String.valueOf(this.getObjectName()), e);
            }
        }
        this.mHashCode = this.hashCode();
    }

    public boolean isInvariantMBeanInfo() {
        Object value = this.mInitialMBeanInfo.getDescriptor().getFieldValue("immutableInfo");
        return Boolean.parseBoolean(String.valueOf(value));
    }

    public String interfaceName() {
        String value = (String)this.getMBeanInfo().getDescriptor().getFieldValue("interfaceName");
        return value;
    }

    public final void targetUnregistered() {
        this.debugMethod(this.getObjectName().toString(), "targetUnregistered", new Object[0]);
        this.mTargetValid = false;
    }

    public final void connectionBad() {
        this.debugMethod("connectionBad", new Object[0]);
        this.mTargetValid = false;
    }

    public boolean isLocal() {
        return this.getMBeanServerConnection() instanceof MBeanServer;
    }

    public final boolean isValid() {
        if (this.mTargetValid) {
            try {
                this.mTargetValid = this.getMBeanServerConnection().isRegistered(this.getObjectName());
            }
            catch (Exception e) {
                this.debug((Object)"checkValid: connection failed");
                this.mTargetValid = false;
            }
        }
        return this.mTargetValid;
    }

    public synchronized Logger getProxyLogger() {
        return Logger.getLogger(this.getClass().getName());
    }

    protected String extractAttributeNameFromMethod(String methodName) {
        assert (methodName.startsWith(GET) || methodName.startsWith(SET) || methodName.startsWith(IS));
        int startIndex = methodName.startsWith(GET) || methodName.startsWith(SET) ? GET_PREFIX_LENGTH : IS_PREFIX_LENGTH;
        return methodName.substring(startIndex, methodName.length());
    }

    private synchronized MBeanInfo _getMBeanInfo() throws IOException, InstanceNotFoundException, ReflectionException, IntrospectionException {
        MBeanInfo info = this.mInitialMBeanInfo;
        if (!this.isInvariantMBeanInfo()) {
            info = this.getMBeanServerConnection().getMBeanInfo(this.getObjectName());
        }
        return info;
    }

    public MBeanInfo getMBeanInfo() {
        try {
            return this._getMBeanInfo();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object getAttribute(String attributeName) throws InstanceNotFoundException, ReflectionException, MBeanException, AttributeNotFoundException, IOException {
        Object result = this.getMBeanServerConnection().getAttribute(this.getObjectName(), attributeName);
        this.postGetAttributeHook(attributeName, result);
        return result;
    }

    protected Object getAttributeNoThrow(String name) {
        try {
            return this.getAttribute(name);
        }
        catch (Exception e) {
            throw new RuntimeException("getAttribute failed for " + name, e);
        }
    }

    public AttributeList getAttributes(String[] attrNames) throws IOException, InstanceNotFoundException, ReflectionException {
        AttributeList results = this.getMBeanServerConnection().getAttributes(this.getObjectName(), attrNames);
        this.postGetAttributesHook(attrNames, results);
        return results;
    }

    public void setAttribute(Attribute attr) throws IOException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException, InvalidAttributeValueException {
        this.getMBeanServerConnection().setAttribute(this.getObjectName(), attr);
        this.postSetAttributeHook(attr);
    }

    public AttributeList setAttributes(AttributeList requested) throws IOException, InstanceNotFoundException, ReflectionException {
        AttributeList results = this.getMBeanServerConnection().setAttributes(this.getObjectName(), requested);
        this.postSetAttributesHook(requested, results);
        return results;
    }

    protected void postGetAttributeHook(String name, Object value) {
    }

    protected void postGetAttributesHook(String[] requested, AttributeList actual) {
    }

    protected void postSetAttributeHook(Attribute attr) {
    }

    protected void postSetAttributesHook(AttributeList requested, AttributeList actual) {
    }

    public Object invoke(String methodName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return this.getMBeanServerConnection().invoke(this.getObjectName(), methodName, params, signature);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int numArgs = args == null ? 0 : args.length;
        this.debugMethod(method.getName(), args);
        Object result = null;
        boolean isGetter = JMXUtil.isIsOrGetter(method);
        boolean isSetter = isGetter ? false : JMXUtil.isSetter(method);
        boolean handled = false;
        if (methodName.equals("getObjectName")) {
            handled = true;
            result = this.getObjectName();
        } else if (methodName.equals("getMBeanInfo") && numArgs == 0) {
            handled = true;
            result = this.getMBeanInfo();
        } else if (isGetter || isSetter) {
            String javaName;
            handled = true;
            String attributeName = javaName = this.extractAttributeNameFromMethod(methodName);
            if (isGetter) {
                result = this.getAttribute(attributeName);
            } else {
                Attribute attr = new Attribute(attributeName, args[0]);
                this.setAttribute(attr);
            }
        } else if (methodName.indexOf("etAttribute") == 1) {
            handled = true;
            if (JMXUtil.isGetAttribute(method)) {
                String attrName = (String)args[0];
                result = this.getAttribute(attrName);
            } else if (JMXUtil.isGetAttributes(method)) {
                String[] attrNames = (String[])args[0];
                result = this.getAttributes(attrNames);
            } else if (JMXUtil.isSetAttribute(method)) {
                Attribute attr = (Attribute)args[0];
                this.setAttribute(attr);
            } else if (JMXUtil.isSetAttributes(method)) {
                AttributeList requested = (AttributeList)args[0];
                result = this.setAttributes(requested);
            } else {
                handled = false;
            }
        } else if (methodName.equals("hashCode")) {
            result = this.mHashCode;
            handled = true;
        } else if (methodName.equals("toString")) {
            result = "proxy to " + String.valueOf(this.getObjectName());
            handled = true;
        } else if (methodName.equals("equals") && numArgs == 1) {
            result = this.equals(args[0]);
            handled = true;
        }
        if (!handled) {
            this.debugMethod(this.getObjectName().toString(), "super.invoke", method.getName(), args);
            result = super.invoke(proxy, method, args);
        }
        return result;
    }

    protected boolean getDebug() {
        return AMXDebug.getInstance().getDebug(this.getClass().getName());
    }

    protected void debugMethod(String methodName, Object ... args) {
        if (this.getDebug()) {
            this.mDebug.println(AMXDebug.methodString(methodName, args));
        }
    }

    protected void debugMethod(String msg, String methodName, Object ... args) {
        if (this.getDebug()) {
            this.mDebug.println(AMXDebug.methodString(methodName, args) + ": " + msg);
        }
    }

    protected void debug(Object ... args) {
        if (this.getDebug()) {
            this.mDebug.println(StringUtil.toString("", args));
        }
    }

    protected void debug(Object o) {
        this.mDebug.println(o);
    }
}

