/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.Header;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class EncryptedParts
extends PolicyAssertion
implements com.sun.xml.ws.security.policy.EncryptedParts,
SecurityAssertionValidator {
    private boolean _body;
    private boolean _attachments;
    private List<Header> header;
    private boolean populated = false;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private SecurityPolicyVersion spVersion;

    public EncryptedParts() {
        this.spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    }

    public EncryptedParts(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
    }

    public void addBody() {
        this._body = true;
    }

    @Override
    public boolean hasBody() {
        this.populate();
        return this._body;
    }

    @Override
    public boolean hasAttachments() {
        this.populate();
        return this._attachments;
    }

    public void addTarget(QName targetName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getTargets() {
        this.populate();
        if (this.header == null) {
            return Collections.emptyList().iterator();
        }
        return this.header.iterator();
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            if (this.hasParameters()) {
                Iterator<PolicyAssertion> it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion = it.next();
                    if (PolicyUtil.isBody(assertion, this.spVersion)) {
                        this._body = true;
                        continue;
                    }
                    if (PolicyUtil.isAttachments(assertion, this.spVersion)) {
                        this._attachments = true;
                        continue;
                    }
                    if (this.header == null) {
                        this.header = new ArrayList<Header>();
                    }
                    if (PolicyUtil.isHeader(assertion, this.spVersion)) {
                        this.header.add((Header)((Object)assertion));
                        continue;
                    }
                    if (assertion.isOptional()) continue;
                    Constants.log_invalid_assertion(assertion, isServer, "EncryptedParts");
                    this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
                }
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public void removeTarget(QName targetName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeBody() {
        throw new UnsupportedOperationException();
    }
}

