/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import org.jboss.logging.annotations.Field;
import org.jboss.logging.annotations.Fields;
import org.jboss.logging.annotations.Properties;
import org.jboss.logging.annotations.Property;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.util.ElementHelper;
import org.jboss.logging.processor.validation.ValidationMessage;
import org.jboss.logging.processor.validation.ValidationMessageFactory;

class PropertyValidator {
    private static final List<Class<? extends Annotation>> VALIDATING_ANNOTATIONS = Arrays.asList(Properties.class, Property.class, Fields.class, Field.class);
    private final Elements elements;
    private final Types types;
    private final MessageMethod method;
    private final TypeMirror resultType;
    private final Collection<ValidationMessage> messages;

    private PropertyValidator(ProcessingEnvironment processingEnv, MessageMethod method, TypeMirror resultType, Collection<ValidationMessage> messages) {
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.method = method;
        this.resultType = resultType;
        this.messages = messages;
    }

    static Collection<ValidationMessage> validate(ProcessingEnvironment processingEnv, MessageMethod messageMethod) {
        boolean continueValidation = !messageMethod.parametersAnnotatedWith(Field.class).isEmpty() || !messageMethod.parametersAnnotatedWith(Property.class).isEmpty();
        for (Class<? extends Annotation> annotation : VALIDATING_ANNOTATIONS) {
            if (!messageMethod.isAnnotatedWith(annotation)) continue;
            continueValidation = true;
            break;
        }
        if (continueValidation) {
            TypeMirror returnType = processingEnv.getTypeUtils().erasure(messageMethod.returnType().resolvedType());
            ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
            if (returnType.getKind() == TypeKind.DECLARED) {
                PropertyValidator validator = new PropertyValidator(processingEnv, messageMethod, returnType, result);
                validator.validate();
            } else {
                result.add(ValidationMessageFactory.createError(messageMethod, "The return type is invalid for property annotations."));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private void validate() {
        TypeMirror valueType;
        Set propertyTypes;
        HashMap<String, Set> fields = new HashMap<String, Set>();
        HashMap<String, Set> methods = new HashMap<String, Set>();
        TypeElement e = (TypeElement)this.types.asElement(this.resultType);
        for (ExecutableElement executableElement : ElementFilter.methodsIn(this.elements.getAllMembers(e))) {
            String methodName;
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC) || executableElement.getParameters().size() != 1 || !(methodName = executableElement.getSimpleName().toString()).startsWith("set")) continue;
            String name = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Set types = methods.computeIfAbsent(name, key -> new HashSet());
            types.add(executableElement.getParameters().get(0).asType());
        }
        for (Element element : ElementFilter.fieldsIn(this.elements.getAllMembers(e))) {
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC) || element.getModifiers().contains((Object)Modifier.FINAL)) continue;
            Set types = fields.computeIfAbsent(element.getSimpleName().toString(), key -> new HashSet());
            types.add(element.asType());
        }
        ElementHelper.getAnnotations(this.method, Fields.class, Field.class).forEach(a -> this.validateAnnotation((AnnotationMirror)a, (Map<String, Set<TypeMirror>>)fields));
        ElementHelper.getAnnotations(this.method, Properties.class, Property.class).forEach(a -> this.validateAnnotation((AnnotationMirror)a, (Map<String, Set<TypeMirror>>)methods));
        for (Parameter parameter : this.method.parametersAnnotatedWith(Field.class)) {
            propertyTypes = (Set)fields.get(this.resolveFieldName(parameter));
            valueType = parameter.asType();
            if (!this.assignablePropertyFound(valueType, propertyTypes)) {
                this.messages.add(ValidationMessageFactory.createError((Element)parameter, "No target field found in %s with name %s with type %s.", this.resultType, parameter.targetName(), valueType));
            }
            this.validateCommonAnnotation(parameter, Field.class);
        }
        for (Parameter parameter : this.method.parametersAnnotatedWith(Property.class)) {
            propertyTypes = (Set)methods.get(this.resolveSetterName(parameter));
            valueType = parameter.asType();
            if (!this.assignablePropertyFound(valueType, propertyTypes)) {
                this.messages.add(ValidationMessageFactory.createError((Element)parameter, "No method found in %s with signature %s(%s).", this.resultType, parameter.targetName(), valueType));
            }
            this.validateCommonAnnotation(parameter, Property.class);
        }
    }

    private void validateCommonAnnotation(Parameter parameter, Class<? extends Annotation> annotation) {
        Collection<AnnotationMirror> annotations = ElementHelper.getAnnotations(parameter, null, annotation);
        if (annotations.size() != 1) {
            this.messages.add(ValidationMessageFactory.createError((Element)parameter, "Parameters can contain only a single @%s annotation.", annotation.getName()));
        } else {
            AnnotationMirror annotationMirror = annotations.iterator().next();
            Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
            if (!map.isEmpty()) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                    ExecutableElement attribute = entry.getKey();
                    AnnotationValue attributeValue = entry.getValue();
                    if ("name".contentEquals(attribute.getSimpleName())) continue;
                    this.messages.add(ValidationMessageFactory.createError((Element)parameter, annotationMirror, attributeValue, "Default values are not allowed for parameters annotated with @%s. %s", annotation.getName(), annotationMirror));
                }
            }
        }
    }

    private void validateAnnotation(AnnotationMirror annotationMirror, Map<String, Set<TypeMirror>> properties) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = annotationMirror.getElementValues();
        int size = map.size();
        if (size < 2) {
            this.messages.add(ValidationMessageFactory.createError((Element)this.method, annotationMirror, "The name attribute and at least one default value are required: %s", annotationMirror));
        } else if (size > 2) {
            this.messages.add(ValidationMessageFactory.createError((Element)this.method, annotationMirror, "Only the name attribute and one default attribute are allowed to be defined: %s", annotationMirror));
        } else {
            String name = null;
            AnnotationValue value = null;
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
                ExecutableElement attribute = entry.getKey();
                AnnotationValue attributeValue = entry.getValue();
                if ("name".contentEquals(attribute.getSimpleName())) {
                    name = String.valueOf(attributeValue.getValue());
                    continue;
                }
                value = attributeValue;
            }
            if (name == null) {
                this.messages.add(ValidationMessageFactory.createError((Element)this.method, annotationMirror, "The name attribute is required on %s", annotationMirror));
            } else if (value == null) {
                this.messages.add(ValidationMessageFactory.createError((Element)this.method, annotationMirror, "No value could be determined for %s", annotationMirror));
            } else {
                Set<TypeMirror> propertyTypes = properties.get(name);
                if (propertyTypes == null) {
                    this.messages.add(ValidationMessageFactory.createError((Element)this.method, annotationMirror, value, "Could not find property %s on %s.", name, this.resultType));
                } else {
                    TypeMirror defaultValueType = value.accept(ValueTypeAnnotationValueVisitor.INSTANCE, this.elements);
                    if (!this.assignablePropertyFound(defaultValueType, propertyTypes)) {
                        this.messages.add(ValidationMessageFactory.createError((Element)this.method, annotationMirror, value, "Expected property with type %s found with type %s", defaultValueType, propertyTypes));
                    }
                }
            }
        }
    }

    private boolean assignablePropertyFound(TypeMirror valueType, Set<TypeMirror> propertyTypes) {
        if (propertyTypes != null) {
            for (TypeMirror propertyType : propertyTypes) {
                if (!this.types.isAssignable(this.types.erasure(valueType), this.types.erasure(propertyType))) continue;
                return true;
            }
        }
        return false;
    }

    private String resolveFieldName(Parameter parameter) {
        String result = "";
        Field field = parameter.getAnnotation(Field.class);
        if (field != null) {
            String name = field.name();
            result = name.isEmpty() ? parameter.getSimpleName().toString() : name;
        }
        return result;
    }

    private String resolveSetterName(Parameter parameter) {
        String result = "";
        Property property = parameter.getAnnotation(Property.class);
        if (property != null) {
            String name = property.name();
            result = name.isEmpty() ? parameter.getSimpleName().toString() : name;
        }
        return result;
    }

    private static class ValueTypeAnnotationValueVisitor
    extends SimpleAnnotationValueVisitor8<TypeMirror, Elements> {
        private static final ValueTypeAnnotationValueVisitor INSTANCE = new ValueTypeAnnotationValueVisitor();

        private ValueTypeAnnotationValueVisitor() {
        }

        @Override
        protected TypeMirror defaultAction(Object o, Elements elements) {
            return ElementHelper.toType(elements, o.getClass());
        }

        @Override
        public TypeMirror visitType(TypeMirror t, Elements elements) {
            return ElementHelper.toType(elements, Class.class);
        }
    }
}

