/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Context;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.IOEvent;
import org.glassfish.grizzly.IOEventLifeCycleListener;
import org.glassfish.grizzly.ProcessorExecutor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http2.EncoderUtils;
import org.glassfish.grizzly.http2.HeadersDecoder;
import org.glassfish.grizzly.http2.HeadersEncoder;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Configuration;
import org.glassfish.grizzly.http2.Http2SessionException;
import org.glassfish.grizzly.http2.Http2SessionOutputSink;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.NetLogger;
import org.glassfish.grizzly.http2.frames.ContinuationFrame;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.GoAwayFrame;
import org.glassfish.grizzly.http2.frames.HeaderBlockFragment;
import org.glassfish.grizzly.http2.frames.HeadersFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.PingFrame;
import org.glassfish.grizzly.http2.frames.PriorityFrame;
import org.glassfish.grizzly.http2.frames.PushPromiseFrame;
import org.glassfish.grizzly.http2.frames.RstStreamFrame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;
import org.glassfish.grizzly.http2.frames.UnknownFrame;
import org.glassfish.grizzly.http2.frames.WindowUpdateFrame;
import org.glassfish.grizzly.impl.FutureImpl;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.utils.Futures;
import org.glassfish.grizzly.utils.Holder;

public class Http2Session {
    private static final Logger LOGGER = Grizzly.logger(Http2Session.class);
    private final boolean isServer;
    private final Connection<?> connection;
    Http2State http2State;
    private HeadersDecoder headersDecoder;
    private HeadersEncoder headersEncoder;
    private final ReentrantLock deflaterLock = new ReentrantLock();
    int lastPeerStreamId;
    private int lastLocalStreamId;
    private boolean pushEnabled = true;
    private final ReentrantLock newClientStreamLock = new ReentrantLock();
    private volatile FilterChain http2StreamChain;
    private volatile FilterChain htt2SessionChain;
    private final AtomicInteger concurrentStreamsCount = new AtomicInteger(0);
    private final TreeMap<Integer, Http2Stream> streamsMap = new TreeMap();
    final List<Http2Stream> streamsToFlushInput = new ArrayList<Http2Stream>();
    protected final List<Http2Frame> tmpHeaderFramesList = new ArrayList<Http2Frame>(2);
    private final Object sessionLock = new Object();
    private volatile CloseType closeFlag;
    private int peerStreamWindowSize = this.getDefaultStreamWindowSize();
    private volatile int localStreamWindowSize = this.getDefaultStreamWindowSize();
    private volatile int localConnectionWindowSize = this.getDefaultConnectionWindowSize();
    private volatile int maxHeaderListSize;
    private volatile int localMaxConcurrentStreams = this.getDefaultMaxConcurrentStreams();
    private int peerMaxConcurrentStreams = this.getDefaultMaxConcurrentStreams();
    private final Http2SessionOutputSink outputSink;
    private final Http2Configuration http2Configuration;
    private volatile int streamsHighWaterMark;
    private int checkCount;
    private int goingAwayLastStreamId = Integer.MIN_VALUE;
    private FutureImpl<Http2Session> sessionClosed;
    private volatile boolean isPrefaceReceived;
    private volatile boolean isPrefaceSent;
    private final Holder<?> addressHolder;
    final Http2BaseFilter handlerFilter;
    private final int localMaxFramePayloadSize;
    private int peerMaxFramePayloadSize = this.getSpecDefaultFramePayloadSize();
    private boolean isFirstInFrame = true;
    private volatile SSLBaseFilter sslFilter;
    private final AtomicInteger unackedReadBytes = new AtomicInteger();

    public static Http2Session get(Connection connection) {
        Http2State http2State = Http2State.get(connection);
        return http2State != null ? http2State.getHttp2Session() : null;
    }

    static void bind(Connection connection, Http2Session http2Session) {
        Http2State.obtain(connection).setHttp2Session(http2Session);
    }

    public Http2Session(Connection<?> connection, boolean isServer, Http2BaseFilter handlerFilter) {
        this.connection = connection;
        FilterChain chain = (FilterChain)connection.getProcessor();
        int sslIdx = chain.indexOfType(SSLBaseFilter.class);
        if (sslIdx != -1) {
            this.sslFilter = (SSLBaseFilter)chain.get(sslIdx);
        }
        this.isServer = isServer;
        this.handlerFilter = handlerFilter;
        this.http2Configuration = handlerFilter.getConfiguration();
        if (this.http2Configuration.getMaxConcurrentStreams() != -1) {
            this.setLocalMaxConcurrentStreams(this.http2Configuration.getMaxConcurrentStreams());
        } else {
            this.setLocalMaxConcurrentStreams(this.getDefaultMaxConcurrentStreams());
        }
        if (this.http2Configuration.getInitialWindowSize() != -1) {
            this.localStreamWindowSize = this.http2Configuration.getInitialWindowSize();
        }
        int customMaxFramePayloadSz = handlerFilter.getLocalMaxFramePayloadSize() > 0 ? handlerFilter.getLocalMaxFramePayloadSize() : -1;
        this.localMaxFramePayloadSize = customMaxFramePayloadSz >= this.getSpecMinFramePayloadSize() && customMaxFramePayloadSz <= this.getSpecMaxFramePayloadSize() ? customMaxFramePayloadSz : this.getSpecDefaultFramePayloadSize();
        this.maxHeaderListSize = handlerFilter.getConfiguration().getMaxHeaderListSize();
        if (isServer) {
            this.lastLocalStreamId = 0;
            this.lastPeerStreamId = -1;
        } else {
            this.lastLocalStreamId = -1;
            this.lastPeerStreamId = 0;
        }
        this.addressHolder = Holder.lazyHolder(() -> connection.getPeerAddress());
        connection.addCloseListener(new ConnectionCloseListener());
        this.outputSink = this.newOutputSink();
        NetLogger.logOpen(this);
    }

    protected Http2SessionOutputSink newOutputSink() {
        return new Http2SessionOutputSink(this);
    }

    protected int getSpecDefaultFramePayloadSize() {
        return 16384;
    }

    protected int getSpecMinFramePayloadSize() {
        return 16384;
    }

    protected int getSpecMaxFramePayloadSize() {
        return 0xFFFFFF;
    }

    public int getDefaultConnectionWindowSize() {
        return 65535;
    }

    public int getDefaultStreamWindowSize() {
        return 65535;
    }

    public int getDefaultMaxConcurrentStreams() {
        return 100;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    public void setMaxHeaderListSize(int maxHeaderListSize) {
        this.maxHeaderListSize = maxHeaderListSize;
    }

    protected int getFrameSize(Buffer buffer) {
        return buffer.remaining() < 4 ? -1 : (buffer.getInt(buffer.position()) >>> 8) + 9;
    }

    public Http2Frame parseHttp2FrameHeader(Buffer buffer) throws Http2SessionException {
        int len = this.getFrameSize(buffer);
        if (buffer.remaining() != len) {
            throw new Http2SessionException(ErrorCode.FRAME_SIZE_ERROR);
        }
        int i1 = buffer.getInt();
        int type = i1 & 0xFF;
        int flags = buffer.get() & 0xFF;
        int streamId = buffer.getInt() & Integer.MAX_VALUE;
        switch (type) {
            case 0: {
                return DataFrame.fromBuffer(flags, streamId, buffer);
            }
            case 1: {
                return HeadersFrame.fromBuffer(flags, streamId, buffer);
            }
            case 2: {
                return PriorityFrame.fromBuffer(streamId, buffer);
            }
            case 3: {
                return RstStreamFrame.fromBuffer(flags, streamId, buffer);
            }
            case 4: {
                return SettingsFrame.fromBuffer(flags, streamId, buffer);
            }
            case 5: {
                return PushPromiseFrame.fromBuffer(flags, streamId, buffer);
            }
            case 6: {
                return PingFrame.fromBuffer(flags, streamId, buffer);
            }
            case 7: {
                return GoAwayFrame.fromBuffer(streamId, buffer);
            }
            case 8: {
                return WindowUpdateFrame.fromBuffer(flags, streamId, buffer);
            }
            case 9: {
                return ContinuationFrame.fromBuffer(flags, streamId, buffer);
            }
        }
        return new UnknownFrame(type, len);
    }

    protected Http2Stream newStream(HttpRequestPacket request, int streamId, int refStreamId, boolean exclusive, int priority) {
        return new Http2Stream(this, request, streamId, refStreamId, exclusive, priority);
    }

    protected Http2Stream newUpgradeStream(HttpRequestPacket request, int priority) {
        return new Http2Stream(this, request, priority);
    }

    protected void checkFrameSequenceSemantics(Http2Frame frame) throws Http2SessionException {
        int frameType = frame.getType();
        if (this.isFirstInFrame) {
            if (frameType != 4) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "First in frame should be a SettingsFrame (preface)", frame);
                }
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
            }
            this.isPrefaceReceived = true;
            this.handlerFilter.onPrefaceReceived(this);
            Http2State.get(this.connection).setOpen();
            this.isFirstInFrame = false;
        }
        if (this.isParsingHeaders()) {
            if (frameType != 9) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "ContinuationFrame is expected, but {0} came", frame);
                }
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
            }
        } else if (frameType == 9) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "ContinuationFrame is not expected");
            }
            throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
        }
    }

    protected void onOversizedFrame(Buffer buffer) throws Http2SessionException {
        int oldPos = buffer.position();
        try {
            throw new Http2SessionException(ErrorCode.FRAME_SIZE_ERROR);
        }
        catch (Throwable throwable) {
            buffer.position(oldPos);
            throw throwable;
        }
    }

    boolean isParsingHeaders() {
        return this.headersDecoder != null && this.headersDecoder.isProcessingHeaders();
    }

    public final int getLocalMaxFramePayloadSize() {
        return this.localMaxFramePayloadSize;
    }

    public int getPeerMaxFramePayloadSize() {
        return this.peerMaxFramePayloadSize;
    }

    protected void setPeerMaxFramePayloadSize(int peerMaxFramePayloadSize) throws Http2SessionException {
        if (peerMaxFramePayloadSize < this.getSpecMinFramePayloadSize() || peerMaxFramePayloadSize > this.getSpecMaxFramePayloadSize()) {
            throw new Http2SessionException(ErrorCode.FRAME_SIZE_ERROR);
        }
        this.peerMaxFramePayloadSize = peerMaxFramePayloadSize;
    }

    public int getLocalStreamWindowSize() {
        return this.localStreamWindowSize;
    }

    public void setLocalStreamWindowSize(int localStreamWindowSize) {
        this.localStreamWindowSize = localStreamWindowSize;
    }

    public int getPeerStreamWindowSize() {
        return this.peerStreamWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPeerStreamWindowSize(int peerStreamWindowSize) throws Http2StreamException {
        Object object = this.sessionLock;
        synchronized (object) {
            int delta = peerStreamWindowSize - this.peerStreamWindowSize;
            this.peerStreamWindowSize = peerStreamWindowSize;
            if (!this.streamsMap.isEmpty()) {
                for (Http2Stream stream : this.streamsMap.values()) {
                    if (stream.isClosed()) continue;
                    stream.getOutputSink().onPeerWindowUpdate(delta);
                }
            }
        }
    }

    public int getLocalConnectionWindowSize() {
        return this.localConnectionWindowSize;
    }

    public void setLocalConnectionWindowSize(int localConnectionWindowSize) {
        this.localConnectionWindowSize = localConnectionWindowSize;
    }

    public int getAvailablePeerConnectionWindowSize() {
        return this.outputSink.getAvailablePeerConnectionWindowSize();
    }

    public int getLocalMaxConcurrentStreams() {
        return this.localMaxConcurrentStreams;
    }

    public void setLocalMaxConcurrentStreams(int localMaxConcurrentStreams) {
        this.localMaxConcurrentStreams = localMaxConcurrentStreams;
        this.streamsHighWaterMark = Float.valueOf((float)this.localMaxConcurrentStreams * this.http2Configuration.getStreamsHighWaterMark()).intValue();
    }

    public int getPeerMaxConcurrentStreams() {
        return this.peerMaxConcurrentStreams;
    }

    void setPeerMaxConcurrentStreams(int peerMaxConcurrentStreams) {
        this.peerMaxConcurrentStreams = peerMaxConcurrentStreams;
    }

    public boolean isPushEnabled() {
        return this.pushEnabled && this.http2Configuration.isPushEnabled();
    }

    public void setPushEnabled(boolean pushEnabled) {
        if (this.isGoingAway()) {
            return;
        }
        this.pushEnabled = pushEnabled;
    }

    public int getNextLocalStreamId() {
        this.lastLocalStreamId += 2;
        return this.lastLocalStreamId;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public MemoryManager getMemoryManager() {
        return this.connection.getMemoryManager();
    }

    public boolean isServer() {
        return this.isServer;
    }

    public boolean isLocallyInitiatedStream(int streamId) {
        assert (streamId > 0);
        return this.isServer() ^ streamId % 2 != 0;
    }

    Http2State getHttp2State() {
        return this.http2State;
    }

    boolean isHttp2InputEnabled() {
        return this.isPrefaceReceived;
    }

    boolean isHttp2OutputEnabled() {
        return this.isPrefaceSent;
    }

    public Http2Stream getStream(int streamId) {
        return this.streamsMap.get(streamId);
    }

    protected Http2SessionOutputSink getOutputSink() {
        return this.outputSink;
    }

    FutureImpl<Http2Session> terminateGracefully() {
        if (!this.isServer) {
            throw new IllegalStateException("Illegal use of graceful termination on client.");
        }
        GoAwayFrame frame = this.setGoAwayLocally(ErrorCode.NO_ERROR, "Shutting Down", true);
        if (frame != null) {
            this.sessionClosed = Futures.createSafeFuture();
            this.outputSink.writeDownStream(frame);
        }
        return this.sessionClosed;
    }

    void terminate(ErrorCode errorCode, String detail) {
        this.sendGoAwayAndClose(this.setGoAwayLocally(errorCode, detail, false));
    }

    private void sendGoAwayAndClose(Http2Frame frame) {
        if (frame != null) {
            this.outputSink.writeDownStream(frame, (CompletionHandler<WriteResult>)new EmptyCompletionHandler<WriteResult>(){

                private void close() {
                    Http2Session.this.connection.closeSilently();
                    Http2Session.this.outputSink.close();
                }

                @Override
                public void failed(Throwable throwable) {
                    LOGGER.log(Level.WARNING, "Unable to write GOAWAY.  Terminating session.", throwable);
                    this.close();
                }

                @Override
                public void completed(WriteResult result) {
                    this.close();
                }

                @Override
                public void cancelled() {
                    LOGGER.log(Level.FINE, "GOAWAY write cancelled.  Terminating session.");
                    this.close();
                }
            }, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GoAwayFrame setGoAwayLocally(ErrorCode errorCode, String detail, boolean graceful) {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.goingAwayLastStreamId == Integer.MIN_VALUE || this.goingAwayLastStreamId == Integer.MAX_VALUE && !graceful) {
                this.closeFlag = CloseType.LOCALLY;
                int n = graceful ? Integer.MAX_VALUE : (this.goingAwayLastStreamId = this.lastPeerStreamId > 0 ? this.lastPeerStreamId : 0);
                if (this.goingAwayLastStreamId != Integer.MAX_VALUE && this.concurrentStreamsCount.get() > 0) {
                    this.pruneStreams();
                }
                return GoAwayFrame.builder().lastStreamId(this.goingAwayLastStreamId).additionalDebugData(detail != null ? Buffers.wrap(this.getMemoryManager(), detail) : null).errorCode(errorCode).build();
            }
            return null;
        }
    }

    private void pruneStreams() {
        LOGGER.log(Level.FINE, "pruneStreams()");
        NavigableMap<Integer, Http2Stream> invalidStreams = this.streamsMap.subMap(this.goingAwayLastStreamId, false, Integer.MAX_VALUE, true);
        if (!invalidStreams.isEmpty()) {
            ArrayList closedStreams = new ArrayList(invalidStreams.values());
            for (Http2Stream stream : closedStreams) {
                stream.closedRemotely();
                this.deregisterStream();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGoAwayByPeer(int lastStreamId) {
        Object object = this.sessionLock;
        synchronized (object) {
            this.pushEnabled = false;
            this.goingAwayLastStreamId = lastStreamId;
            this.closeFlag = CloseType.REMOTELY;
            this.pruneStreams();
            if (this.isServer || lastStreamId != Integer.MAX_VALUE) {
                this.sendGoAwayAndClose(GoAwayFrame.builder().lastStreamId(this.goingAwayLastStreamId).additionalDebugData(Buffers.wrap(this.getMemoryManager(), "Peer Requested.")).errorCode(ErrorCode.NO_ERROR).build());
            }
        }
    }

    boolean isGoingAway() {
        return this.closeFlag != null;
    }

    public int getGoingAwayLastStreamId() {
        return this.goingAwayLastStreamId;
    }

    protected void sendWindowUpdate(int streamId, int delta) {
        WindowUpdateFrame f = ((WindowUpdateFrame.WindowUpdateFrameBuilder)WindowUpdateFrame.builder().streamId(streamId)).windowSizeIncrement(delta).build();
        NetLogger.log(NetLogger.Context.TX, this, f);
        this.outputSink.writeDownStream(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPreface() {
        if (!this.isPrefaceSent) {
            Object object = this.sessionLock;
            synchronized (object) {
                if (!this.isPrefaceSent) {
                    if (this.isServer) {
                        this.sendServerPreface();
                    } else {
                        this.sendClientPreface();
                    }
                    this.isPrefaceSent = true;
                    if (!this.isServer) {
                        this.ackConsumedData(this.getStream(0), 0);
                    }
                }
            }
        }
    }

    protected void sendServerPreface() {
        SettingsFrame settingsFrame = this.prepareSettings().build();
        NetLogger.log(NetLogger.Context.TX, this, settingsFrame);
        this.connection.write(settingsFrame.toBuffer(this.getMemoryManager()), this.sslFilter != null ? new EmptyCompletionHandler(){

            @Override
            public void completed(Object result) {
                Http2Session.this.sslFilter.setRenegotiationDisabled(true);
            }
        } : null);
    }

    protected void sendClientPreface() {
        HttpRequestPacket request = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PRI).uri("*").protocol(Protocol.HTTP_2_0)).build();
        Buffer priPayload = Buffers.wrap(this.connection.getMemoryManager(), Http2BaseFilter.PRI_PAYLOAD);
        SettingsFrame settingsFrame = this.prepareSettings().build();
        Buffer settingsBuffer = settingsFrame.toBuffer(this.getMemoryManager());
        Buffer payload = Buffers.appendBuffers(this.connection.getMemoryManager(), priPayload, settingsBuffer);
        HttpContent content = ((HttpContent.Builder)HttpContent.builder(request).content(payload)).build();
        NetLogger.log(NetLogger.Context.TX, this, settingsFrame);
        this.connection.write(content);
    }

    HeadersDecoder getHeadersDecoder() {
        if (this.headersDecoder == null) {
            this.headersDecoder = new HeadersDecoder(this.getMemoryManager(), this.getMaxHeaderListSize(), 4096);
        }
        return this.headersDecoder;
    }

    ReentrantLock getDeflaterLock() {
        return this.deflaterLock;
    }

    HeadersEncoder getHeadersEncoder() {
        if (this.headersEncoder == null) {
            this.headersEncoder = new HeadersEncoder(this.getMemoryManager(), 4096);
        }
        return this.headersEncoder;
    }

    protected List<Http2Frame> encodeHttpHeaderAsHeaderFrames(FilterChainContext ctx, HttpHeader httpHeader, int streamId, boolean isLast, List<Http2Frame> toList, Map<String, String> capture) throws IOException {
        Buffer compressedHeaders = !httpHeader.isRequest() ? EncoderUtils.encodeResponseHeaders(this, (HttpResponsePacket)httpHeader, capture) : EncoderUtils.encodeRequestHeaders(this, (HttpRequestPacket)httpHeader, capture);
        List<Http2Frame> headerFrames = this.bufferToHeaderFrames(streamId, compressedHeaders, isLast, toList);
        this.handlerFilter.onHttpHeadersEncoded(httpHeader, ctx);
        return headerFrames;
    }

    protected List<Http2Frame> encodeTrailersAsHeaderFrames(int streamId, List<Http2Frame> toList, MimeHeaders trailerHeaders, Map<String, String> capture) throws IOException {
        Buffer compressedHeaders = EncoderUtils.encodeTrailerHeaders(this, trailerHeaders, capture);
        return this.bufferToHeaderFrames(streamId, compressedHeaders, true, toList);
    }

    protected List<Http2Frame> encodeHttpRequestAsPushPromiseFrames(FilterChainContext ctx, HttpRequestPacket httpRequest, int streamId, int promisedStreamId, List<Http2Frame> toList, Map<String, String> capture) throws IOException {
        List<Http2Frame> headerFrames = this.bufferToPushPromiseFrames(streamId, promisedStreamId, EncoderUtils.encodeRequestHeaders(this, httpRequest, capture), toList);
        this.handlerFilter.onHttpHeadersEncoded(httpRequest, ctx);
        return headerFrames;
    }

    private List<Http2Frame> bufferToHeaderFrames(int streamId, Buffer compressedHeaders, boolean isEos, List<Http2Frame> toList) {
        HeadersFrame.HeadersFrameBuilder builder = ((HeadersFrame.HeadersFrameBuilder)HeadersFrame.builder().streamId(streamId)).endStream(isEos);
        return this.completeHeadersProviderFrameSerialization(builder, streamId, compressedHeaders, toList);
    }

    private List<Http2Frame> bufferToPushPromiseFrames(int streamId, int promisedStreamId, Buffer compressedHeaders, List<Http2Frame> toList) {
        PushPromiseFrame.PushPromiseFrameBuilder builder = ((PushPromiseFrame.PushPromiseFrameBuilder)PushPromiseFrame.builder().streamId(streamId)).promisedStreamId(promisedStreamId);
        return this.completeHeadersProviderFrameSerialization(builder, streamId, compressedHeaders, toList);
    }

    private List<Http2Frame> completeHeadersProviderFrameSerialization(HeaderBlockFragment.HeaderBlockFragmentBuilder builder, int streamId, Buffer compressedHeaders, List<Http2Frame> toList) {
        assert (this.getDeflaterLock().isHeldByCurrentThread());
        if (toList == null) {
            toList = this.tmpHeaderFramesList;
        }
        if (compressedHeaders.remaining() <= this.peerMaxFramePayloadSize) {
            toList.add(((Http2Frame.Http2FrameBuilder)((HeaderBlockFragment.HeaderBlockFragmentBuilder)builder.endHeaders(true)).compressedHeaders(compressedHeaders)).build());
            return toList;
        }
        Buffer remainder = compressedHeaders.split(compressedHeaders.position() + this.peerMaxFramePayloadSize);
        toList.add(((Http2Frame.Http2FrameBuilder)((HeaderBlockFragment.HeaderBlockFragmentBuilder)builder.endHeaders(false)).compressedHeaders(compressedHeaders)).build());
        assert (remainder != null);
        do {
            Buffer buffer;
            remainder = (buffer = remainder).remaining() <= this.peerMaxFramePayloadSize ? null : buffer.split(buffer.position() + this.peerMaxFramePayloadSize);
            toList.add(((ContinuationFrame.ContinuationFrameBuilder)((ContinuationFrame.ContinuationFrameBuilder)((ContinuationFrame.ContinuationFrameBuilder)ContinuationFrame.builder().streamId(streamId)).endHeaders(remainder == null)).compressedHeaders(buffer)).build());
        } while (remainder != null);
        return toList;
    }

    public ReentrantLock getNewClientStreamLock() {
        return this.newClientStreamLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Http2Stream acceptStream(HttpRequestPacket request, int streamId, int parentStreamId, boolean exclusive, int priority) throws Http2SessionException {
        Http2Stream stream = this.newStream(request, streamId, parentStreamId, exclusive, priority);
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                return null;
            }
            if (this.concurrentStreamsCount.get() >= this.getLocalMaxConcurrentStreams()) {
                throw new Http2SessionException(ErrorCode.REFUSED_STREAM);
            }
            if (this.isServer() ? streamId > 0 && (streamId & 1) == 0 : streamId > 0 && (streamId & 1) != 0) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
            }
            if (streamId < this.lastPeerStreamId) {
                throw new Http2SessionException(ErrorCode.PROTOCOL_ERROR);
            }
            this.registerStream(streamId, stream);
            this.lastPeerStreamId = streamId;
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Http2Stream openStream(HttpRequestPacket request, int streamId, int parentStreamId, boolean exclusive, int priority) throws Http2StreamException {
        Http2Stream stream = this.newStream(request, streamId, parentStreamId, exclusive, priority);
        Object object = this.sessionLock;
        synchronized (object) {
            Http2Stream mainStream;
            if (this.isClosed()) {
                throw new Http2StreamException(streamId, ErrorCode.REFUSED_STREAM, "Session is closed");
            }
            if (this.concurrentStreamsCount.get() >= this.getLocalMaxConcurrentStreams()) {
                throw new Http2StreamException(streamId, ErrorCode.REFUSED_STREAM);
            }
            if (parentStreamId > 0 && (mainStream = this.getStream(parentStreamId)) == null) {
                throw new Http2StreamException(streamId, ErrorCode.REFUSED_STREAM, "The parent stream does not exist");
            }
            this.registerStream(streamId, stream);
            this.lastLocalStreamId = streamId;
        }
        return stream;
    }

    public Http2Stream acceptUpgradeStream(HttpRequestPacket request, int priority, boolean fin) throws Http2StreamException {
        request.setExpectContent(!fin);
        Http2Stream stream = this.newUpgradeStream(request, priority);
        this.registerUpgradeStream(stream);
        return stream;
    }

    public Http2Stream openUpgradeStream(HttpRequestPacket request, int priority) throws Http2StreamException {
        Http2Stream stream = this.newUpgradeStream(request, priority);
        this.registerUpgradeStream(stream);
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupFilterChains(FilterChainContext context, boolean isUpStream) {
        if (this.htt2SessionChain == null) {
            Http2Session http2Session = this;
            synchronized (http2Session) {
                if (this.htt2SessionChain == null) {
                    if (isUpStream) {
                        this.http2StreamChain = (FilterChain)context.getFilterChain().subList(context.getFilterIdx(), context.getEndIdx());
                        this.htt2SessionChain = (FilterChain)context.getFilterChain().subList(context.getStartIdx(), context.getFilterIdx());
                    } else {
                        this.http2StreamChain = (FilterChain)context.getFilterChain().subList(context.getFilterIdx(), context.getFilterChain().size());
                        this.htt2SessionChain = (FilterChain)context.getFilterChain().subList(context.getEndIdx() + 1, context.getFilterIdx());
                    }
                }
            }
        }
    }

    FilterChain getHttp2SessionChain() {
        return this.htt2SessionChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterStream() {
        boolean isCloseSession;
        LOGGER.fine("deregisterStream()");
        Object object = this.sessionLock;
        synchronized (object) {
            this.decStreamCount();
            boolean bl = isCloseSession = this.isGoingAway() && this.concurrentStreamsCount.get() <= 0;
            if (!isCloseSession && this.checkCount++ > this.http2Configuration.getCleanFrequencyCheck() && this.streamsMap.size() > this.streamsHighWaterMark) {
                this.checkCount = 0;
                Iterator<Map.Entry<Integer, Http2Stream>> streamIds = this.streamsMap.entrySet().iterator();
                while (streamIds.hasNext()) {
                    Map.Entry<Integer, Http2Stream> entry = streamIds.next();
                    if (!entry.getValue().isClosed()) continue;
                    streamIds.remove();
                }
            }
        }
        if (isCloseSession) {
            if (this.sessionClosed != null) {
                this.sessionClosed.result(this);
            } else {
                this.terminate(ErrorCode.NO_ERROR, "Session closed");
            }
        }
    }

    private boolean isClosed() {
        return this.closeFlag != null;
    }

    void sendMessageUpstreamWithParseNotify(Http2Stream stream, HttpContent httpContent) {
        FilterChainContext upstreamContext = this.http2StreamChain.obtainFilterChainContext(this.connection, stream);
        HttpContext httpContext = httpContent.getHttpHeader().getProcessingState().getHttpContext();
        httpContext.attach(upstreamContext);
        this.handlerFilter.onHttpContentParsed(httpContent, upstreamContext);
        HttpHeader header = httpContent.getHttpHeader();
        if (httpContent.isLast()) {
            this.handlerFilter.onHttpPacketParsed(header, upstreamContext);
        }
        if (header.isSkipRemainder()) {
            return;
        }
        this.sendMessageUpstream(stream, httpContent, upstreamContext);
    }

    void sendMessageUpstream(Http2Stream stream, HttpPacket message) {
        FilterChainContext upstreamContext = this.http2StreamChain.obtainFilterChainContext(this.connection, stream);
        HttpContext httpContext = message.getHttpHeader().getProcessingState().getHttpContext();
        httpContext.attach(upstreamContext);
        this.sendMessageUpstream(stream, message, upstreamContext);
    }

    private void sendMessageUpstream(final Http2Stream stream, HttpPacket message, FilterChainContext upstreamContext) {
        upstreamContext.getInternalContext().setIoEvent(IOEvent.READ);
        upstreamContext.getInternalContext().addLifeCycleListener(new IOEventLifeCycleListener.Adapter(){

            @Override
            public void onReregister(Context context) throws IOException {
                stream.inputBuffer.onReadEventComplete();
            }

            @Override
            public void onComplete(Context context, Object data) throws IOException {
                stream.inputBuffer.onReadEventComplete();
            }
        });
        upstreamContext.setMessage(message);
        upstreamContext.setAddressHolder(this.addressHolder);
        ProcessorExecutor.execute(upstreamContext.getInternalContext());
    }

    protected SettingsFrame.SettingsFrameBuilder prepareSettings() {
        SettingsFrame.SettingsFrameBuilder builder = SettingsFrame.builder();
        if (this.getLocalMaxConcurrentStreams() != this.getDefaultMaxConcurrentStreams()) {
            builder.setting(3, this.getLocalMaxConcurrentStreams());
        }
        if (this.getLocalStreamWindowSize() != this.getDefaultStreamWindowSize()) {
            builder.setting(4, this.getLocalStreamWindowSize());
        }
        builder.setting(6, this.getMaxHeaderListSize());
        return builder;
    }

    void ackConsumedData(int sz) {
        this.ackConsumedData(null, sz);
    }

    void ackConsumedData(Http2Stream stream, int sz) {
        int currentUnackedBytes = this.unackedReadBytes.addAndGet(sz);
        if (this.isPrefaceSent) {
            int windowSize = this.getLocalConnectionWindowSize();
            if (currentUnackedBytes > windowSize / 3 && this.unackedReadBytes.compareAndSet(currentUnackedBytes, 0)) {
                this.sendWindowUpdate(0, currentUnackedBytes);
            }
            if (stream != null) {
                int streamUnackedBytes = Http2Stream.unackedReadBytesUpdater.addAndGet(stream, sz);
                int streamWindowSize = stream.getLocalWindowSize();
                if (streamUnackedBytes > 0 && streamUnackedBytes > streamWindowSize / 2 && Http2Stream.unackedReadBytesUpdater.compareAndSet(stream, streamUnackedBytes, 0)) {
                    this.sendWindowUpdate(stream.getId(), streamUnackedBytes);
                }
            }
        }
    }

    void registerStream(int streamId, Http2Stream stream) {
        if (streamId < 1) {
            throw new IllegalArgumentException("Invalid stream ID");
        }
        if (stream == null) {
            throw new NullPointerException("Attempt to register null stream");
        }
        this.streamsMap.put(streamId, stream);
        this.incStreamCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerUpgradeStream(Http2Stream stream) throws Http2StreamException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new Http2StreamException(1, ErrorCode.REFUSED_STREAM, "Session is closed");
            }
            this.registerStream(1, stream);
            if (!this.isServer()) {
                this.lastLocalStreamId = 1;
            }
        }
    }

    private void incStreamCount() {
        this.concurrentStreamsCount.incrementAndGet();
    }

    private void decStreamCount() {
        this.concurrentStreamsCount.decrementAndGet();
    }

    private final class ConnectionCloseListener
    implements CloseListener<Closeable, CloseType> {
        private ConnectionCloseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClosed(Closeable closeable, CloseType type) throws IOException {
            boolean isClosing;
            NetLogger.logClose(Http2Session.this);
            Iterator<Http2Stream> iterator = Http2Session.this.sessionLock;
            synchronized (iterator) {
                boolean bl = isClosing = !Http2Session.this.isClosed();
                if (isClosing) {
                    Http2Session.this.closeFlag = type;
                }
            }
            if (isClosing) {
                for (Http2Stream stream : Http2Session.this.streamsMap.values()) {
                    stream.closedRemotely();
                }
            }
        }
    }
}

