/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Session {
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String id = null;
    private boolean isValid = true;
    private boolean isNew = true;
    private final long creationTime;
    private long sessionTimeout = -1L;
    private long timestamp = -1L;

    public Session() {
        this(null);
    }

    public Session(String id) {
        this.id = id;
        this.creationTime = this.timestamp = System.currentTimeMillis();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
        if (!isValid) {
            this.timestamp = -1L;
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getIdInternal() {
        return this.id;
    }

    protected void setIdInternal(String id) {
        this.id = id;
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    public ConcurrentMap<String, Object> attributes() {
        return this.attributes;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long access() {
        long localTimeStamp;
        this.timestamp = localTimeStamp = System.currentTimeMillis();
        this.isNew = false;
        return localTimeStamp;
    }
}

