/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.CompilerError;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryAssignExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.ConvertExpression;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.FieldUpdater;
import org.glassfish.rmic.tools.tree.IdentifierExpression;
import org.glassfish.rmic.tools.tree.IntExpression;
import org.glassfish.rmic.tools.tree.LocalMember;
import org.glassfish.rmic.tools.tree.Vset;

public abstract class AssignOpExpression
extends BinaryAssignExpression {
    protected Type itype;
    final int NOINC = Integer.MAX_VALUE;
    protected FieldUpdater updater = null;

    public AssignOpExpression(int op, long where, Expression left, Expression right) {
        super(op, where, left, right);
    }

    @Override
    final void selectType(Environment env, Context ctx, int tm) {
        Type rtype = null;
        switch (this.op) {
            case 5: {
                if (this.left.type == Type.tString) {
                    if (this.right.type == Type.tVoid) {
                        env.error(this.where, "incompatible.type", opNames[this.op], Type.tVoid, Type.tString);
                        this.type = Type.tError;
                    } else {
                        this.type = this.itype = Type.tString;
                    }
                    return;
                }
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                if ((tm & 0x80) != 0) {
                    this.itype = Type.tDouble;
                    break;
                }
                if ((tm & 0x40) != 0) {
                    this.itype = Type.tFloat;
                    break;
                }
                if ((tm & 0x20) != 0) {
                    this.itype = Type.tLong;
                    break;
                }
                this.itype = Type.tInt;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                if ((tm & 1) != 0) {
                    this.itype = Type.tBoolean;
                    break;
                }
                if ((tm & 0x20) != 0) {
                    this.itype = Type.tLong;
                    break;
                }
                this.itype = Type.tInt;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                rtype = Type.tInt;
                if (this.right.type.inMask(62)) {
                    this.right = new ConvertExpression(this.where, Type.tInt, this.right);
                }
                if (this.left.type == Type.tLong) {
                    this.itype = Type.tLong;
                    break;
                }
                this.itype = Type.tInt;
                break;
            }
            default: {
                throw new CompilerError("Bad assignOp type: " + this.op);
            }
        }
        if (rtype == null) {
            rtype = this.itype;
        }
        this.right = this.convert(env, ctx, rtype, this.right);
        this.type = this.left.type;
    }

    int getIncrement() {
        if (this.left.op == 60 && this.type.isType(4) && this.right.op == 65 && (this.op == 5 || this.op == 6) && ((IdentifierExpression)this.left).field.isLocal()) {
            int val = ((IntExpression)this.right).value;
            if (this.op == 6) {
                val = -val;
            }
            if (val == (short)val) {
                return val;
            }
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Vset checkValue(Environment env, Context ctx, Vset vset, Hashtable<Object, Object> exp) {
        vset = this.left.checkAssignOp(env, ctx, vset, exp, this);
        vset = this.right.checkValue(env, ctx, vset, exp);
        int tm = this.left.type.getTypeMask() | this.right.type.getTypeMask();
        if ((tm & 0x2000) != 0) {
            return vset;
        }
        this.selectType(env, ctx, tm);
        if (!this.type.isType(13)) {
            this.convert(env, ctx, this.itype, this.left);
        }
        this.updater = this.left.getUpdater(env, ctx);
        return vset;
    }

    @Override
    public Expression inlineValue(Environment env, Context ctx) {
        this.left = this.left.inlineValue(env, ctx);
        this.right = this.right.inlineValue(env, ctx);
        if (this.updater != null) {
            this.updater = this.updater.inline(env, ctx);
        }
        return this;
    }

    @Override
    public Expression copyInline(Context ctx) {
        AssignOpExpression e = (AssignOpExpression)this.clone();
        e.left = this.left.copyInline(ctx);
        e.right = this.right.copyInline(ctx);
        if (this.updater != null) {
            e.updater = this.updater.copyInline(ctx);
        }
        return e;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (this.updater == null) {
            return this.getIncrement() != Integer.MAX_VALUE ? 3 : this.right.costInline(thresh, env, ctx) + this.left.costInline(thresh, env, ctx) + 4;
        }
        return this.right.costInline(thresh, env, ctx) + this.updater.costInline(thresh, env, ctx, true) + 1;
    }

    void code(Environment env, Context ctx, Assembler asm, boolean valNeeded) {
        int val = this.getIncrement();
        if (val != Integer.MAX_VALUE && this.updater == null) {
            int v = ((LocalMember)((IdentifierExpression)this.left).field).number;
            int[] operands = new int[]{v, val};
            asm.add(this.where, 132, operands);
            if (valNeeded) {
                this.left.codeValue(env, ctx, asm);
            }
            return;
        }
        if (this.updater == null) {
            int depth = this.left.codeLValue(env, ctx, asm);
            this.codeDup(env, ctx, asm, depth, 0);
            this.left.codeLoad(env, ctx, asm);
            this.codeConversion(env, ctx, asm, this.left.type, this.itype);
            this.right.codeValue(env, ctx, asm);
            this.codeOperation(env, ctx, asm);
            this.codeConversion(env, ctx, asm, this.itype, this.type);
            if (valNeeded) {
                this.codeDup(env, ctx, asm, this.type.stackSize(), depth);
            }
            this.left.codeStore(env, ctx, asm);
        } else {
            this.updater.startUpdate(env, ctx, asm, false);
            this.codeConversion(env, ctx, asm, this.left.type, this.itype);
            this.right.codeValue(env, ctx, asm);
            this.codeOperation(env, ctx, asm);
            this.codeConversion(env, ctx, asm, this.itype, this.type);
            this.updater.finishUpdate(env, ctx, asm, valNeeded);
        }
    }

    @Override
    public void codeValue(Environment env, Context ctx, Assembler asm) {
        this.code(env, ctx, asm, true);
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        this.code(env, ctx, asm, false);
    }

    @Override
    public void print(PrintStream out) {
        out.print("(" + opNames[this.op] + " ");
        this.left.print(out);
        out.print(" ");
        this.right.print(out);
        out.print(")");
    }
}

