/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ClassPathUtils {
    private static final Function<Path, URL> TO_URL = p -> {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not convert path to url: " + String.valueOf(p), e);
        }
    };

    ClassPathUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String getMainClass(File clientJarFile) {
        try (JarFile jarFile = new JarFile(clientJarFile);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                String string = null;
                return string;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String string = mainAttributes.getValue("Main-Class");
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not detect the main class from the manifest of " + String.valueOf(clientJarFile), e);
        }
    }

    static String getClassPathForGfClient(String clientJarPath) {
        URL[] classpath = ClassPathUtils.getJavaClassPathForAppClient();
        if (classpath.length == 0) {
            return clientJarPath;
        }
        return clientJarPath + File.pathSeparator + Stream.of(classpath).map(ClassPathUtils::convertToString).distinct().collect(Collectors.joining(File.pathSeparator));
    }

    private static URL[] getJavaClassPathForAppClient() {
        List<Path> paths = ClassPathUtils.convertClassPathToPaths(System.getProperty("java.class.path"));
        ArrayList<URL> result = new ArrayList<URL>();
        for (Path path : paths) {
            result.add(TO_URL.apply(path));
        }
        result.addAll(ClassPathUtils.convertClassPathToURLs(System.getenv("APPCPATH")));
        return (URL[])result.toArray(URL[]::new);
    }

    private static List<URL> convertClassPathToURLs(String classPath) {
        return ClassPathUtils.convertClassPathToPaths(classPath).stream().map(TO_URL).collect(Collectors.toList());
    }

    private static List<Path> convertClassPathToPaths(String classPath) {
        if (classPath == null || classPath.isBlank()) {
            return Collections.emptyList();
        }
        try {
            String[] paths = classPath.split(File.pathSeparator);
            ArrayList<Path> result = new ArrayList<Path>(paths.length);
            for (String classPathElement : paths) {
                result.add(new File(classPathElement.trim()).toPath().normalize());
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse the classpath: " + classPath, e);
        }
    }

    private static String convertToString(URL url) {
        try {
            return new File(url.toURI()).toPath().toAbsolutePath().normalize().toFile().getAbsolutePath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot convert to URI string: " + String.valueOf(url), e);
        }
    }
}

