/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.authentication;

import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.authentication.AuthenticationService;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBContext;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.ejb.api.EJBInvocation;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class BasicPasswordAuthenticationService
implements AuthenticationService {
    private static final Logger LOG = LogDomains.getLogger(BasicPasswordAuthenticationService.class, (String)"jakarta.enterprise.resource.resourceadapter", (boolean)false);
    private final String rarName;
    private final PoolInfo poolInfo;
    private final ConnectorRegistry connectorRegistry = ConnectorRegistry.getInstance();

    public BasicPasswordAuthenticationService(String rarName, PoolInfo poolInfo) {
        this.rarName = rarName;
        this.poolInfo = poolInfo;
        LOG.log(Level.FINE, "Constructor:BasicPasswordAuthenticationService");
    }

    @Override
    public ResourcePrincipalDescriptor mapPrincipal(Principal callerPrincipal, Set<Principal> principals) {
        RuntimeSecurityMap runtimeSecurityMap = this.connectorRegistry.getRuntimeSecurityMap(this.poolInfo);
        if (runtimeSecurityMap == null) {
            return null;
        }
        String principalName = callerPrincipal.getName();
        ArrayList<String> groupNames = new ArrayList<String>();
        for (Principal principal : principals) {
            if (principal.equals(callerPrincipal)) continue;
            groupNames.add(principal.getName());
        }
        if (this.isContainerContextAWebModuleObject()) {
            String roleName = this.getRoleName(callerPrincipal);
            return this.doMap(principalName, groupNames, roleName, runtimeSecurityMap);
        }
        return this.doMap(principalName, groupNames, null, runtimeSecurityMap);
    }

    private ResourcePrincipalDescriptor doMap(String principalName, List<String> groupNames, String roleName, RuntimeSecurityMap runtimeSecurityMap) {
        HashMap<String, ResourcePrincipalDescriptor> userNameSecurityMap = runtimeSecurityMap.getUserMap();
        HashMap<String, ResourcePrincipalDescriptor> groupNameSecurityMap = runtimeSecurityMap.getGroupMap();
        if (userNameSecurityMap.containsKey(principalName)) {
            return (ResourcePrincipalDescriptor)userNameSecurityMap.get(principalName);
        }
        if (this.isContainerContextAWebModuleObject() && roleName != null && groupNameSecurityMap.containsKey(roleName)) {
            return (ResourcePrincipalDescriptor)groupNameSecurityMap.get(roleName);
        }
        if (this.isContainerContextAEJBContainerObject() && roleName == null) {
            ComponentInvocation componentInvocation = ConnectorRuntime.getRuntime().getInvocationManager().getCurrentInvocation();
            EJBInvocation ejbInvocation = (EJBInvocation)componentInvocation;
            EJBContext ejbcontext = ejbInvocation.getEJBContext();
            Set s = groupNameSecurityMap.entrySet();
            for (Map.Entry mapEntry : s) {
                String key = (String)mapEntry.getKey();
                ResourcePrincipalDescriptor entry = (ResourcePrincipalDescriptor)mapEntry.getValue();
                boolean isInRole = false;
                try {
                    isInRole = ejbcontext.isCallerInRole(key);
                }
                catch (Exception ex) {
                    LOG.log(Level.FINE, "BasicPasswordAuthentication::caller not in role {0}", key);
                }
                if (!isInRole) continue;
                return entry;
            }
        }
        for (String groupName : groupNames) {
            if (!groupNameSecurityMap.containsKey(groupName)) continue;
            return (ResourcePrincipalDescriptor)groupNameSecurityMap.get(groupName);
        }
        if (userNameSecurityMap.containsKey("*")) {
            return (ResourcePrincipalDescriptor)userNameSecurityMap.get("*");
        }
        if (groupNameSecurityMap.containsKey("*")) {
            return (ResourcePrincipalDescriptor)groupNameSecurityMap.get("*");
        }
        return null;
    }

    private String getRoleName(Principal callerPrincipal) {
        WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)this.getComponentEnvManager().getCurrentJndiNameEnvironment();
        SecurityRoleMapperFactory securityRoleMapperFactory = this.getSecurityRoleMapperFactory();
        SecurityRoleMapper securityRoleMapper = securityRoleMapperFactory.getRoleMapper(webBundleDescriptor.getModuleID());
        Map map = securityRoleMapper.getRoleToSubjectMapping();
        for (Map.Entry entry : map.entrySet()) {
            String roleName = (String)entry.getKey();
            Subject subject = (Subject)entry.getValue();
            Set<Principal> principalSet = subject.getPrincipals();
            if (!principalSet.contains(callerPrincipal)) continue;
            return roleName;
        }
        return "";
    }

    private ComponentEnvManager getComponentEnvManager() {
        return ConnectorRuntime.getRuntime().getComponentEnvManager();
    }

    private ComponentInvocation getCurrentComponentInvocation() {
        return ConnectorRuntime.getRuntime().getInvocationManager().getCurrentInvocation();
    }

    private ComponentInvocation.ComponentInvocationType getCurrentComponentType() {
        return this.getCurrentComponentInvocation().getInvocationType();
    }

    private boolean isContainerContextAWebModuleObject() {
        return ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION.equals((Object)this.getCurrentComponentType());
    }

    private boolean isContainerContextAEJBContainerObject() {
        return ComponentInvocation.ComponentInvocationType.EJB_INVOCATION.equals((Object)this.getCurrentComponentType());
    }

    public SecurityRoleMapperFactory getSecurityRoleMapperFactory() {
        return ConnectorRuntime.getRuntime().getSecurityRoleMapperFactory();
    }

    public String toString() {
        return super.toString() + "[" + this.rarName + "]";
    }
}

