/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.appserv.util.cache.LruCache;
import com.sun.ejb.containers.util.cache.LruSessionCache;
import com.sun.ejb.spi.container.SFSBContainerCallback;
import java.util.Properties;

public class NRUSessionCache
extends LruSessionCache {
    protected boolean doOrdering = false;
    protected int orderingThreshold = 0;

    public NRUSessionCache(String cacheName, SFSBContainerCallback container, int cacheIdleTime, int removalTime) {
        super("NRU-" + cacheName, container, cacheIdleTime, removalTime);
    }

    public void init(int maxEntries, float loadFactor, Properties props) {
        super.init(maxEntries, loadFactor, props);
        this.orderingThreshold = (int)(0.75 * (double)this.threshold);
    }

    @Override
    protected BaseCache.CacheItem itemAdded(BaseCache.CacheItem item) {
        BaseCache.CacheItem addedItem = super.itemAdded(item);
        this.doOrdering = this.entryCount >= this.orderingThreshold;
        return addedItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void itemAccessed(BaseCache.CacheItem item) {
        LruCache.LruCacheItem lc = (LruCache.LruCacheItem)item;
        NRUSessionCache nRUSessionCache = this;
        synchronized (nRUSessionCache) {
            if (lc.isTrimmed()) {
                lc.setTrimmed(false);
                BaseCache.CacheItem overflow = super.itemAdded(item);
                if (overflow != null) {
                    this.trimItem(overflow);
                }
            } else if (this.doOrdering) {
                super.itemAccessed(item);
            }
        }
    }

    protected void itemRefreshed(BaseCache.CacheItem item, int oldSize) {
    }

    protected void itemRemoved(BaseCache.CacheItem item) {
        super.itemRemoved(item);
        this.doOrdering = this.entryCount >= this.orderingThreshold;
    }

    @Override
    public void trimTimedoutItems(int maxCount) {
        if (this.doOrdering) {
            super.trimTimedoutItems(maxCount);
        } else {
            this.trimUnSortedTimedoutItems(maxCount);
        }
    }
}

