/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.universal.process.ProcessManager;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.v3.admin.cluster.NodeUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class CreateRemoteNodeCommand
implements AdminCommand {
    static final int DEFAULT_TIMEOUT_MSEC = 300000;
    @Inject
    private CommandRunner cr;
    @Inject
    ServiceLocator locator;
    @Inject
    Nodes nodes;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodehost")
    protected String nodehost;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installdir;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Param(optional=true, defaultValue="false")
    boolean install;
    @Param(optional=true)
    String archive;
    static final String NL = System.getProperty("line.separator");
    Logger logger = null;
    NodeUtils nodeUtils;
    protected String remotePort;
    protected String remoteUser;
    protected String remotePassword;

    protected abstract void populateBaseClass();

    protected abstract void initialize();

    protected abstract void populateParameters(ParameterMap var1);

    protected abstract void populateCommandArgs(List<String> var1);

    protected abstract RemoteType getType();

    protected abstract void validate() throws CommandValidationException;

    protected abstract List<String> getPasswords();

    protected abstract String getInstallNodeCommandName();

    public final void executeInternal(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        StringBuilder msg = new StringBuilder();
        this.logger = context.getLogger();
        this.initialize();
        this.populateBaseClass();
        this.checkDefaults();
        ParameterMap map = new ParameterMap();
        this.populateParametersInternal(map);
        try {
            this.validate();
        }
        catch (CommandValidationException ex) {
            report.setMessage(ex.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            boolean s;
            this.nodeUtils = new NodeUtils(this.locator);
            this.nodeUtils.validate(map);
            if (this.install && !(s = this.installNode(context)) && !this.force) {
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        catch (CommandValidationException e) {
            String m1 = Strings.get("node.ssh.invalid.params");
            if (!this.force) {
                String m2 = Strings.get("create.node.ssh.not.created", this.getType().toString());
                msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, m2, e.getMessage()}));
                report.setMessage(msg.toString());
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            String m2 = Strings.get("create.node.ssh.continue.force");
            msg.append(StringUtils.cat((String)NL, (String[])new String[]{m1, e.getMessage(), m2}));
        }
        map.remove((Object)"install");
        CommandInvocation ci = this.cr.getCommandInvocation("_create-node", report, context.getSubject());
        ci.parameters(map);
        ci.execute();
        NodeUtils.sanitizeReport(report);
        if (StringUtils.ok((String)report.getMessage())) {
            if (msg.length() > 0) {
                msg.append(NL);
            }
            msg.append(report.getMessage());
        }
        report.setMessage(msg.toString());
    }

    private void populateParametersInternal(ParameterMap map) {
        map.add((Object)"DEFAULT", (Object)this.name);
        map.add((Object)"installdir", (Object)this.installdir);
        map.add((Object)"nodehost", (Object)this.nodehost);
        map.add((Object)"nodedir", (Object)this.nodedir);
        map.add((Object)"sshport", (Object)this.remotePort);
        map.add((Object)"sshuser", (Object)this.remoteUser);
        map.add((Object)"sshpassword", (Object)this.remotePassword);
        map.add((Object)"type", (Object)this.getType().toString());
        map.add((Object)"install", (Object)Boolean.toString(this.install));
        this.populateParameters(map);
    }

    private boolean installNode(AdminCommandContext ctx) throws CommandValidationException {
        File ar;
        boolean res = false;
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getInstallNodeCommandName());
        command.add("--installdir");
        command.add(this.installdir);
        if (this.force) {
            command.add("--force");
        }
        if (this.archive != null && (ar = new File(this.archive)).exists() && ar.canRead()) {
            command.add("--archive");
            command.add(this.archive);
        }
        this.populateCommandArgs(command);
        command.add(this.nodehost);
        StringBuilder out = new StringBuilder();
        int exitCode = this.execCommand(command, out);
        this.logger.info(out.toString().trim());
        ActionReport report = ctx.getActionReport();
        if (exitCode == 0) {
            String msg = Strings.get("create.node.ssh.install.success", this.nodehost);
            report.setMessage(msg);
            res = true;
        } else {
            report.setMessage(out.toString().trim());
        }
        return res;
    }

    protected void checkDefaults() {
        if (!StringUtils.ok((String)this.installdir)) {
            this.installdir = "${com.sun.aas.productRoot}";
        }
        if (!StringUtils.ok((String)this.remoteUser)) {
            this.remoteUser = "${user.name}";
        }
    }

    final int execCommand(List<String> cmdLine, StringBuilder output) {
        int exit = -1;
        ArrayList<String> fullcommand = new ArrayList<String>();
        String installDir = this.nodes.getDefaultLocalNode().getInstallDirUnixStyle() + "/glassfish";
        if (!StringUtils.ok((String)installDir)) {
            throw new IllegalArgumentException(Strings.get("create.node.ssh.no.installdir"));
        }
        File asadmin = new File(SystemPropertyConstants.getAsAdminScriptLocation((String)installDir));
        fullcommand.add(asadmin.getAbsolutePath());
        List<Object> pass = new ArrayList();
        if (this.remotePassword != null) {
            fullcommand.add("--passwordfile");
            fullcommand.add("-");
            pass = this.getPasswords();
        }
        fullcommand.add("--interactive=false");
        fullcommand.addAll(cmdLine);
        ProcessManager pm = new ProcessManager(fullcommand);
        if (!pass.isEmpty()) {
            pm.setStdinLines(pass);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Running command on DAS: " + this.commandListToString(fullcommand));
        }
        pm.setTimeout(300000);
        if (this.logger.isLoggable(Level.FINER)) {
            pm.setEcho(true);
        } else {
            pm.setEcho(false);
        }
        try {
            exit = pm.execute();
        }
        catch (ProcessManagerException ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Error while executing command: " + ex.getMessage());
            }
            exit = 1;
        }
        String stdout = pm.getStdout();
        String stderr = pm.getStderr();
        if (output != null) {
            if (StringUtils.ok((String)stdout)) {
                output.append(stdout);
            }
            if (StringUtils.ok((String)stderr)) {
                if (output.length() > 0) {
                    output.append(NL);
                }
                output.append(stderr);
            }
        }
        return exit;
    }

    final String commandListToString(List<String> command) {
        StringBuilder fullCommand = new StringBuilder();
        for (String s : command) {
            fullCommand.append(" ");
            fullCommand.append(s);
        }
        return fullCommand.toString();
    }
}

