/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout.descriptors.handler;

import com.sun.jsftemplating.layout.descriptors.handler.Handler;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.util.Util;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HandlerDefinition
implements Serializable {
    public static final Class[] EVENT_ARGS = new Class[]{HandlerContext.class};
    private String _id = null;
    private String _description = null;
    private String _methodClass = null;
    private String _methodName = null;
    private transient Method _method = null;
    private Map<String, IODescriptor> _inputDefs = new HashMap<String, IODescriptor>(5);
    private Map<String, IODescriptor> _outputDefs = new HashMap<String, IODescriptor>(5);
    private List<Handler> _childHandlers = _emptyList;
    private transient Boolean _static = null;
    private static final List<Handler> _emptyList = new ArrayList<Handler>(0);
    private static final long serialVersionUID = -6289339732628143599L;

    public HandlerDefinition(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String desc) {
        this._description = desc;
    }

    public void setHandlerMethod(String cls, String methodName) {
        if (cls == null || methodName == null) {
            throw new IllegalArgumentException("Class name and method name must be non-null!");
        }
        this._methodClass = cls;
        this._methodName = methodName;
    }

    public void setHandlerMethod(Method method) {
        if (method != null) {
            this._methodName = method.getName();
            this._methodClass = method.getDeclaringClass().getName();
        } else {
            this._methodName = null;
            this._methodClass = null;
        }
        this._method = method;
    }

    public boolean isStatic() {
        if (this._static == null) {
            this._static = Modifier.isStatic(this.getHandlerMethod().getModifiers());
        }
        return this._static;
    }

    public Method getHandlerMethod() {
        if (this._method != null) {
            return this._method;
        }
        if (this._methodClass != null && this._methodName != null) {
            Class clzz = null;
            try {
                clzz = Util.loadClass(this._methodClass, this._methodClass);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException("'" + this._methodClass + "' not found for method '" + this._methodName + "'!", ex);
            }
            Method method = null;
            try {
                method = clzz.getMethod(this._methodName, EVENT_ARGS);
            }
            catch (NoSuchMethodException ex) {
                throw new RuntimeException("Method '" + this._methodName + "' not found!", ex);
            }
            this._method = method;
        }
        return this._method;
    }

    public void addInputDef(IODescriptor desc) {
        this._inputDefs.put(desc.getName(), desc);
    }

    public void setInputDefs(Map<String, IODescriptor> inputDefs) {
        if (inputDefs == null) {
            throw new IllegalArgumentException("inputDefs cannot be null!");
        }
        this._inputDefs = inputDefs;
    }

    public Map<String, IODescriptor> getInputDefs() {
        return this._inputDefs;
    }

    public IODescriptor getInputDef(String name) {
        return this._inputDefs.get(name);
    }

    public void addOutputDef(IODescriptor desc) {
        this._outputDefs.put(desc.getName(), desc);
    }

    public void setOutputDefs(Map<String, IODescriptor> outputDefs) {
        if (outputDefs == null) {
            throw new IllegalArgumentException("outputDefs cannot be null!");
        }
        this._outputDefs = outputDefs;
    }

    public Map<String, IODescriptor> getOutputDefs() {
        return this._outputDefs;
    }

    public IODescriptor getOutputDef(String name) {
        return this._outputDefs.get(name);
    }

    public void addChildHandler(Handler desc) {
        if (this._childHandlers == _emptyList) {
            this._childHandlers = new ArrayList<Handler>();
        }
        this._childHandlers.add(desc);
    }

    public void setChildHandlers(List<Handler> childHandlers) {
        if (childHandlers == null || childHandlers.size() == 0) {
            childHandlers = _emptyList;
        }
        this._childHandlers = childHandlers;
    }

    public List<Handler> getChildHandlers() {
        return this._childHandlers;
    }

    public String toString() {
        Formatter printf = new Formatter();
        printf.format("%-40s  %s.%s\n", this._id, this._methodClass, this._methodName);
        if (this._description != null) {
            printf.format("%s\n", this._description);
        }
        Iterator<IODescriptor> it = this._inputDefs.values().iterator();
        while (it.hasNext()) {
            printf.format("    INPUT>  %s\n", it.next().toString());
        }
        it = this._outputDefs.values().iterator();
        while (it.hasNext()) {
            printf.format("    OUTPUT> %s\n", it.next().toString());
        }
        return printf.toString();
    }
}

