/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;

public class OperationLock {
    public final Lock readLock;
    public final Lock writeLock;

    public OperationLock(ReadWriteLock readWriteLock) {
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    public void doLocked(Supplier<Boolean> condition, Runnable runnable) {
        if (this.doReadLocked(condition).booleanValue()) {
            this.doWriteLocked(() -> {
                if (((Boolean)condition.get()).booleanValue()) {
                    runnable.run();
                }
            });
        }
    }

    public <T> T doReadLocked(Supplier<T> supplier) {
        this.readLock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T doWriteLocked(Supplier<T> supplier) {
        this.writeLock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void doWriteLocked(Runnable runnable) {
        this.writeLock.lock();
        try {
            runnable.run();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

