/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.spi;

import com.ibm.jbatch.spi.BatchJobUtil;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.DatabaseAlreadyInitializedException;
import com.ibm.jbatch.spi.DatabaseConfigurationBean;
import com.ibm.jbatch.spi.ExecutorServiceProvider;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public final class BatchSPIManager {
    private static final String sourceClass = BatchSPIManager.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Properties overrideProperties = new Properties();
    private PlatformMode platformMode = null;
    private static final BatchSPIManager INSTANCE = new BatchSPIManager();
    private BatchJobUtil batchJobUtil = null;
    private BatchSecurityHelper batchSecurityHelper = null;
    private ExecutorServiceProvider executorServiceProvider = null;
    private final byte[] databaseConfigurationCompleteLock = new byte[0];
    private Boolean databaseConfigurationComplete = Boolean.FALSE;
    private DatabaseConfigurationBean dataBaseConfigurationBean = null;

    private BatchSPIManager() {
    }

    public static BatchSPIManager getInstance() {
        return INSTANCE;
    }

    public BatchJobUtil getBatchJobUtil() {
        return this.batchJobUtil;
    }

    public BatchSecurityHelper getBatchSecurityHelper() {
        return this.batchSecurityHelper;
    }

    public PlatformMode getPlatformMode() {
        return this.platformMode;
    }

    public ExecutorServiceProvider getExecutorServiceProvider() {
        return this.executorServiceProvider;
    }

    public Properties getBatchContainerOverrideProperties() {
        return this.overrideProperties;
    }

    public void registerBatchJobUtil(BatchJobUtil helper) {
        this.batchJobUtil = helper;
    }

    public void registerBatchSecurityHelper(BatchSecurityHelper helper) {
        this.batchSecurityHelper = helper;
    }

    public void registerPlatformMode(PlatformMode mode) {
        this.platformMode = mode;
        if (mode.equals((Object)PlatformMode.EE)) {
            logger.config("Batch configured in EE mode by SPI, taking precedence over properties file");
        } else if (mode.equals((Object)PlatformMode.SE)) {
            logger.config("Batch configured in SE mode by SPI, taking precedence over properties file");
        }
    }

    public void registerExecutorServiceProvider(ExecutorServiceProvider provider) {
        this.executorServiceProvider = provider;
    }

    public void registerBatchContainerOverrideProperties(Properties properties) {
        logger.finer("Overriding properties file based config with programmatic config using properties: " + properties);
        this.overrideProperties.putAll((Map<?, ?>)properties);
    }

    public DatabaseConfigurationBean getDataBaseConfigurationBean() {
        return this.dataBaseConfigurationBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatabaseConfigurationBean(DatabaseConfigurationBean bean) throws DatabaseAlreadyInitializedException {
        byte[] byArray = this.databaseConfigurationCompleteLock;
        synchronized (this.databaseConfigurationCompleteLock) {
            if (this.databaseConfigurationComplete.booleanValue()) {
                throw new DatabaseAlreadyInitializedException("Tried to set database configuration but it's too late, since configuration has already been hardened.");
            }
            this.dataBaseConfigurationBean = bean;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseConfigurationBean getFinalDatabaseConfiguration() {
        byte[] byArray = this.databaseConfigurationCompleteLock;
        synchronized (this.databaseConfigurationCompleteLock) {
            this.databaseConfigurationComplete = Boolean.TRUE;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.dataBaseConfigurationBean;
        }
    }

    public static enum PlatformMode {
        SE,
        EE;

    }
}

