/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedByteCode;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Row;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.SQLSessionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.DMLWriteGeneratedColumnsResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

public abstract class BaseActivation
implements CursorActivation,
GeneratedByteCode {
    private LanguageConnectionContext lcc;
    protected ContextManager cm;
    protected ExecPreparedStatement preStmt;
    protected ResultSet resultSet;
    protected ResultDescription resultDescription;
    protected boolean closed;
    private String cursorName;
    protected int numSubqueries;
    private boolean singleExecution;
    private volatile boolean inUse;
    private java.sql.ResultSet targetVTI;
    private SQLWarning warnings;
    private GeneratedClass gc;
    private boolean checkRowCounts;
    private HashSet<Integer> rowCountsCheckedThisExecution = new HashSet(4, 0.9f);
    private static final long MAX_SQRT = (long)Math.sqrt(9.223372036854776E18);
    private static final int TEN_PERCENT_THRESHOLD = 400;
    private ConglomerateController updateHeapCC;
    private ScanController indexSC;
    private long indexConglomerateNumber = -1L;
    private TableDescriptor ddlTableDescriptor;
    private long maxRows = -1L;
    private boolean forCreateTable;
    private boolean scrollable;
    private boolean resultSetHoldability;
    private CursorResultSet forUpdateIndexScan;
    private boolean autoGeneratedKeysResultSetMode;
    private int[] autoGeneratedKeysColumnIndexes;
    private String[] autoGeneratedKeysColumnNames;
    private boolean isValid;
    protected String UUIDString;
    protected UUID UUIDValue;
    private Activation parentActivation;
    private SQLSessionContext sqlSessionContextForChildren;
    private Stack<ConstantAction> constantActionStack = new Stack();
    protected int indexOfSessionTableNamesInSavedObjects = -1;
    protected ExecRow[] row;
    protected ParameterValueSet pvs;
    protected CursorResultSet[] raParentResultSets;
    protected Hashtable<String, Vector<TemporaryRowHolder>> parentResultSets;
    private Calendar cal;

    protected BaseActivation() {
    }

    @Override
    public final void initFromContext(Context context) throws StandardException {
        this.cm = context.getContextManager();
        this.lcc = (LanguageConnectionContext)this.cm.getContext("LanguageConnectionContext");
        this.inUse = true;
        this.lcc.addActivation(this);
        this.isValid = true;
        UUIDFactory uUIDFactory = BaseActivation.getMonitor().getUUIDFactory();
        this.UUIDValue = uUIDFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
    }

    @Override
    public final ResultSet execute() throws StandardException {
        this.throwIfClosed("execute");
        this.checkRowCounts = this.shouldWeCheckRowCounts();
        if (this.checkRowCounts) {
            this.rowCountsCheckedThisExecution.clear();
        }
        this.reinit();
        if (this.resultSet == null) {
            this.resultSet = this.decorateResultSet();
        }
        return this.resultSet;
    }

    ResultSet decorateResultSet() throws StandardException {
        return this.createResultSet();
    }

    protected abstract ResultSet createResultSet() throws StandardException;

    protected void reinit() throws StandardException {
    }

    @Override
    public final ExecPreparedStatement getPreparedStatement() {
        return this.preStmt;
    }

    @Override
    public ConstantAction pushConstantAction(ConstantAction constantAction) {
        return this.constantActionStack.push(constantAction);
    }

    @Override
    public ConstantAction popConstantAction() {
        return this.constantActionStack.pop();
    }

    @Override
    public ConstantAction getConstantAction() {
        if (this.constantActionStack.size() > 0) {
            return this.constantActionStack.peek();
        }
        return this.preStmt.getConstantAction();
    }

    @Override
    public final void checkStatementValidity() throws StandardException {
        if (this.preStmt == null || this.preStmt.upToDate(this.gc)) {
            return;
        }
        StandardException standardException = StandardException.newException("XCL32.S", new Object[0]);
        standardException.setReport(1);
        throw standardException;
    }

    public final void setupActivation(ExecPreparedStatement execPreparedStatement, boolean bl) throws StandardException {
        this.preStmt = execPreparedStatement;
        if (execPreparedStatement != null) {
            this.resultDescription = execPreparedStatement.getResultDescription();
            this.scrollable = bl;
            if (this.pvs != null && this.pvs.getParameterCount() != 0) {
                this.pvs.initialize(execPreparedStatement.getParameterTypes());
            }
        } else {
            this.resultDescription = null;
            this.scrollable = false;
        }
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public RowLocation getRowLocationTemplate(int n) {
        RowLocation rowLocation = (RowLocation)this.getPreparedStatement().getSavedObject(n);
        DataValueDescriptor dataValueDescriptor = rowLocation.cloneValue(false);
        return (RowLocation)dataValueDescriptor;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    @Override
    public void reset() throws StandardException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
        this.updateHeapCC = null;
        if (!this.isSingleExecution()) {
            this.clearWarnings();
        }
    }

    @Override
    public final void close() throws StandardException {
        if (!this.closed) {
            this.reset();
            if (this.resultSet != null) {
                this.resultSet.finish();
                this.resultSet = null;
            }
            this.closed = true;
            DependencyManager dependencyManager = this.lcc.getDataDictionary().getDependencyManager();
            dependencyManager.clearDependencies(this.lcc, this);
            this.lcc.removeActivation(this);
            if (this.preStmt != null) {
                this.preStmt.finish(this.lcc);
                this.preStmt = null;
            }
            try {
                this.closeActivationAction();
            }
            catch (Throwable throwable) {
                throw StandardException.plainWrapException(throwable);
            }
        }
    }

    protected void closeActivationAction() throws Exception {
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setSingleExecution() {
        this.singleExecution = true;
    }

    @Override
    public boolean isSingleExecution() {
        return this.singleExecution;
    }

    @Override
    public int getNumSubqueries() {
        return this.numSubqueries;
    }

    @Override
    public boolean isCursorActivation() {
        return false;
    }

    @Override
    public final void setGC(GeneratedClass generatedClass) {
        this.gc = generatedClass;
    }

    @Override
    public final GeneratedClass getGC() {
        return this.gc;
    }

    @Override
    public final GeneratedMethod getMethod(String string) throws StandardException {
        return this.getGC().getMethod(string);
    }

    @Override
    public Object e0() throws StandardException {
        return null;
    }

    @Override
    public Object e1() throws StandardException {
        return null;
    }

    @Override
    public Object e2() throws StandardException {
        return null;
    }

    @Override
    public Object e3() throws StandardException {
        return null;
    }

    @Override
    public Object e4() throws StandardException {
        return null;
    }

    @Override
    public Object e5() throws StandardException {
        return null;
    }

    @Override
    public Object e6() throws StandardException {
        return null;
    }

    @Override
    public Object e7() throws StandardException {
        return null;
    }

    @Override
    public Object e8() throws StandardException {
        return null;
    }

    @Override
    public Object e9() throws StandardException {
        return null;
    }

    @Override
    public boolean checkIfThisActivationHasHoldCursor(String string) {
        if (!this.inUse) {
            return false;
        }
        if (!this.resultSetHoldability) {
            return false;
        }
        if (this.indexOfSessionTableNamesInSavedObjects == -1) {
            return false;
        }
        if (this.resultSet != null && !this.resultSet.isClosed() && this.resultSet.returnsRows()) {
            return ((ArrayList)this.getPreparedStatement().getSavedObject(this.indexOfSessionTableNamesInSavedObjects)).contains(string);
        }
        return false;
    }

    @Override
    public void setCursorName(String string) {
        if (this.isCursorActivation()) {
            this.cursorName = string;
        }
    }

    @Override
    public String getCursorName() {
        return this.isCursorActivation() ? this.cursorName : null;
    }

    @Override
    public void setResultSetHoldability(boolean bl) {
        this.resultSetHoldability = bl;
    }

    @Override
    public boolean getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    @Override
    public void setAutoGeneratedKeysResultsetInfo(int[] nArray, String[] stringArray) {
        this.autoGeneratedKeysResultSetMode = true;
        this.autoGeneratedKeysColumnIndexes = ArrayUtil.copy(nArray);
        this.autoGeneratedKeysColumnNames = ArrayUtil.copy(stringArray);
    }

    @Override
    public boolean getAutoGeneratedKeysResultsetMode() {
        return this.autoGeneratedKeysResultSetMode;
    }

    @Override
    public int[] getAutoGeneratedKeysColumnIndexes() {
        return ArrayUtil.copy(this.autoGeneratedKeysColumnIndexes);
    }

    @Override
    public String[] getAutoGeneratedKeysColumnNames() {
        return ArrayUtil.copy(this.autoGeneratedKeysColumnNames);
    }

    public final ResultSetFactory getResultSetFactory() {
        return this.getExecutionFactory().getResultSetFactory();
    }

    @Override
    public final ExecutionFactory getExecutionFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
    }

    @Override
    public CursorResultSet getTargetResultSet() {
        return null;
    }

    protected DataValueDescriptor getSetAutoincrementValue(int n, long l) throws StandardException {
        NumberDataValue numberDataValue = ((DMLWriteGeneratedColumnsResultSet)this.resultSet).getSetAutoincrementValue(n, l);
        return numberDataValue;
    }

    @Override
    public NumberDataValue getCurrentValueAndAdvance(String string, int n) throws StandardException {
        NumberDataValue numberDataValue = (NumberDataValue)this.getDataValueFactory().getNull(n, 0);
        this.lcc.getDataDictionary().getCurrentValueAndAdvance(string, numberDataValue);
        return numberDataValue;
    }

    @Override
    public CursorResultSet getCursorResultSet() {
        return null;
    }

    public void throwIfClosed(String string) throws StandardException {
        if (this.closed) {
            throw StandardException.newException("XCL05.S", string);
        }
    }

    public static void setColumnPosition(int[] nArray, int n, int n2) {
        nArray[n] = n2;
    }

    public static void allocateQualArray(Qualifier[][] qualifierArray, int n, int n2) {
        qualifierArray[n] = new Qualifier[n2];
    }

    public static void setQualifier(Qualifier[][] qualifierArray, Qualifier qualifier, int n, int n2) {
        qualifierArray[n][n2] = qualifier;
    }

    public static void reinitializeQualifiers(Qualifier[][] qualifierArray) {
        if (qualifierArray != null) {
            for (int i = 0; i < qualifierArray.length; ++i) {
                for (int j = 0; j < qualifierArray[i].length; ++j) {
                    qualifierArray[i][j].reinitialize();
                }
            }
        }
    }

    @Override
    public final void markUnused() {
        if (this.isInUse()) {
            this.inUse = false;
            this.lcc.notifyUnusedActivation();
        }
    }

    @Override
    public final boolean isInUse() {
        return this.inUse;
    }

    @Override
    public void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            this.warnings.setNextWarning(sQLWarning);
        }
    }

    @Override
    public SQLWarning getWarnings() {
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        this.warnings = null;
    }

    protected static void nullToPrimitiveTest(DataValueDescriptor dataValueDescriptor, String string) throws StandardException {
        if (dataValueDescriptor.isNull()) {
            throw StandardException.newException("39004", string);
        }
    }

    @Override
    public void informOfRowCount(NoPutResultSet noPutResultSet, long l) throws StandardException {
        if (this.checkRowCounts) {
            long l2;
            boolean bl = false;
            int n = noPutResultSet.resultSetNumber();
            if (this.rowCountsCheckedThisExecution.add(n) && l != (l2 = this.getPreparedStatement().getInitialRowCount(n, l))) {
                if (l2 >= 400L) {
                    long l3 = l2 / (l - l2);
                    if (Math.abs(l3) <= 10L) {
                        bl = true;
                    }
                } else {
                    long l4 = l - l2;
                    if (Math.abs(l4) <= MAX_SQRT && l4 * l4 > Math.abs(4L * l2)) {
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.preStmt.makeInvalid(23, this.lcc);
            }
        }
    }

    @Override
    public ConglomerateController getHeapConglomerateController() {
        return this.updateHeapCC;
    }

    @Override
    public void setHeapConglomerateController(ConglomerateController conglomerateController) {
        this.updateHeapCC = conglomerateController;
    }

    @Override
    public void clearHeapConglomerateController() {
        this.updateHeapCC = null;
    }

    @Override
    public ScanController getIndexScanController() {
        return this.indexSC;
    }

    @Override
    public void setIndexScanController(ScanController scanController) {
        this.indexSC = scanController;
    }

    @Override
    public long getIndexConglomerateNumber() {
        return this.indexConglomerateNumber;
    }

    @Override
    public void setIndexConglomerateNumber(long l) {
        this.indexConglomerateNumber = l;
    }

    @Override
    public void clearIndexScanInfo() {
        this.indexSC = null;
        this.indexConglomerateNumber = -1L;
    }

    @Override
    public void setForCreateTable() {
        this.forCreateTable = true;
    }

    @Override
    public boolean getForCreateTable() {
        return this.forCreateTable;
    }

    @Override
    public void setDDLTableDescriptor(TableDescriptor tableDescriptor) {
        this.ddlTableDescriptor = tableDescriptor;
    }

    @Override
    public TableDescriptor getDDLTableDescriptor() {
        return this.ddlTableDescriptor;
    }

    @Override
    public void setMaxRows(long l) {
        this.maxRows = l;
    }

    @Override
    public long getMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setTargetVTI(java.sql.ResultSet resultSet) {
        this.targetVTI = resultSet;
    }

    @Override
    public java.sql.ResultSet getTargetVTI() {
        return this.targetVTI;
    }

    protected boolean shouldWeCheckRowCounts() throws StandardException {
        ExecPreparedStatement execPreparedStatement = this.getPreparedStatement();
        int n = execPreparedStatement.incrementExecutionCount();
        if (n == 1) {
            return true;
        }
        if (n < 5) {
            return false;
        }
        int n2 = execPreparedStatement.getStalePlanCheckInterval();
        if (n2 == 0) {
            TransactionController transactionController = this.getTransactionController();
            n2 = PropertyUtil.getServiceInt(transactionController, "derby.language.stalePlanCheckInterval", 5, Integer.MAX_VALUE, 100);
            execPreparedStatement.setStalePlanCheckInterval(n2);
        }
        return n % n2 == 1;
    }

    public final boolean getScrollable() {
        return this.scrollable;
    }

    protected final void setParameterValueSet(int n, boolean bl) {
        this.pvs = this.lcc.getLanguageFactory().newParameterValueSet(this.lcc.getLanguageConnectionFactory().getClassFactory().getClassInspector(), n, bl);
    }

    protected final DataValueDescriptor getParameter(int n) throws StandardException {
        return this.pvs.getParameter(n);
    }

    @Override
    public ParameterValueSet getParameterValueSet() {
        if (this.pvs == null) {
            this.setParameterValueSet(0, false);
        }
        return this.pvs;
    }

    @Override
    public void setParameters(ParameterValueSet parameterValueSet, DataTypeDescriptor[] dataTypeDescriptorArray) throws StandardException {
        if (!this.isClosed()) {
            if (this.pvs == null || dataTypeDescriptorArray == null) {
                this.pvs = parameterValueSet;
                return;
            }
            DataTypeDescriptor[] dataTypeDescriptorArray2 = this.preStmt.getParameterTypes();
            boolean bl = false;
            if (dataTypeDescriptorArray2 != null && dataTypeDescriptorArray2.length == dataTypeDescriptorArray.length) {
                bl = true;
                for (int i = 0; i < dataTypeDescriptorArray.length; ++i) {
                    DataTypeDescriptor dataTypeDescriptor = dataTypeDescriptorArray[i];
                    DataTypeDescriptor dataTypeDescriptor2 = dataTypeDescriptorArray2[i];
                    if (!dataTypeDescriptor.isExactTypeAndLengthMatch(dataTypeDescriptor2)) {
                        bl = false;
                        break;
                    }
                    if (dataTypeDescriptor.isNullable() == dataTypeDescriptor2.isNullable()) continue;
                    bl = false;
                    break;
                }
            }
            if (!bl) {
                throw StandardException.newException("XCL10.S", new Object[0]);
            }
            parameterValueSet.transferDataValues(this.pvs);
        }
    }

    public void throwIfMissingParms() throws StandardException {
        if (this.pvs != null && !this.pvs.allAreSet()) {
            throw StandardException.newException("07000", new Object[0]);
        }
    }

    @Override
    public void setCurrentRow(ExecRow execRow, int n) {
        if (this.row != null) {
            this.row[n] = execRow;
        }
    }

    @Override
    public void clearCurrentRow(int n) {
        if (this.row != null) {
            this.row[n] = null;
        }
    }

    @Override
    public Row getCurrentRow(int n) {
        return this.row[n];
    }

    @Override
    public SQLSessionContext getSQLSessionContextForChildren() {
        return this.sqlSessionContextForChildren;
    }

    @Override
    public SQLSessionContext setupSQLSessionContextForChildren(boolean bl) {
        this.sqlSessionContextForChildren = bl ? this.lcc.createSQLSessionContext() : (this.parentActivation != null ? this.parentActivation.getSQLSessionContextForChildren() : this.lcc.getTopLevelSQLSessionContext());
        return this.sqlSessionContextForChildren;
    }

    @Override
    public void setParentActivation(Activation activation) {
        this.parentActivation = activation;
    }

    @Override
    public Activation getParentActivation() {
        return this.parentActivation;
    }

    protected final DataValueDescriptor getColumnFromRow(int n, int n2) throws StandardException {
        if (this.row[n] == null) {
            return null;
        }
        return this.row[n].getColumn(n2);
    }

    protected void checkPositionedStatement(String string, String string2) throws StandardException {
        ExecPreparedStatement execPreparedStatement = this.getPreparedStatement();
        if (execPreparedStatement == null) {
            return;
        }
        CursorActivation cursorActivation = this.lcc.lookupCursorActivation(string);
        if (cursorActivation != null && !string2.equals(cursorActivation.getPreparedStatement().getObjectName())) {
            execPreparedStatement.makeInvalid(5, this.lcc);
        }
    }

    public NoPutResultSet materializeResultSetIfPossible(NoPutResultSet noPutResultSet) throws StandardException {
        noPutResultSet.openCore();
        Vector<ExecRow> vector = new Vector<ExecRow>();
        int n = 0;
        FormatableBitSet formatableBitSet = null;
        int n2 = this.getLanguageConnectionContext().getOptimizerFactory().getMaxMemoryPerTable();
        ExecRow execRow = noPutResultSet.getNextRowCore();
        if (execRow != null) {
            formatableBitSet = new FormatableBitSet(execRow.nColumns() + 1);
            formatableBitSet.set(1);
        }
        while (execRow != null && (n += execRow.getColumn(1).getLength()) <= n2 && vector.size() <= 512) {
            vector.addElement(execRow.getClone(formatableBitSet));
            execRow = noPutResultSet.getNextRowCore();
        }
        noPutResultSet.close();
        if (execRow == null) {
            int n3 = noPutResultSet.resultSetNumber();
            int n4 = vector.size();
            if (n4 == 0) {
                return new RowResultSet((Activation)this, (ExecRow)null, true, n3, 0.0, 0.0);
            }
            RowResultSet[] rowResultSetArray = new RowResultSet[n4];
            UnionResultSet[] unionResultSetArray = new UnionResultSet[n4 - 1];
            for (int i = 0; i < n4; ++i) {
                rowResultSetArray[i] = new RowResultSet((Activation)this, (ExecRow)vector.elementAt(i), true, n3, 1.0, 0.0);
                if (i <= 0) continue;
                unionResultSetArray[i - 1] = new UnionResultSet(i > 1 ? unionResultSetArray[i - 2] : rowResultSetArray[0], rowResultSetArray[i], this, n3, i + 1, 0.0);
            }
            noPutResultSet.finish();
            if (n4 == 1) {
                return rowResultSetArray[0];
            }
            return unionResultSetArray[unionResultSetArray.length - 1];
        }
        return noPutResultSet;
    }

    @Override
    public void setParentResultSet(TemporaryRowHolder temporaryRowHolder, String string) {
        Vector<TemporaryRowHolder> vector;
        if (this.parentResultSets == null) {
            this.parentResultSets = new Hashtable();
        }
        if ((vector = this.parentResultSets.get(string)) == null) {
            vector = new Vector();
            vector.addElement(temporaryRowHolder);
        } else {
            vector.addElement(temporaryRowHolder);
        }
        this.parentResultSets.put(string, vector);
    }

    @Override
    public Vector<TemporaryRowHolder> getParentResultSet(String string) {
        return this.parentResultSets.get(string);
    }

    @Override
    public Enumeration<String> getParentResultSetKeys() {
        return this.parentResultSets.keys();
    }

    @Override
    public void clearParentResultSets() {
        if (this.parentResultSets != null) {
            this.parentResultSets.clear();
        }
    }

    @Override
    public void setForUpdateIndexScan(CursorResultSet cursorResultSet) {
        this.forUpdateIndexScan = cursorResultSet;
    }

    @Override
    public CursorResultSet getForUpdateIndexScan() {
        return this.forUpdateIndexScan;
    }

    protected Calendar getCalendar() {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
        }
        return this.cal;
    }

    @Override
    public final LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    @Override
    public final TransactionController getTransactionController() {
        return this.lcc.getTransactionExecute();
    }

    public ContextManager getContextManager() {
        return this.cm;
    }

    @Override
    public DataValueFactory getDataValueFactory() {
        return this.getLanguageConnectionContext().getDataValueFactory();
    }

    public Connection getCurrentConnection() throws SQLException {
        ConnectionContext connectionContext = (ConnectionContext)((Object)this.getContextManager().getContext("JDBC_ConnectionContext"));
        return connectionContext.getNestedConnection(true);
    }

    @Override
    public java.sql.ResultSet[][] getDynamicResults() {
        return null;
    }

    @Override
    public int getMaxDynamicResults() {
        return 0;
    }

    public NumberDataValue getDB2Length(DataValueDescriptor dataValueDescriptor, int n, NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = this.getDataValueFactory().getNullInteger(null);
        }
        if (dataValueDescriptor.isNull()) {
            numberDataValue.setToNull();
        } else if (n >= 0) {
            numberDataValue.setValue(n);
        } else {
            numberDataValue.setValue(dataValueDescriptor.getLength());
        }
        return numberDataValue;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return null;
    }

    @Override
    public String getObjectName() {
        return this.UUIDString;
    }

    @Override
    public UUID getObjectID() {
        return this.UUIDValue;
    }

    @Override
    public String getClassType() {
        return "Activation";
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 48: {
                this.isValid = false;
                DependencyManager dependencyManager = languageConnectionContext.getDataDictionary().getDependencyManager();
                dependencyManager.clearDependencies(languageConnectionContext, this);
                break;
            }
            case 47: {
                break;
            }
            case 23: {
                break;
            }
        }
    }

    @Override
    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
    }

    static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }
}

