/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.JMSWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.WebSocketMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.json.JSONWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.STOMPWebSocket;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class MQWebSocketServiceApp
extends WebSocketApplication {
    private static final String SUBPROTOCOL_V12STOMP = "v12.stomp";
    protected static final String JMS = "mqjms";
    protected static final String STOMP = "mqstomp";
    protected static final String JSONSTOMP = "mqjsonstomp";
    private static final String JMS_REQUEST_PATH = "/mqjms";
    private static final String STOMP_REQUEST_PATH = "/mqstomp";
    private static final String JSON_REQUEST_PATH = "/mqjsonstomp";
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private Map<MQWebSocket, WebSocketMQIPConnection> wsMQConnMap = Collections.synchronizedMap(new HashMap());
    private WebSocketIPService service = null;
    private Object java8checkLock = new Object();
    private Class base64Class = null;
    private boolean java8checked = false;

    public MQWebSocketServiceApp(WebSocketIPService svc) {
        this.service = svc;
    }

    public IMQService getMQService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getBase64Class() {
        Object object = this.java8checkLock;
        synchronized (object) {
            return this.base64Class;
        }
    }

    private boolean checkOrigin(HttpRequestPacket request) throws Exception {
        String origin = request.getHeader("Origin");
        List<URL> origins = this.service.getAllowedOrigins();
        URL myurl = this.service.getMyURL();
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, ((Object)((Object)this)).getClass().getSimpleName() + ".checkOrigin(" + String.valueOf(request) + "): origin=" + origin + ", myurl=" + String.valueOf(myurl) + ", allowedOrigins=" + String.valueOf(origins));
        }
        if (origin == null || origins == null) {
            return true;
        }
        URL ou = null;
        try {
            ou = new URL(origin);
        }
        catch (Exception e) {
            this.logger.log(32, this.br.getKString("B4482", origin));
            return false;
        }
        if (!ou.getProtocol().equals(myurl.getProtocol())) {
            return false;
        }
        if (ou.getHost().equals(myurl.getHost())) {
            return true;
        }
        InetAddress oia = InetAddress.getByName(ou.getHost());
        if (oia.equals(InetAddress.getByName(myurl.getHost()))) {
            return true;
        }
        ClusterManager cm = Globals.getClusterManager();
        Iterator itr = cm.getConfigBrokers();
        ClusteredBroker cb = null;
        BrokerMQAddress addr = null;
        while (itr.hasNext()) {
            cb = (ClusteredBroker)itr.next();
            addr = (BrokerMQAddress)cb.getBrokerURL();
            String h = addr.getHost().getCanonicalHostName();
            if (MQWebSocket.getDEBUG()) {
                this.logger.log(8, ((Object)((Object)this)).getClass().getSimpleName() + ".checkOrigin(" + String.valueOf(request) + "), origin=" + String.valueOf(ou) + ", check configured cluster broker " + String.valueOf(addr) + "[" + h + "]");
            }
            if (ou.getHost().equals(h)) {
                return true;
            }
            if (!oia.equals(addr.getHost())) continue;
            return true;
        }
        for (URL url : origins) {
            if (!ou.getProtocol().equals(url.getProtocol())) continue;
            if (ou.getHost().equals(url.getHost())) {
                return true;
            }
            if (!oia.equals(InetAddress.getByName(url.getHost()))) continue;
            return true;
        }
        this.logger.log(32, this.br.getKString("B4481", origin, origins));
        return false;
    }

    protected static boolean isSupportedSubService(String subserv) {
        return subserv.equals(JMS) || subserv.equals(STOMP) || subserv.equals(JSONSTOMP);
    }

    public List<String> getSupportedProtocols(List<String> subProtocol) {
        if (subProtocol.contains(SUBPROTOCOL_V12STOMP)) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(SUBPROTOCOL_V12STOMP);
            return l;
        }
        return super.getSupportedProtocols(subProtocol);
    }

    private boolean isJMSRequest(HttpRequestPacket request) {
        return ("/" + this.service.getName() + JMS_REQUEST_PATH).equals(request.getRequestURI());
    }

    private boolean isSTOMPRequest(HttpRequestPacket request) {
        return ("/" + this.service.getName() + STOMP_REQUEST_PATH).equals(request.getRequestURI());
    }

    private boolean isJSONRequest(HttpRequestPacket request) {
        return ("/" + this.service.getName() + JSON_REQUEST_PATH).equals(request.getRequestURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket request, WebSocketListener ... listeners) {
        if (this.isJMSRequest(request)) {
            return new JMSWebSocket(this, handler, request, listeners);
        }
        if (this.isJSONRequest(request)) {
            Object object = this.java8checkLock;
            synchronized (object) {
                if (!this.java8checked) {
                    try {
                        this.base64Class = Class.forName("java.util.Base64");
                    }
                    catch (ClassNotFoundException e) {
                        this.base64Class = null;
                    }
                    catch (Exception e) {
                        this.base64Class = null;
                        this.logger.logStack(16, e.getMessage(), e);
                    }
                    this.java8checked = true;
                }
            }
            return new JSONWebSocket(this, handler, request, listeners);
        }
        if (this.isSTOMPRequest(request)) {
            return new STOMPWebSocket(this, handler, request, listeners);
        }
        throw new UnsupportedOperationException("MQWebSocketServiceApp.createSocket(" + request.getRequestURI() + ")");
    }

    public void onConnect(WebSocket wsocket) {
        super.onConnect(wsocket);
        try {
            if (wsocket instanceof JMSWebSocket) {
                WebSocketMQIPConnection conn = this.service.createConnection((MQWebSocket)wsocket);
                this.wsMQConnMap.put((MQWebSocket)wsocket, conn);
                Globals.getConnectionManager().addConnection(conn);
                if (MQWebSocket.getDEBUG()) {
                    this.logger.log(8, "MQWebSocketServiceApplication.onConnect(" + String.valueOf(wsocket) + "): " + String.valueOf(conn));
                }
            } else if (MQWebSocket.getDEBUG()) {
                this.logger.log(8, "MQWebSocketServiceApplication.onConnect(" + String.valueOf(wsocket) + ")");
            }
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), e);
        }
    }

    public boolean isApplicationRequest(HttpRequestPacket request) {
        String origin = request.getHeader("Origin");
        String uri = request.getRequestURI();
        this.logger.log(8, this.br.getKString("B1513", String.valueOf(request) + "[uri=" + uri + ", origin=" + origin + "]", this.service.getName()));
        try {
            if (!this.checkOrigin(request)) {
                return false;
            }
        }
        catch (Exception e) {
            this.logger.log(32, e.getMessage(), e);
            return false;
        }
        boolean jms = false;
        boolean stomp = false;
        boolean json = false;
        jms = this.isJMSRequest(request);
        if (jms || (stomp = this.isSTOMPRequest(request)) || (json = this.isJSONRequest(request))) {
            if (MQWebSocket.getDEBUG()) {
                this.logger.log(8, "isApplicationRequest(" + String.valueOf(request) + "): found match[jms=" + jms + ", stomp=" + stomp + ", json=" + json + "]");
            }
            if (jms && !this.service.isSubServiceEnabled(JMS) || stomp && !this.service.isSubServiceEnabled(STOMP) || json && !this.service.isSubServiceEnabled(JSONSTOMP)) {
                String emsg = this.br.getKString("B4449", request.getRequestURI(), this.service.getName());
                this.logger.log(16, emsg);
                return false;
            }
            if ((this.isSTOMPRequest(request) || this.isJSONRequest(request)) && this.service.getServiceType() != 0) {
                String emsg = this.br.getKString("B4449", ServiceType.getServiceTypeString(this.service.getServiceType()), this.service.getName() + "[" + request.getRequestURI() + "]");
                this.logger.log(16, emsg);
                return false;
            }
            return true;
        }
        String emsg = this.br.getKString("B2293", request.getRequestURI(), this.service.getName());
        this.logger.log(16, emsg);
        return false;
    }

    public void onMessage(WebSocket wsocket, String text) {
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onMessage(" + String.valueOf(wsocket) + ", text=" + text + ")");
        }
        if (!(wsocket instanceof MQWebSocket)) {
            String emsg = "Unexpected class: " + wsocket.getClass().getName();
            this.logger.logStack(32, emsg, new Exception(emsg));
            wsocket.close(1003);
            return;
        }
        try {
            if (!(wsocket instanceof JSONWebSocket) && !(wsocket instanceof STOMPWebSocket)) {
                this.logger.log(32, this.br.getKString("B2293", "WebSocket.onMessage(" + String.valueOf(wsocket) + ", String)", this.service.getName()));
                wsocket.close(1003);
                return;
            }
            ((MQWebSocket)wsocket).processData(text);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), e);
        }
    }

    public void onMessage(WebSocket wsocket, byte[] data) {
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onMessage(" + String.valueOf(wsocket) + ", bytes.len=" + data.length + ")");
        }
        if (!(wsocket instanceof MQWebSocket)) {
            String emsg = "Unexpected class: " + wsocket.getClass().getName();
            this.logger.logStack(32, emsg, new Exception(emsg));
            wsocket.close(1003);
            return;
        }
        try {
            if (wsocket instanceof JSONWebSocket) {
                this.logger.log(32, this.br.getKString("B2293", "WebSocket.onMessage(" + String.valueOf(wsocket) + ", byte[])", this.service.getName()));
                wsocket.close(1003);
                return;
            }
            ((MQWebSocket)wsocket).processData(data);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), e);
        }
    }

    public void onClose(WebSocket wsocket, DataFrame frame) {
        super.onClose(wsocket, frame);
        WebSocketMQIPConnection conn = this.wsMQConnMap.get(wsocket);
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onClose(): " + String.valueOf(conn) + "[" + String.valueOf(wsocket) + "]");
        }
        if (conn != null) {
            block5: {
                if (conn.getConnectionState() < 6) {
                    try {
                        conn.destroyConnection(true, 5, this.br.getKString("B0061"));
                    }
                    catch (Exception e) {
                        if (!MQWebSocket.getDEBUG()) break block5;
                        this.logger.log(16, e.getMessage(), e);
                    }
                }
            }
            this.wsMQConnMap.remove(wsocket);
        }
        this.logger.log(8, this.br.getKString("B1505", "@" + wsocket.hashCode() + "[" + String.valueOf(wsocket) + "][" + String.valueOf(frame) + "]"));
    }

    public void onPing(WebSocket wsocket, byte[] bytes) {
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onPing(" + String.valueOf(wsocket) + ", bytes.len=" + bytes.length);
        }
        if (!(wsocket instanceof MQWebSocket)) {
            String emsg = "Unexpected class: " + wsocket.getClass().getName();
            this.logger.logStack(32, emsg, new Exception(emsg));
            wsocket.close(1003);
            return;
        }
    }

    public void onPong(WebSocket wsocket, byte[] bytes) {
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onPong(" + String.valueOf(wsocket) + ", bytes.len=" + bytes.length);
        }
        if (!(wsocket instanceof MQWebSocket)) {
            String emsg = "Unexpected class: " + wsocket.getClass().getName();
            this.logger.logStack(32, emsg, new Exception(emsg));
            wsocket.close(1003);
            return;
        }
    }

    public void onFragment(WebSocket wsocket, String fragment, boolean last) {
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onFragment(" + String.valueOf(wsocket) + ", text=" + fragment + ", last=" + last);
        }
        if (!(wsocket instanceof MQWebSocket)) {
            String emsg = "Unexpected class: " + wsocket.getClass().getName();
            this.logger.logStack(32, emsg, new Exception(emsg));
            wsocket.close(1003);
            return;
        }
        try {
            ((MQWebSocket)wsocket).processData(fragment);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), e);
        }
    }

    public void onFragment(WebSocket wsocket, byte[] fragment, boolean last) {
        if (MQWebSocket.getDEBUG()) {
            this.logger.log(8, "MQWebSocketServiceApp.onFragment(" + String.valueOf(wsocket) + ", bytes.len=" + fragment.length + ", last=" + last);
        }
        if (!(wsocket instanceof MQWebSocket)) {
            String emsg = "Unexpected class: " + wsocket.getClass().getName();
            this.logger.logStack(32, emsg, new Exception(emsg));
            wsocket.close(1003);
            return;
        }
        try {
            ((MQWebSocket)wsocket).processData(fragment);
        }
        catch (Exception e) {
            this.logger.logStack(32, e.getMessage(), e);
        }
    }

    protected WebSocketMQIPConnection getMQIPConnection(MQWebSocket wsocket) {
        return this.wsMQConnMap.get((Object)wsocket);
    }
}

