/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.fullyconnected.BrokerAddressImpl;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ConsumerIterator;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolConsumerUIDIterator;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ClusterConsumerInfo {
    private Logger logger = Globals.getLogger();
    private static final long ConsumerVersionUID = 99353142765567461L;
    private static final String PROP_PREFIX_PENDING_TID = "PENDING-TID:";
    private static final String PROP_PREFIX_PENDING_TID_MID_DCT = "PENDING_TID-MID-DCT:";
    private static final String PROP_PENDING_MESSAGES = "pendingMessages";
    private static final String MID_DCT_SEPARATOR = "#";
    private Cluster c;
    private Collection consumers = null;
    private Map pendingMsgs = null;
    private boolean cleanup = false;
    private GPacket pkt = null;

    private ClusterConsumerInfo(Collection consumers, Cluster c) {
        this.consumers = consumers;
        this.c = c;
    }

    private ClusterConsumerInfo(Consumer consumer, Map pendingMsgs, boolean cleanup, Cluster c) {
        HashSet<Consumer> s = new HashSet<Consumer>();
        s.add(consumer);
        this.consumers = s;
        this.c = c;
        this.pendingMsgs = pendingMsgs;
        this.cleanup = cleanup;
    }

    private ClusterConsumerInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterConsumerInfo newInstance(Collection consumers, Cluster c) {
        return new ClusterConsumerInfo(consumers, c);
    }

    public static ClusterConsumerInfo newInstance(Consumer consumer, Cluster c) {
        return new ClusterConsumerInfo(consumer, null, false, c);
    }

    public static ClusterConsumerInfo newInstance(Consumer consumer, Map pendingMsgs, boolean cleanup, Cluster c) {
        return new ClusterConsumerInfo(consumer, pendingMsgs, cleanup, c);
    }

    public static ClusterConsumerInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterConsumerInfo(pkt, c);
    }

    public GPacket getGPacket(short protocol) {
        return this.getGPacket(protocol, -1, null);
    }

    public GPacket getGPacket(short protocol, int subtype) {
        return this.getGPacket(protocol, subtype, null);
    }

    public GPacket getGPacket(short protocol, int subtype, BrokerAddress broker) {
        assert (this.consumers != null);
        assert (protocol == 5 || protocol == 9);
        if (protocol == 9) assert (subtype == 4 || subtype == 2 || subtype == 3);
        GPacket gp = GPacket.getInstance();
        gp.setType(protocol);
        gp.putProp("C", this.consumers.size());
        if (broker != null && this.pendingMsgs != null && this.pendingMsgs.size() > 0) {
            TransactionUID tid = null;
            LinkedHashMap mm = null;
            SysMessageID sysid = null;
            StringBuilder sb = null;
            StringBuilder sb45 = null;
            StringBuilder oldsb = null;
            Map m = (Map)this.pendingMsgs.get(broker);
            if (m != null) {
                oldsb = new StringBuilder();
                Map.Entry pair2 = null;
                for (Map.Entry pair2 : m.entrySet()) {
                    tid = (TransactionUID)pair2.getKey();
                    mm = (LinkedHashMap)pair2.getValue();
                    sb = new StringBuilder();
                    sb45 = new StringBuilder();
                    Map.Entry entry2 = null;
                    for (Map.Entry entry2 : mm.entrySet()) {
                        sysid = (SysMessageID)entry2.getKey();
                        Integer deliverCnt = (Integer)entry2.getValue();
                        sb.append(sysid).append(MID_DCT_SEPARATOR).append(deliverCnt == null ? 0 : deliverCnt).append(' ');
                        sb45.append(sysid).append(' ');
                        oldsb.append(sysid).append(' ');
                    }
                    if (sb.length() <= 0) continue;
                    gp.putProp(PROP_PREFIX_PENDING_TID_MID_DCT + String.valueOf(tid == null ? "" : tid), String.valueOf(sb.toString()));
                    gp.putProp(PROP_PREFIX_PENDING_TID + String.valueOf(tid == null ? "" : tid), String.valueOf(sb45.toString()));
                }
                gp.putProp(PROP_PENDING_MESSAGES, oldsb.toString());
            }
        }
        if (this.cleanup) {
            gp.putProp("cleanup", Boolean.TRUE);
        }
        if (this.c != null) {
            this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        switch (protocol) {
            case 5: {
                try {
                    ClusterManager cm = Globals.getClusterManager();
                    int csize = 1;
                    if (cm != null && (csize = cm.getConfigBrokerCount()) <= 0) {
                        csize = 1;
                    }
                    int i = 0;
                    Iterator itr = this.consumers.iterator();
                    while (itr.hasNext()) {
                        ChangeRecordInfo cri;
                        ++i;
                        Consumer c = (Consumer)itr.next();
                        int prefetch = c.getPrefetchForRemote() / csize;
                        if (prefetch <= 0) {
                            prefetch = 1;
                        }
                        gp.putProp(c.getConsumerUID().longValue() + ":prefetch", prefetch);
                        ClusterConsumerInfo.writeConsumer(c, dos);
                        if (!(c instanceof Subscription) || (cri = ((Subscription)c).getCurrentChangeRecordInfo(5)) == null) continue;
                        gp.putProp("shareccSeq" + i, cri.getSeq());
                        gp.putProp("shareccUUID" + i, cri.getUUID());
                        gp.putProp("shareccResetUUID" + i, cri.getResetUUID());
                    }
                    dos.flush();
                    bos.flush();
                }
                catch (IOException cm) {
                    // empty catch block
                }
                gp.setPayload(ByteBuffer.wrap(bos.toByteArray()));
                break;
            }
            case 9: {
                gp.putProp("T", subtype);
                try {
                    for (Consumer c : this.consumers) {
                        ClusterConsumerInfo.writeConsumerUID(c.getConsumerUID(), dos);
                    }
                    dos.flush();
                    bos.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                gp.setPayload(ByteBuffer.wrap(bos.toByteArray()));
            }
        }
        return gp;
    }

    public int getConsumerCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp("C");
    }

    public ChangeRecordInfo getShareccInfo(int i) {
        if (this.pkt.getProp("shareccSeq" + i) == null) {
            return null;
        }
        ChangeRecordInfo cri = new ChangeRecordInfo();
        cri.setSeq((Long)this.pkt.getProp("shareccSeq" + i));
        cri.setUUID((String)this.pkt.getProp("shareccUUID" + i));
        cri.setResetUUID((String)this.pkt.getProp("shareccResetUUID" + i));
        cri.setType(this.pkt.getType());
        return cri;
    }

    public int getSubtype() {
        assert (this.pkt != null);
        short type = this.pkt.getType();
        assert (type == 9);
        return (Integer)this.pkt.getProp("T");
    }

    public Iterator getConsumers() throws Exception {
        assert (this.pkt != null);
        short type = this.pkt.getType();
        assert (type == 5);
        return new ConsumerIterator(this.pkt, this.pkt.getPayload().array(), this.getConsumerCount(), this.c.unmarshalBrokerAddress(this.pkt));
    }

    public Iterator getConsumerUIDs() throws Exception {
        assert (this.pkt != null);
        short type = this.pkt.getType();
        assert (type == 9);
        return new ProtocolConsumerUIDIterator(this.pkt.getPayload().array(), this.getConsumerCount(), this.c.unmarshalBrokerAddress(this.pkt));
    }

    public Map<TransactionUID, LinkedHashMap<SysMessageID, Integer>> getPendingMessages() {
        assert (this.pkt != null);
        LinkedHashMap<TransactionUID, LinkedHashMap<SysMessageID, Integer>> m = new LinkedHashMap<TransactionUID, LinkedHashMap<SysMessageID, Integer>>();
        String key2 = null;
        String val = null;
        String tidstr = null;
        TransactionUID tid = null;
        LinkedHashMap<SysMessageID, Integer> sysiddcnts = null;
        for (String key2 : this.pkt.propsKeySet()) {
            tid = null;
            if (!key2.startsWith(PROP_PREFIX_PENDING_TID_MID_DCT)) continue;
            tidstr = key2.substring(PROP_PREFIX_PENDING_TID_MID_DCT.length());
            if (tidstr.length() > 0) {
                tid = new TransactionUID(Long.parseLong(tidstr));
            }
            if ((val = (String)this.pkt.getProp(key2)) == null || val.length() == 0) continue;
            sysiddcnts = this.parsePendingMsgs(val);
            if (m.get(tid) != null) {
                throw new RuntimeException("Unexpected PENDING_TID-MID-DCT: content: duplicated entries(" + String.valueOf(m.get(tid)) + ", " + String.valueOf(sysiddcnts) + ") for " + String.valueOf(tid) + ", " + String.valueOf(m));
            }
            m.put(tid, sysiddcnts);
        }
        if (m.size() > 0) {
            return m;
        }
        key2 = null;
        val = null;
        tidstr = null;
        tid = null;
        sysiddcnts = null;
        for (String key2 : this.pkt.propsKeySet()) {
            tid = null;
            if (!key2.startsWith(PROP_PREFIX_PENDING_TID)) continue;
            tidstr = key2.substring(PROP_PREFIX_PENDING_TID.length());
            if (tidstr.length() > 0) {
                tid = new TransactionUID(Long.parseLong(tidstr));
            }
            if ((val = (String)this.pkt.getProp(key2)) == null || val.length() == 0) continue;
            sysiddcnts = this.parsePendingMsgs(val);
            if (m.get(tid) != null) {
                throw new RuntimeException("Unexpected PENDING-TID: content: duplicated entries(" + String.valueOf(m.get(tid)) + ", " + String.valueOf(sysiddcnts) + ") for " + String.valueOf(tid) + ", " + String.valueOf(m));
            }
            m.put(tid, sysiddcnts);
        }
        if (m.size() > 0) {
            return m;
        }
        val = (String)this.pkt.getProp(PROP_PENDING_MESSAGES);
        if (val == null || val.length() == 0) {
            return null;
        }
        sysiddcnts = this.parsePendingMsgs(val);
        m.put(null, sysiddcnts);
        return m;
    }

    private LinkedHashMap<SysMessageID, Integer> parsePendingMsgs(String val) {
        LinkedHashMap<SysMessageID, Integer> pms = new LinkedHashMap<SysMessageID, Integer>();
        StringTokenizer st = new StringTokenizer(val, " ", false);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s == null || s.trim().equals("")) continue;
            Integer deliverCnt = 0;
            int ind = s.lastIndexOf(MID_DCT_SEPARATOR);
            if (ind != -1 && s.length() > ind + 1) {
                try {
                    deliverCnt = Integer.valueOf(s.substring(ind + 1));
                }
                catch (Exception e) {
                    deliverCnt = 0;
                    this.logger.log(16, e.toString() + " - " + s);
                }
            }
            if (ind == -1) {
                pms.put(SysMessageID.get(s), deliverCnt);
                continue;
            }
            pms.put(SysMessageID.get(s.substring(0, ind)), deliverCnt);
        }
        return pms;
    }

    public boolean isCleanup() {
        assert (this.pkt != null);
        Boolean b = (Boolean)this.pkt.getProp("cleanup");
        if (b != null) {
            return b;
        }
        return false;
    }

    public boolean isConfigSyncResponse() {
        assert (this.pkt != null);
        boolean b = false;
        if (this.pkt.getProp("M") != null) {
            b = (Boolean)this.pkt.getProp("M");
        }
        return b;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public static void writeConsumer(Consumer consumer, DataOutputStream dos) throws IOException {
        String destName = consumer.getDestinationUID().getName();
        ConsumerUID id = consumer.getConsumerUID();
        String durableName = null;
        String clientID = null;
        String selstr = consumer.getSelectorStr();
        boolean noLocalDelivery = consumer.getNoLocal();
        boolean isQueue = consumer.getDestinationUID().isQueue();
        boolean isReady = true;
        boolean setMaxCnt = false;
        int position = consumer.getLockPosition();
        int maxcnt = 1;
        boolean jmsshare = false;
        String ndsubname = null;
        if (consumer instanceof Subscription) {
            Subscription s = (Subscription)consumer;
            maxcnt = s.getMaxNumActiveConsumers();
            setMaxCnt = true;
            jmsshare = s.getJMSShared();
            durableName = s.getDurableName();
            if (jmsshare && durableName == null) {
                ndsubname = s.getNDSubscriptionName();
            }
            clientID = s.getClientID();
            if (!s.isActive()) {
                isReady = false;
            }
        }
        dos.writeLong(99353142765567461L);
        dos.writeUTF(destName);
        dos.writeBoolean(id != null);
        if (id != null) {
            ClusterConsumerInfo.writeConsumerUID(id, dos);
        }
        dos.writeBoolean(clientID != null);
        if (clientID != null) {
            dos.writeUTF(clientID);
        }
        dos.writeBoolean(durableName != null);
        if (durableName != null) {
            dos.writeUTF(durableName);
        }
        dos.writeBoolean(selstr != null);
        if (selstr != null) {
            dos.writeUTF(selstr);
        }
        dos.writeBoolean(isQueue);
        dos.writeBoolean(noLocalDelivery);
        dos.writeBoolean(isReady);
        dos.writeBoolean(setMaxCnt);
        if (setMaxCnt) {
            dos.writeInt(maxcnt);
        }
        dos.writeInt(position);
        dos.writeBoolean(jmsshare);
        dos.writeBoolean(ndsubname != null);
        if (ndsubname != null) {
            dos.writeUTF(ndsubname);
        }
    }

    public static Consumer readConsumer(DataInputStream dis) throws IOException {
        boolean hasSelector;
        boolean hasDurableName;
        boolean hasClientID;
        Logger logger = Globals.getLogger();
        ConsumerUID id = null;
        String destName = null;
        String clientID = null;
        String durableName = null;
        String selstr = null;
        long ver = dis.readLong();
        if (ver != 99353142765567461L) {
            throw new IOException("Wrong Consumer Version " + ver + " expected 99353142765567461");
        }
        destName = dis.readUTF();
        boolean hasId = dis.readBoolean();
        if (hasId) {
            id = ClusterConsumerInfo.readConsumerUID(dis);
        }
        if (hasClientID = dis.readBoolean()) {
            clientID = dis.readUTF();
        }
        if (hasDurableName = dis.readBoolean()) {
            durableName = dis.readUTF();
        }
        if (hasSelector = dis.readBoolean()) {
            selstr = dis.readUTF();
        }
        boolean isQueue = dis.readBoolean();
        boolean noLocalDelivery = dis.readBoolean();
        dis.readBoolean();
        boolean sharedSet = false;
        int sharedcnt = 1;
        try {
            sharedSet = dis.readBoolean();
            if (sharedSet) {
                sharedcnt = dis.readInt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int position = -1;
        try {
            position = dis.readInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean jmsshare = false;
        String ndsubname = null;
        try {
            jmsshare = dis.readBoolean();
            boolean hasndsubname = dis.readBoolean();
            if (hasndsubname) {
                ndsubname = dis.readUTF();
            }
        }
        catch (Exception hasndsubname) {
            // empty catch block
        }
        try {
            DestinationUID dest = DestinationUID.getUID(destName, isQueue);
            if (durableName != null) {
                Subscription sub = Subscription.findCreateDurableSubscription(clientID, durableName, sharedcnt != 1, jmsshare, dest, selstr, noLocalDelivery, false, id, sharedcnt);
                return sub;
            }
            if (sharedSet) {
                Subscription sub = Subscription.findCreateNonDurableSubscription(clientID, selstr, ndsubname, sharedcnt != 1, jmsshare, dest, noLocalDelivery, id, sharedcnt);
                return sub;
            }
            Consumer c = Consumer.newConsumer(dest, selstr, noLocalDelivery, id);
            c.setLockPosition(position);
            return c;
        }
        catch (SelectorFormatException ex) {
            logger.logStack(16, "Got bad selector[" + selstr + "] ", ex);
            IOException ioe = new IOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
        catch (BrokerException ex) {
            if (ex.getStatusCode() == 409 || ex instanceof ConsumerAlreadyAddedException) {
                logger.log(16, ex.getMessage());
            } else {
                logger.logStack(16, ex.getMessage(), ex);
            }
            IOException ioe = new IOException(ex.getMessage());
            ioe.initCause(ex);
            throw ioe;
        }
    }

    public static void writeConsumerUID(ConsumerUID uid, DataOutputStream dos) throws IOException {
        dos.writeLong(uid.longValue());
        dos.writeLong(uid.getConnectionUID() == null ? 0L : uid.getConnectionUID().longValue());
        BrokerAddress brokeraddr = uid.getBrokerAddress();
        if (brokeraddr == null) {
            brokeraddr = Globals.getMyAddress();
        }
        if (brokeraddr == null) {
            try {
                brokeraddr = new BrokerAddressImpl();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        brokeraddr.writeBrokerAddress(dos);
    }

    public static ConsumerUID readConsumerUID(DataInputStream dis) throws IOException {
        long id = dis.readLong();
        ConnectionUID conuid = new ConnectionUID(dis.readLong());
        BrokerAddress tempaddr = Globals.getMyAddress();
        BrokerAddress brokeraddr = (BrokerAddress)tempaddr.clone();
        brokeraddr.readBrokerAddress(dis);
        ConsumerUID cuid = new ConsumerUID(id);
        cuid.setConnectionUID(conuid);
        cuid.setBrokerAddress(brokeraddr);
        return cuid;
    }

    public static GPacket getReplyGPacket(short protocol, int status) {
        GPacket gp = GPacket.getInstance();
        gp.setType(protocol);
        gp.putProp("S", status);
        return gp;
    }
}

