/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Body;
import com.sun.webui.jsf.component.ComplexComponent;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.CookieUtils;
import com.sun.webui.jsf.util.FocusManager;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;

public final class BodyRenderer
extends AbstractRenderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"onClick", "onDblClick", "onMouseDown", "onMouseUp", "onMouseOver", "onMouseMove", "onMouseOut", "onKeyPress", "onKeyDown", "onKeyUp", "onFocus", "onBlur"};
    private static final String[] INT_ATTRIBUTES = new String[]{"tabIndex"};

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        if (component instanceof Body && !((Body)component).isPreserveFocus()) {
            return;
        }
        String id = RenderingUtilities.decodeHiddenField(context, "com_sun_webui_util_FocusManager_focusElementId");
        if (id != null && (id = id.trim()).length() != 0) {
            FocusManager.setRequestFocusElementId(context, id);
        }
    }

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (RenderingUtilities.isPortlet(context) || component == null) {
            return;
        }
        if (!(component instanceof Body)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Body.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        writer.startElement("body", component);
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (RenderingUtilities.isPortlet(context)) {
            return;
        }
        Body body = (Body)component;
        this.addCoreAttributes(context, component, writer, null);
        BodyRenderer.addStringAttributes(context, component, writer, STRING_ATTRIBUTES);
        String onload = body.getOnLoad();
        StringBuffer sb = new StringBuffer(256);
        if (onload != null) {
            sb.append(onload);
            sb.append("; ");
        }
        writer.writeAttribute("onload", (Object)sb.toString(), null);
        String imageUrl = body.getImageURL();
        if (imageUrl != null && imageUrl.length() > 0) {
            String resourceUrl = context.getApplication().getViewHandler().getResourceURL(context, imageUrl);
            writer.writeAttribute("background", (Object)resourceUrl, null);
        }
        String onUnload = body.getOnUnload();
        sb = new StringBuffer(256);
        if (onUnload != null) {
            sb.append(onUnload);
            sb.append("; ");
        }
        writer.writeAttribute("onunload", (Object)sb.toString(), null);
        this.addIntegerAttributes(context, component, writer, INT_ATTRIBUTES);
        writer.write("\n");
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        String focusElementId;
        if (RenderingUtilities.isPortlet(context)) {
            return;
        }
        Body body = (Body)component;
        String id = body.getClientId(context);
        String viewId = context.getViewRoot().getViewId();
        String urlString = context.getApplication().getViewHandler().getActionURL(context, viewId);
        viewId = CookieUtils.getValidCookieName(viewId);
        String defaultFocusElementId = BodyRenderer.getFocusElementId(context, body.getFocus());
        if (defaultFocusElementId != null && defaultFocusElementId.isEmpty()) {
            defaultFocusElementId = null;
        }
        if ((focusElementId = FocusManager.getRequestFocusElementId(context)) != null && focusElementId.isEmpty()) {
            focusElementId = null;
        }
        String focusElementFieldId = "com_sun_webui_util_FocusManager_focusElementId";
        JavaScriptUtilities.renderScripTag(writer, JavaScriptUtilities.renderCall("init_body", viewId, urlString, defaultFocusElementId, focusElementId, focusElementFieldId));
        writer.endElement("body");
        writer.write("\n");
    }

    private static String getFocusElementId(FacesContext context, String id) {
        block5: {
            if (id == null || id.length() == 0) {
                return "";
            }
            String absid = id;
            char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)context);
            if (id.charAt(0) != separatorChar) {
                absid = String.valueOf(separatorChar).concat(id);
            }
            try {
                UIComponent comp = context.getViewRoot().findComponent(absid);
                if (comp != null && comp instanceof ComplexComponent) {
                    return ((ComplexComponent)comp).getFocusElementId(context);
                }
            }
            catch (Exception e) {
                if (!LogUtil.finestEnabled()) break block5;
                LogUtil.finest("BodyRenderer.getFocusElementId: couldn't find component with id " + absid + " rendering focus id as " + id);
            }
        }
        return id;
    }
}

