/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.faces.annotation.Resolver;
import com.sun.webui.jsf.theme.ThemeImages;
import com.sun.webui.jsf.theme.ThemeJavascript;
import com.sun.webui.jsf.theme.ThemeStyles;
import com.sun.webui.jsf.theme.ThemeTemplates;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.context.FacesContext;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;

@Resolver
public final class ThemeELResolver
extends ELResolver {
    private static final String THEME_IMAGES = "themeImages";
    private static final String THEME_JAVASCRIPT = "themeJavascript";
    private static final String THEME_MESSAGES = "themeMessages";
    private static final String THEME_STYLES = "themeStyles";
    private static final String THEME_TEMPLATES = "themeTemplates";

    public Object getValue(ELContext context, Object base, Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (base != null) {
            if (base instanceof Images) {
                result = ((Images)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Javascript) {
                result = ((Javascript)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Messages) {
                result = ((Messages)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Styles) {
                result = ((Styles)base).getValue(property.toString());
                context.setPropertyResolved(true);
            } else if (base instanceof Templates) {
                result = ((Templates)base).getValue(property.toString());
                context.setPropertyResolved(true);
            }
        } else if (THEME_IMAGES.equals(property)) {
            result = new Images();
            context.setPropertyResolved(true);
        } else if (THEME_JAVASCRIPT.equals(property)) {
            result = new Javascript();
            context.setPropertyResolved(true);
        } else if (THEME_MESSAGES.equals(property)) {
            result = new Messages();
            context.setPropertyResolved(true);
        } else if (THEME_STYLES.equals(property)) {
            result = new Styles();
            context.setPropertyResolved(true);
        } else if (THEME_TEMPLATES.equals(property)) {
            result = new Templates();
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base != null) {
            return;
        }
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (base != null ? base instanceof Images || base instanceof Javascript || base instanceof Messages || base instanceof Styles || base instanceof Templates : THEME_IMAGES.equals(property) || THEME_JAVASCRIPT.equals(property) || THEME_MESSAGES.equals(property) || THEME_STYLES.equals(property) || THEME_TEMPLATES.equals(property)) {
            throw new PropertyNotWritableException(property.toString());
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (context == null) {
            throw new NullPointerException();
        }
        boolean result = false;
        if (base != null) {
            if (base instanceof Images || base instanceof Javascript || base instanceof Messages || base instanceof Styles || base instanceof Templates) {
                result = true;
                context.setPropertyResolved(true);
            }
        } else if (THEME_IMAGES.equals(property) || THEME_JAVASCRIPT.equals(property) || THEME_MESSAGES.equals(property) || THEME_STYLES.equals(property) || THEME_TEMPLATES.equals(property)) {
            result = true;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Class getType(ELContext context, Object base, Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("Property cannot be null.");
        }
        if (context == null) {
            throw new NullPointerException();
        }
        Class<String> result = null;
        if (base != null) {
            if (base instanceof Images || base instanceof Javascript || base instanceof Messages || base instanceof Styles || base instanceof Templates) {
                result = String.class;
                context.setPropertyResolved(true);
            }
        } else if (THEME_IMAGES.equals(property) || THEME_JAVASCRIPT.equals(property) || THEME_MESSAGES.equals(property) || THEME_STYLES.equals(property) || THEME_TEMPLATES.equals(property)) {
            result = String.class;
            context.setPropertyResolved(true);
        }
        return result;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        if (context == null) {
            throw new NullPointerException();
        }
        ArrayList<FeatureDescriptor> result = new ArrayList<FeatureDescriptor>();
        result.add(ThemeELResolver.getFeatureDescriptor(THEME_IMAGES, String.class));
        result.add(ThemeELResolver.getFeatureDescriptor(THEME_JAVASCRIPT, String.class));
        result.add(ThemeELResolver.getFeatureDescriptor(THEME_MESSAGES, String.class));
        result.add(ThemeELResolver.getFeatureDescriptor(THEME_STYLES, String.class));
        result.add(ThemeELResolver.getFeatureDescriptor(THEME_TEMPLATES, String.class));
        return result.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        if (base != null) {
            return null;
        }
        return String.class;
    }

    private static FeatureDescriptor getFeatureDescriptor(String name, Class clazz) {
        FeatureDescriptor desc = new FeatureDescriptor();
        desc.setName(name);
        desc.setDisplayName(name);
        desc.setValue("type", clazz);
        desc.setValue("resolvableAtDesignTime", true);
        return desc;
    }

    private static final class Templates {
        private Templates() {
        }

        public Object getValue(String property) {
            String result;
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeTemplates.class.getField(property);
                result = theme.getPathToTemplate(field.get(null).toString());
            }
            catch (IllegalAccessException e) {
                result = theme.getPathToTemplate(property);
            }
            catch (IllegalArgumentException e) {
                result = theme.getPathToTemplate(property);
            }
            catch (NoSuchFieldException e) {
                result = theme.getPathToTemplate(property);
            }
            catch (SecurityException e) {
                result = theme.getPathToTemplate(property);
            }
            return result;
        }
    }

    private static final class Styles {
        private Styles() {
        }

        public Object getValue(String property) {
            String result;
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeStyles.class.getField(property);
                result = theme.getStyleClass(field.get(null).toString());
            }
            catch (IllegalAccessException e) {
                result = theme.getStyleClass(property);
            }
            catch (IllegalArgumentException e) {
                result = theme.getStyleClass(property);
            }
            catch (NoSuchFieldException e) {
                result = theme.getStyleClass(property);
            }
            catch (SecurityException e) {
                result = theme.getStyleClass(property);
            }
            return result;
        }
    }

    private static final class Messages {
        private Messages() {
        }

        public Object getValue(String property) {
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            String result = theme.getMessage(property);
            return result;
        }
    }

    private static final class Javascript {
        private static final String JS_PREFIX = "JS_PREFIX";
        private static final String MODULE_PATH = "MODULE_PATH";
        private static final String MODULE_PREFIX = "MODULE_PREFIX";

        private Javascript() {
        }

        public Object getValue(String property) {
            String result;
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeJavascript.class.getField(property);
                String value = field.get(null).toString();
                result = JS_PREFIX.equals(property) || MODULE_PATH.equals(property) || MODULE_PREFIX.equals(property) ? theme.getJSString(value) : theme.getPathToJSFile(value);
            }
            catch (IllegalAccessException e) {
                result = theme.getJSString(property);
            }
            catch (IllegalArgumentException e) {
                result = theme.getJSString(property);
            }
            catch (NoSuchFieldException e) {
                result = theme.getJSString(property);
            }
            catch (SecurityException e) {
                result = theme.getJSString(property);
            }
            return result;
        }
    }

    private static final class Images {
        private static final String HEIGHT_SUFFIX = "_HEIGHT";
        private static final String WIDTH_SUFFIX = "_WIDTH";
        private static final String ALT_SUFFIX = "_ALT";

        private Images() {
        }

        public Object getValue(String property) {
            String result;
            if (property == null) {
                throw new PropertyNotFoundException("Property cannot be null.");
            }
            Theme theme = ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
            try {
                Field field = ThemeImages.class.getField(property);
                String value = field.get(null).toString();
                result = property.endsWith(ALT_SUFFIX) ? theme.getMessage(theme.getImageString(value)) : (property.endsWith(HEIGHT_SUFFIX) ? theme.getImageString(value) : (property.endsWith(WIDTH_SUFFIX) ? theme.getImageString(value) : theme.getImage(value).getPath()));
            }
            catch (IllegalAccessException e) {
                result = theme.getImageString(property);
            }
            catch (IllegalArgumentException e) {
                result = theme.getImageString(property);
            }
            catch (NoSuchFieldException e) {
                result = theme.getImageString(property);
            }
            catch (SecurityException e) {
                result = theme.getImageString(property);
            }
            return result;
        }
    }
}

